% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-igv.R
\name{scale_color_igv}
\alias{scale_color_igv}
\alias{scale_colour_igv}
\alias{scale_fill_igv}
\title{Integrative Genomics Viewer (IGV) color scales}
\usage{
scale_color_igv(palette = c("default", "alternating"), alpha = 1, ...)

scale_colour_igv(palette = c("default", "alternating"), alpha = 1, ...)

scale_fill_igv(palette = c("default", "alternating"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
There are two available options:
\itemize{
\item \code{"default"} (51-color palette).
\item \code{"alternating"} (2-color palette).
}}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_igv]{pal_igv()}} for details.
}
\examples{
p1 <- example_scatterplot()
p2 <- example_barplot()

p1 + scale_color_igv()
p2 + scale_fill_igv()

p1 + ggplot2::scale_colour_manual(
  values = rep(pal_igv("alternating")(2), times = 3)
)
p2 + ggplot2::scale_fill_manual(
  values = rep(pal_igv("alternating")(2), times = 3)
)
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
