% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signif_stars.R
\name{signif_stars}
\alias{signif_stars}
\title{Significance Stars}
\usage{
signif_stars(x, three = 0.001, two = 0.01, one = 0.05, point = 0.1)
}
\arguments{
\item{x}{numeric values that will be compared to the \code{point},
\code{one}, \code{two}, and \code{three} values}

\item{three}{threshold below which to display three stars}

\item{two}{threshold below which to display two stars}

\item{one}{threshold below which to display one star}

\item{point}{threshold below which to display one point
(\code{NULL} to deactivate)}
}
\value{
Character vector containing the appropriate number of
stars for each \code{x} value.
}
\description{
Calculate significance stars
}
\examples{
x <- c(0.5, 0.1, 0.05, 0.01, 0.001)
signif_stars(x)
signif_stars(x, one = .15, point = NULL)
}
\author{
Joseph Larmarange
}
