% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mpoly}
\alias{plot.mpoly}
\title{Plot the (real) variety of a polynomial}
\usage{
\method{plot}{mpoly}(x, xlim, ylim, varorder, add = FALSE, n = 251, nx
  = n, ny = n, f = 0.05, col = "red", ...)
}
\arguments{
\item{x}{an mpoly object}

\item{xlim, ylim}{numeric(2) vectors; x and y limits}

\item{varorder}{character(2); first element is x, second is y, defaults to
\code{sort(vars(poly))}}

\item{add}{logical; should the plot be added to the current device?}

\item{n, nx, ny}{integer specifying number of points in the x and y dimensions}

\item{f}{argument to pass to \code{\link[=extendrange]{extendrange()}}}

\item{col}{color of curve}

\item{...}{arguments to pass to \code{\link[=contour]{contour()}}}
}
\value{
\link{NULL}
}
\description{
The variety must have only 2 variables; it is plotted over a finite window;
and it will not discover zero-dimensional components.
}
\examples{

p <- mp("x^2 + y^2 - 1")
plot(p, xlim = c(-1, 1), ylim = c(-1, 1))
plot(p, xlim = c(-1, 1), ylim = c(-1, 1), asp = 1)

p <- mp("x^2 + 16 y^2 - 1")
plot(p, xlim = c(-1, 1), ylim = c(-1, 1))

p <- mp("u^2 + 16 v^2 - 1")
plot(p, xlim = c(-1, 1), ylim = c(-1, 1))

p <- mp("v^2 + 16 u^2 - 1")
plot(p, xlim = c(-1, 1), ylim = c(-1, 1))

p <- mp("u^2 + 16 v^2 - 1")
plot(p, xlim = c(-1, 1), ylim = c(-1, 1), varorder = c("v","u"))

p <- mp("y^2 - (x^3 + x^2)")
plot(p, xlim = c(-1.5, 1.5), ylim = c(-1.5, 1.5))

plot(lissajous(3, 3, 0, 0), xlim = c(-1, 1), ylim = c(-1, 1), asp = 1)
plot(lissajous(5, 5, 0, 0), col = "steelblue", add = TRUE)

# how it works - inefficient
p <- lissajous(5, 5, 0, 0)
df <- expand.grid(
  x = seq(-1, 1, length.out = 26),
  y = seq(-1, 1, length.out = 26)
)
pf <- as.function(p)
df$z <- structure(pf(df), .Names = "p")
head(df)
with(df, plot(x, y, cex = .75, pch = 16, col = c("firebrick", "steelblue")[(z >= 0) + 1]))
plot(lissajous(5, 5, 0, 0), col = "black", add = TRUE)


}
