% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_overdispersion.R
\name{check_overdispersion}
\alias{check_overdispersion}
\alias{check_overdispersion.performance_simres}
\title{Check overdispersion (and underdispersion) of GL(M)M's}
\usage{
check_overdispersion(x, ...)

\method{check_overdispersion}{performance_simres}(x, alternative = "two.sided", ...)
}
\arguments{
\item{x}{Fitted model of class \code{merMod}, \code{glmmTMB}, \code{glm}, or \code{glm.nb}
(package \strong{MASS}), or an object returned by \code{simulate_residuals()}.}

\item{...}{Arguments passed down to \code{\link[=simulate_residuals]{simulate_residuals()}}. This only applies
for models with zero-inflation component, or for models of class \code{glmmTMB}
from \code{nbinom1} or \code{nbinom2} family.}

\item{alternative}{A character string specifying the alternative hypothesis.
Can be one of \code{"two.sided"}, \code{"less"}, or \code{"greater"}.}
}
\value{
A list with results from the overdispersion test, like chi-squared
statistics, p-value or dispersion ratio.
}
\description{
\code{check_overdispersion()} checks generalized linear (mixed)
models for overdispersion (and underdispersion).
}
\details{
Overdispersion occurs when the observed variance is higher than the
variance of a theoretical model. For Poisson models, variance increases
with the mean and, therefore, variance usually (roughly) equals the mean
value. If the variance is much higher, the data are "overdispersed". A less
common case is underdispersion, where the variance is much lower than the
mean.
}
\section{Interpretation of the Dispersion Ratio}{

If the dispersion ratio is close to one, a Poisson model fits well to the
data. Dispersion ratios larger than one indicate overdispersion, thus a
negative binomial model or similar might fit better to the data. Dispersion
ratios much smaller than one indicate underdispersion. A p-value < .05
indicates either overdispersion or underdispersion (the first being more common).
}

\section{Overdispersion in Poisson Models}{

For Poisson models, the overdispersion test is based on the code from
\emph{Gelman and Hill (2007), page 115}.
}

\section{Overdispersion in Negative Binomial or Zero-Inflated Models}{

For negative binomial (mixed) models or models with zero-inflation component,
the overdispersion test is based simulated residuals (see \code{\link[=simulate_residuals]{simulate_residuals()}}).
}

\section{Overdispersion in Mixed Models}{

For \code{merMod}- and \code{glmmTMB}-objects, \code{check_overdispersion()}
is based on the code in the
\href{http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html}{GLMM FAQ},
section \emph{How can I deal with overdispersion in GLMMs?}. Note that this
function only returns an \emph{approximate} estimate of an overdispersion
parameter. Using this approach would be inaccurate for zero-inflated or
negative binomial mixed models (fitted with \code{glmmTMB}), thus, in such cases,
the overdispersion test is based on \code{\link[=simulate_residuals]{simulate_residuals()}} (which is identical
to \code{check_overdispersion(simulate_residuals(model))}).
}

\section{How to fix Overdispersion}{

Overdispersion can be fixed by either modeling the dispersion parameter, or
by choosing a different distributional family (like Quasi-Poisson, or
negative binomial, see \emph{Gelman and Hill (2007), pages 115-116}).
}

\section{Tests based on simulated residuals}{

For certain models, resp. model from certain families, tests are based on
simulated residuals (see \code{\link[=simulate_residuals]{simulate_residuals()}}). These are usually more
accurate for testing such models than the traditionally used Pearson residuals.
However, when simulating from more complex models, such as mixed models or
models with zero-inflation, there are several important considerations.
Arguments specified in \code{...} are passed to \code{\link[=simulate_residuals]{simulate_residuals()}}, which
relies on \code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}} (and therefore, arguments in \code{...}
are passed further down to \emph{DHARMa}). The defaults in DHARMa are set on the
most conservative option that works for all models. However, in many cases,
the help advises to use different settings in particular situations or for
particular models. It is recommended to read the 'Details' in
\code{?DHARMa::simulateResiduals} closely to understand the implications of the
simulation process and which arguments should be modified to get the most
accurate results.
}

\examples{
\dontshow{if (getRversion() >= "4.0.0" && require("glmmTMB")) withAutoprint(\{ # examplesIf}
data(Salamanders, package = "glmmTMB")
m <- glm(count ~ spp + mined, family = poisson, data = Salamanders)
check_overdispersion(m)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Bolker B et al. (2017):
\href{http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html}{GLMM FAQ.}
\item Gelman, A., and Hill, J. (2007). Data analysis using regression and
multilevel/hierarchical models. Cambridge; New York: Cambridge University
Press.
}
}
\seealso{
Other functions to check model assumptions and and assess model quality: 
\code{\link{check_autocorrelation}()},
\code{\link{check_collinearity}()},
\code{\link{check_convergence}()},
\code{\link{check_heteroscedasticity}()},
\code{\link{check_homogeneity}()},
\code{\link{check_model}()},
\code{\link{check_outliers}()},
\code{\link{check_predictions}()},
\code{\link{check_singularity}()},
\code{\link{check_zeroinflation}()}
}
\concept{functions to check model assumptions and and assess model quality}
