/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datamap;

import java.awt.Component;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesController;
import org.apache.cayenne.modeler.dialog.datamap.DefaultsPreferencesView;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.util.Util;

public class SuperclassUpdateController
extends DefaultsPreferencesController {
    public static final String ALL_CONTROL = "Set/update superclass for all ObjEntities";
    public static final String UNINIT_CONTROL = "Do not override existing non-empty superclasses";
    protected boolean clientUpdate;
    protected DefaultsPreferencesView view;

    public SuperclassUpdateController(ProjectController mediator, DataMap dataMap, boolean clientUpdate) {
        super(mediator, dataMap);
        this.clientUpdate = clientUpdate;
    }

    public void startupAction() {
        this.view = new DefaultsPreferencesView(ALL_CONTROL, UNINIT_CONTROL);
        this.view.setTitle("Update DataObjects Superclass");
        this.initController();
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void initController() {
        this.view.getUpdateButton().addActionListener(e -> this.updateSuperclass());
        this.view.getCancelButton().addActionListener(e -> this.view.dispose());
    }

    protected void updateSuperclass() {
        boolean doAll = this.isAllEntities();
        String defaultSuperclass = this.getSuperclass();
        this.dataMap.getObjEntities().stream().sorted(Comparators.getDataMapChildrenComparator()).forEach(entity -> {
            if ((doAll || Util.isEmptyString(this.getSuperClassName((ObjEntity)entity))) && !Util.nullSafeEquals(defaultSuperclass, this.getSuperClassName((ObjEntity)entity))) {
                this.setSuperClassName((ObjEntity)entity, defaultSuperclass);
                this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)entity));
            }
        });
        this.view.dispose();
    }

    protected String getSuperclass() {
        return this.clientUpdate ? this.dataMap.getDefaultClientSuperclass() : this.dataMap.getDefaultSuperclass();
    }

    protected String getSuperClassName(ObjEntity entity) {
        return this.clientUpdate ? entity.getClientSuperClassName() : entity.getSuperClassName();
    }

    protected void setSuperClassName(ObjEntity entity, String superClassName) {
        if (this.clientUpdate) {
            entity.setClientSuperClassName(superClassName);
        } else {
            entity.setSuperClassName(superClassName);
        }
    }
}

