/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.directory.api.util.GeneralizedTime;

public class KerberosTime
implements Comparable<KerberosTime>,
Serializable {
    private static final long serialVersionUID = -7541256140193748103L;
    public static final KerberosTime INFINITY = new KerberosTime(Long.MAX_VALUE);
    public static final int MINUTE = 60000;
    public static final int DAY = 86400000;
    public static final int WEEK = 604800000;
    private GeneralizedTime generalizedTime;

    public KerberosTime(String date) {
        try {
            this.generalizedTime = new GeneralizedTime(date);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Bad time : " + date);
        }
    }

    public KerberosTime(long date) {
        this.generalizedTime = new GeneralizedTime(date);
    }

    public static KerberosTime getTime(String zuluTime) throws ParseException {
        return new KerberosTime(zuluTime);
    }

    public String getDate() {
        return this.generalizedTime.toGeneralizedTime(GeneralizedTime.Format.YEAR_MONTH_DAY_HOUR_MIN_SEC, GeneralizedTime.FractionDelimiter.DOT, 0, GeneralizedTime.TimeZoneFormat.Z);
    }

    public int hashCode() {
        return (int)(this.generalizedTime.getTime() / 1000L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KerberosTime)) {
            return true;
        }
        KerberosTime other = (KerberosTime)obj;
        return this.generalizedTime.getTime() / 1000L == other.generalizedTime.getTime() / 1000L;
    }

    @Override
    public int compareTo(KerberosTime that) {
        return this.generalizedTime.compareTo(that.generalizedTime);
    }

    public String toString() {
        return this.getDate();
    }
}

