/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integration.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.bridge.http.HttpDirectoryService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.integration.http.WebApp;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.bouncycastle.jce.provider.X509CertParser;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private Server jetty;
    private String confFile;
    private Set<WebApp> webApps;
    private TcpTransport httpTransport = null;
    private TcpTransport httpsTransport = null;
    public static final String HTTP_TRANSPORT_ID = "http";
    public static final String HTTPS_TRANSPORT_ID = "https";
    private boolean configured = false;
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private DirectoryService dirService;

    public void start(DirectoryService dirService) throws Exception {
        this.dirService = dirService;
        XmlConfiguration jettyConf = null;
        if (this.confFile != null) {
            InputStream input = Files.newInputStream(Paths.get(this.confFile, new String[0]), new OpenOption[0]);
            jettyConf = new XmlConfiguration(input);
            LOG.info("configuring jetty http server from the configuration file {}", (Object)this.confFile);
            try {
                this.jetty = new Server();
                jettyConf.configure(this.jetty);
                this.configured = true;
            }
            catch (Exception e) {
                LOG.error(I18n.err(I18n.ERR_120, new Object[0]));
                throw e;
            }
        } else {
            LOG.info("No configuration file set, looking for web apps");
            this.configureServerThroughCode();
        }
        if (this.configured) {
            Handler[] handlers;
            for (Handler h : handlers = this.jetty.getHandlers()) {
                if (!(h instanceof ContextHandler)) continue;
                ContextHandler ch = (ContextHandler)h;
                ch.setAttribute(HttpDirectoryService.KEY, new HttpDirectoryService(dirService));
            }
            LOG.info("starting jetty http server");
            this.jetty.start();
        } else {
            this.jetty = null;
            LOG.warn("Error while configuring the http server, skipping the http server startup");
        }
    }

    private void configureServerThroughCode() {
        try {
            this.jetty = new Server();
            if (this.httpTransport != null) {
                ServerConnector httpConnector = new ServerConnector(this.jetty);
                httpConnector.setPort(this.httpTransport.getPort());
                httpConnector.setHost(this.httpTransport.getAddress());
                this.jetty.addConnector(httpConnector);
            }
            if (this.httpsTransport != null) {
                Dn adminDn = this.dirService.getDnFactory().create("uid=admin,ou=system");
                Entry adminEntry = this.dirService.getAdminSession().lookup(adminDn, "*", "+");
                File confDir = this.dirService.getInstanceLayout().getConfDirectory();
                File ksFile = new File(confDir, "httpserver.generated.ks");
                String password = UUID.randomUUID().toString();
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                X509CertParser parser = new X509CertParser();
                parser.engineInit(new ByteArrayInputStream(adminEntry.get("userCertificate").getBytes()));
                X509Certificate cert = (X509Certificate)parser.engineRead();
                ks.setCertificateEntry("cert", cert);
                KeyPair keyPair = TlsKeyGenerator.getKeyPair(adminEntry);
                ks.setKeyEntry("privatekey", keyPair.getPrivate(), password.toCharArray(), new Certificate[]{cert});
                try (OutputStream stream = Files.newOutputStream(ksFile.toPath(), new OpenOption[0]);){
                    ks.store(stream, password.toCharArray());
                }
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStoreType(KeyStore.getDefaultType());
                sslContextFactory.setKeyStorePath(ksFile.getAbsolutePath());
                sslContextFactory.setKeyStorePassword(password);
                sslContextFactory.setKeyManagerPassword(password);
                HttpConfiguration httpsConfiguration = new HttpConfiguration();
                httpsConfiguration.setSecureScheme(HTTPS_TRANSPORT_ID);
                httpsConfiguration.setSecurePort(this.httpsTransport.getPort());
                httpsConfiguration.addCustomizer(new SecureRequestCustomizer());
                ServerConnector httpsConnector = new ServerConnector(this.jetty, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration));
                httpsConnector.setPort(this.httpsTransport.getPort());
                httpsConnector.setHost(this.httpsTransport.getAddress());
                this.jetty.addConnector(httpsConnector);
            }
            HandlerList handlers = new HandlerList();
            for (WebApp w : this.webApps) {
                WebAppContext webapp = new WebAppContext();
                webapp.setWar(w.getWarFile());
                webapp.setContextPath(w.getContextPath());
                handlers.addHandler(webapp);
                webapp.setParentLoaderPriority(true);
            }
            File webAppDir = new File(this.dirService.getInstanceLayout().getInstanceDirectory(), "webapps");
            FilenameFilter webAppFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".war");
                }
            };
            if (webAppDir.exists()) {
                File[] appList;
                for (File app : appList = webAppDir.listFiles(webAppFilter)) {
                    WebAppContext webapp = new WebAppContext();
                    webapp.setWar(app.getAbsolutePath());
                    String ctxName = app.getName();
                    int pos = ctxName.indexOf(46);
                    if (pos > 0) {
                        ctxName = ctxName.substring(0, pos);
                    }
                    webapp.setContextPath("/" + ctxName);
                    handlers.addHandler(webapp);
                    webapp.setParentLoaderPriority(true);
                }
            }
            this.jetty.setHandler(handlers);
            this.configured = true;
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_121, new Object[0]), e);
        }
    }

    public void stop() throws Exception {
        if (this.jetty != null && this.jetty.isStarted()) {
            LOG.info("stopping jetty http server");
            this.jetty.stop();
        }
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public Set<WebApp> getWebApps() {
        return this.webApps;
    }

    public void setWebApps(Set<WebApp> webapps) {
        this.webApps = webapps;
    }

    public TcpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public void setHttpTransport(TcpTransport httpTransport) {
        this.httpTransport = httpTransport;
    }

    public TcpTransport getHttpsTransport() {
        return this.httpsTransport;
    }

    public void setHttpsTransport(TcpTransport httpsTransport) {
        this.httpsTransport = httpsTransport;
    }
}

