/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;

public class ModifyDnRequestDecorator
extends SingleReplyRequestDecorator<ModifyDnRequest>
implements ModifyDnRequest {
    private int modifyDnRequestLength;

    public ModifyDnRequestDecorator(LdapApiService codec, ModifyDnRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    public ModifyDnRequest setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    public ModifyDnRequest setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
        return this;
    }

    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    public ModifyDnRequest setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
        return this;
    }

    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    public ModifyDnRequest setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
        return this;
    }

    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }

    public ModifyDnRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public ModifyDnRequest addControl(Control control) {
        return (ModifyDnRequest)super.addControl(control);
    }

    public ModifyDnRequest addAllControls(Control[] controls) {
        return (ModifyDnRequest)super.addAllControls(controls);
    }

    public ModifyDnRequest removeControl(Control control) {
        return (ModifyDnRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        int newRdnlength = Strings.getBytesUtf8((String)this.getNewRdn().getName()).length;
        this.modifyDnRequestLength = 1 + TLV.getNbBytes((int)Dn.getNbBytes((Dn)this.getName())) + Dn.getNbBytes((Dn)this.getName()) + 1 + TLV.getNbBytes((int)newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.getNewSuperior() != null) {
            this.modifyDnRequestLength += 1 + TLV.getNbBytes((int)Dn.getNbBytes((Dn)this.getNewSuperior())) + Dn.getNbBytes((Dn)this.getNewSuperior());
        }
        return 1 + TLV.getNbBytes((int)this.modifyDnRequestLength) + this.modifyDnRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes((int)this.modifyDnRequestLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])Dn.getBytes((Dn)this.getName()));
            BerValue.encode((ByteBuffer)buffer, (String)this.getNewRdn().getName());
            BerValue.encode((ByteBuffer)buffer, (boolean)this.getDeleteOldRdn());
            if (this.getNewSuperior() != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = Dn.getNbBytes((Dn)this.getNewSuperior());
                buffer.put(TLV.getBytes((int)newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(Dn.getBytes((Dn)this.getNewSuperior()));
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

