/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.api;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.Controls;
import org.apache.directory.studio.connection.core.ILdapLogger;
import org.apache.directory.studio.connection.core.io.StudioLdapException;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeDeleteRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class LdifModificationLogger
implements ILdapLogger {
    private String id;
    private String name;
    private String description;
    private Map<String, FileHandler> fileHandlers = new HashMap<String, FileHandler>();
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    public LdifModificationLogger() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ConnectionCoreConstants.PLUGIN_ID);
        prefs.addPreferenceChangeListener(event -> {
            if ("modificationLogsFileCount".equals(event.getKey()) || "modificationLogsFileSize".equals(event.getKey())) {
                Connection[] connections;
                int n;
                for (Logger logger : this.loggers.values()) {
                    Handler[] handlerArray = logger.getHandlers();
                    int n2 = handlerArray.length;
                    n = 0;
                    while (n < n2) {
                        Handler handler = handlerArray[n];
                        handler.close();
                        ++n;
                    }
                }
                Connection[] connectionArray = connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
                n = connections.length;
                int n3 = 0;
                while (n3 < n) {
                    Connection connection = connectionArray[n3];
                    try {
                        File[] logFiles = LdifModificationLogger.getLogFiles(connection);
                        int i = this.getFileCount();
                        while (i < logFiles.length) {
                            if (logFiles[i] != null && logFiles[i].exists()) {
                                logFiles[i].delete();
                            }
                            ++i;
                        }
                    }
                    catch (Exception exception) {}
                    ++n3;
                }
                this.loggers.clear();
            }
        });
    }

    private void initModificationLogger(Connection connection) {
        Logger logger = Logger.getAnonymousLogger();
        this.loggers.put(connection.getId(), logger);
        logger.setLevel(Level.ALL);
        String logfileName = ConnectionManager.getModificationLogFileName(connection);
        try {
            FileHandler fileHandler = new FileHandler(logfileName, this.getFileSizeInKb() * 1000, this.getFileCount(), true);
            this.fileHandlers.put(connection.getId(), fileHandler);
            fileHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            logger.addHandler(fileHandler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose(Connection connection) {
        String id = connection.getId();
        if (this.loggers.containsKey(id)) {
            File[] files;
            Handler[] handlers;
            Handler[] handlerArray = handlers = this.loggers.get(id).getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                handler.close();
                ++n2;
            }
            File[] fileArray = files = LdifModificationLogger.getLogFiles(connection);
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                File file = fileArray[n];
                this.deleteFileWithRetry(file);
                ++n;
            }
            this.loggers.remove(id);
        }
    }

    private void log(String text, StudioLdapException ex, Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initModificationLogger(connection);
        }
        if (this.loggers.containsKey(id)) {
            StringJoiner lines = new StringJoiner("");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            df.setTimeZone(ConnectionCoreConstants.UTC_TIME_ZONE);
            if (ex != null) {
                lines.add(LdifCommentLine.create((String)"#!RESULT ERROR").toFormattedString(LdifFormatParameters.DEFAULT));
            } else {
                lines.add(LdifCommentLine.create((String)"#!RESULT OK").toFormattedString(LdifFormatParameters.DEFAULT));
            }
            lines.add(LdifCommentLine.create((String)("#!CONNECTION ldap://" + connection.getHost() + ":" + connection.getPort())).toFormattedString(LdifFormatParameters.DEFAULT));
            lines.add(LdifCommentLine.create((String)("#!DATE " + df.format(new Date()))).toFormattedString(LdifFormatParameters.DEFAULT));
            if (ex != null) {
                String errorComment = "#!ERROR " + ex.getMessage();
                errorComment = errorComment.replaceAll("\r", " ");
                errorComment = errorComment.replaceAll("\n", " ");
                LdifCommentLine errorCommentLine = LdifCommentLine.create((String)errorComment);
                lines.add(errorCommentLine.toFormattedString(LdifFormatParameters.DEFAULT));
            }
            lines.add(text);
            Logger logger = this.loggers.get(id);
            logger.log(Level.ALL, lines.toString());
        }
    }

    @Override
    public void logChangetypeAdd(Connection connection, Entry entry, Control[] controls, StudioLdapException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        Set<String> maskedAttributes = this.getMaskedAttributes();
        LdifChangeAddRecord record = new LdifChangeAddRecord(LdifDnLine.create((String)entry.getDn().getName()));
        LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
        record.setChangeType(LdifChangeTypeLine.createAdd());
        for (Attribute attribute : entry) {
            String attributeName = attribute.getUpId();
            for (Value value : attribute) {
                if (maskedAttributes.contains(Strings.toLowerCaseAscii((String)attributeName))) {
                    record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)"**********"));
                    continue;
                }
                if (value.isHumanReadable()) {
                    record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)value.getString()));
                    continue;
                }
                record.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])value.getBytes()));
            }
        }
        record.finish(LdifSepLine.create());
        String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
        this.log(formattedString, ex, connection);
    }

    @Override
    public void logChangetypeDelete(Connection connection, Dn dn, Control[] controls, StudioLdapException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        LdifChangeDeleteRecord record = new LdifChangeDeleteRecord(LdifDnLine.create((String)dn.getName()));
        LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
        record.setChangeType(LdifChangeTypeLine.createDelete());
        record.finish(LdifSepLine.create());
        String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
        this.log(formattedString, ex, connection);
    }

    @Override
    public void logChangetypeModify(Connection connection, Dn dn, Collection<Modification> modifications, Control[] controls, StudioLdapException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        Set<String> maskedAttributes = this.getMaskedAttributes();
        LdifChangeModifyRecord record = new LdifChangeModifyRecord(LdifDnLine.create((String)dn.getName()));
        LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
        record.setChangeType(LdifChangeTypeLine.createModify());
        block5: for (Modification item : modifications) {
            LdifModSpec modSpec;
            String attributeName = item.getAttribute().getUpId();
            switch (item.getOperation()) {
                case ADD_ATTRIBUTE: {
                    modSpec = LdifModSpec.createAdd((String)attributeName);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    modSpec = LdifModSpec.createDelete((String)attributeName);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    modSpec = LdifModSpec.createReplace((String)attributeName);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            for (Value value : item.getAttribute()) {
                if (maskedAttributes.contains(Strings.toLowerCaseAscii((String)attributeName))) {
                    modSpec.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)"**********"));
                    continue;
                }
                if (value.isHumanReadable()) {
                    modSpec.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)value.getString()));
                    continue;
                }
                modSpec.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])value.getBytes()));
            }
            modSpec.finish(LdifModSpecSepLine.create());
            record.addModSpec(modSpec);
        }
        record.finish(LdifSepLine.create());
        String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
        this.log(formattedString, ex, connection);
    }

    @Override
    public void logChangetypeModDn(Connection connection, Dn oldDn, Dn newDn, boolean deleteOldRdn, Control[] controls, StudioLdapException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        Rdn newrdn = newDn.getRdn();
        Dn newsuperior = newDn.getParent();
        LdifChangeModDnRecord record = new LdifChangeModDnRecord(LdifDnLine.create((String)oldDn.getName()));
        LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
        record.setChangeType(LdifChangeTypeLine.createModDn());
        record.setNewrdn(LdifNewrdnLine.create((String)newrdn.getName()));
        record.setDeloldrdn(deleteOldRdn ? LdifDeloldrdnLine.create1() : LdifDeloldrdnLine.create0());
        record.setNewsuperior(LdifNewsuperiorLine.create((String)newsuperior.getName()));
        record.finish(LdifSepLine.create());
        String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
        this.log(formattedString, ex, connection);
    }

    private static void addControlLines(LdifChangeRecord record, Control[] controls) {
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                String oid = control.getOid();
                boolean isCritical = control.isCritical();
                byte[] bytes = Controls.getEncodedValue(control);
                LdifControlLine controlLine = LdifControlLine.create((String)oid, (boolean)isCritical, (byte[])bytes);
                record.addControl(controlLine);
                ++n2;
            }
        }
    }

    public File[] getFiles(Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initModificationLogger(connection);
        }
        try {
            return LdifModificationLogger.getLogFiles(connection);
        }
        catch (Exception exception) {
            return new File[0];
        }
    }

    private static File[] getLogFiles(Connection connection) {
        String logfileNamePattern = ConnectionManager.getModificationLogFileName(connection);
        File file = new File(logfileNamePattern);
        String pattern = file.getName().replace("%u", "\\d+").replace("%g", "\\d+");
        File dir = file.getParentFile();
        Object[] files = dir.listFiles((d, f) -> f.matches(pattern));
        Arrays.sort(files);
        return files;
    }

    private boolean isModificationLogEnabled() {
        return Platform.getPreferencesService().getBoolean(ConnectionCoreConstants.PLUGIN_ID, "modificationLogsEnable", true, null);
    }

    private int getFileCount() {
        return Platform.getPreferencesService().getInt(ConnectionCoreConstants.PLUGIN_ID, "modificationLogsFileCount", 10, null);
    }

    private int getFileSizeInKb() {
        return Platform.getPreferencesService().getInt(ConnectionCoreConstants.PLUGIN_ID, "modificationLogsFileSize", 100, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

