/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;

public class AttributeComparator
implements Comparator<Object> {
    private final int sortBy;
    private final int defaultSortBy;
    private final int sortOrder;
    private final int defaultSortOrder;
    private final boolean objectClassAndMustAttributesFirst;
    private final boolean operationalAttributesLast;

    public AttributeComparator() {
        this.sortBy = 0;
        this.defaultSortBy = 3;
        this.sortOrder = 0;
        this.defaultSortOrder = 1;
        this.objectClassAndMustAttributesFirst = true;
        this.operationalAttributesLast = true;
    }

    public AttributeComparator(int sortBy, int defaultSortBy, int sortOrder, int defaultSortOrder, boolean objectClassAndMustAttributesFirst, boolean operationalAttributesLast) {
        this.sortBy = sortBy;
        this.defaultSortBy = defaultSortBy;
        this.sortOrder = sortOrder;
        this.defaultSortOrder = defaultSortOrder;
        this.objectClassAndMustAttributesFirst = objectClassAndMustAttributesFirst;
        this.operationalAttributesLast = operationalAttributesLast;
    }

    @Override
    public int compare(Object o1, Object o2) {
        IAttribute attribute1 = null;
        IValue value1 = null;
        if (o1 instanceof IAttribute) {
            attribute1 = (IAttribute)o1;
        } else if (o1 instanceof IValue) {
            value1 = (IValue)o1;
            attribute1 = value1.getAttribute();
        }
        IAttribute attribute2 = null;
        IValue value2 = null;
        if (o2 instanceof IAttribute) {
            attribute2 = (IAttribute)o2;
        } else if (o2 instanceof IValue) {
            value2 = (IValue)o2;
            attribute2 = value2.getAttribute();
        }
        if (value1 != null && value2 != null) {
            if (this.getSortByOrDefault() == 3) {
                if (value1.getAttribute() != value2.getAttribute()) {
                    return this.compareAttributes(value1.getAttribute(), value2.getAttribute());
                }
                return this.compareValues(value1, value2);
            }
            if (this.getSortByOrDefault() == 4) {
                return this.compareValues(value1, value2);
            }
            return this.equal();
        }
        if (attribute1 != null && attribute2 != null) {
            return this.compareAttributes(attribute1, attribute2);
        }
        throw new ClassCastException("Can only compare two values or two attributes");
    }

    private int compareAttributes(IAttribute attribute1, IAttribute attribute2) {
        if (this.sortOrder == 0) {
            if (this.objectClassAndMustAttributesFirst) {
                if (attribute1.isObjectClassAttribute() && !attribute2.isObjectClassAttribute()) {
                    return this.lessThan();
                }
                if (attribute2.isObjectClassAttribute() && !attribute1.isObjectClassAttribute()) {
                    return this.greaterThan();
                }
                if (attribute1.isMustAttribute() && !attribute2.isMustAttribute()) {
                    return this.lessThan();
                }
                if (attribute2.isMustAttribute() && !attribute1.isMustAttribute()) {
                    return this.greaterThan();
                }
            }
            if (this.operationalAttributesLast) {
                if (attribute1.isOperationalAttribute() && !attribute2.isOperationalAttribute()) {
                    return this.greaterThan();
                }
                if (attribute2.isOperationalAttribute() && !attribute1.isOperationalAttribute()) {
                    return this.lessThan();
                }
            }
        }
        return this.compare(attribute1.getDescription(), attribute2.getDescription());
    }

    private int compareValues(IValue value1, IValue value2) {
        if (value1.isEmpty() && value2.isEmpty()) {
            return this.equal();
        }
        if (value1.isEmpty() && !value2.isEmpty()) {
            return this.greaterThan();
        }
        if (!value1.isEmpty() && value2.isEmpty()) {
            return this.lessThan();
        }
        return this.compare(value1.getStringValue(), value2.getStringValue());
    }

    private int getSortByOrDefault() {
        if (this.sortBy == 0) {
            return this.defaultSortBy;
        }
        return this.sortBy;
    }

    private int getSortOrderOrDefault() {
        if (this.sortOrder == 0) {
            return this.defaultSortOrder;
        }
        return this.sortOrder;
    }

    private int lessThan() {
        return this.getSortOrderOrDefault() == 1 ? -1 : 1;
    }

    private int equal() {
        return 0;
    }

    private int greaterThan() {
        return this.getSortOrderOrDefault() == 1 ? 1 : -1;
    }

    @Override
    private int compare(String s1, String s2) {
        return this.getSortOrderOrDefault() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }

    public static List<IValue> toSortedValues(IEntry entry) {
        return Arrays.stream(entry.getAttributes()).flatMap(a -> Arrays.stream(a.getValues())).sorted(new AttributeComparator()).collect(Collectors.toList());
    }
}

