/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpResponseException;
import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.CancellationException;

class HttpJsonExceptionCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    HttpJsonExceptionCallable(UnaryCallable<RequestT, ResponseT> callable, Set<StatusCode.Code> retryableCodes) {
        this.callable = Preconditions.checkNotNull(callable);
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        ApiFuture<ResponseT> innerCallFuture = this.callable.futureCall(request, context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback(innerCallFuture, transformingFuture, MoreExecutors.directExecutor());
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        @Override
        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        @Override
        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        @Override
        public void onFailure(Throwable throwable) {
            if (throwable instanceof HttpResponseException) {
                HttpResponseException e = (HttpResponseException)throwable;
                HttpJsonStatusCode statusCode = HttpJsonStatusCode.of(e.getStatusCode());
                boolean canRetry = HttpJsonExceptionCallable.this.retryableCodes.contains((Object)statusCode.getCode());
                String message = e.getStatusMessage();
                ApiException newException = message == null ? ApiExceptionFactory.createException(throwable, statusCode, canRetry) : ApiExceptionFactory.createException(message, throwable, statusCode, canRetry);
                super.setException(newException);
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                if (throwable instanceof ApiException) {
                    super.setException(throwable);
                } else {
                    this.setException(ApiExceptionFactory.createException(throwable, HttpJsonStatusCode.of(StatusCode.Code.UNKNOWN), false));
                }
            }
        }
    }
}

