/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.JsonCursor;
import com.esri.core.geometry.JsonStringWriter;
import com.esri.core.geometry.JsonWriter;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import java.util.Map;

class OperatorExportToJsonCursor
extends JsonCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReference m_spatialReference;
    int m_index = -1;

    public OperatorExportToJsonCursor(SpatialReference spatialReference, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        this.m_inputGeometryCursor = geometryCursor;
        this.m_spatialReference = spatialReference;
    }

    @Override
    public int getID() {
        return this.m_index;
    }

    @Override
    public String next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return OperatorExportToJsonCursor.exportToString(geometry, this.m_spatialReference, null);
        }
        return null;
    }

    static String exportToString(Geometry geometry, SpatialReference spatialReference, Map<String, Object> exportProperties) {
        JsonStringWriter jsonWriter = new JsonStringWriter();
        OperatorExportToJsonCursor.exportToJson_(geometry, spatialReference, jsonWriter, exportProperties);
        return (String)((JsonWriter)jsonWriter).getJson();
    }

    private static void exportToJson_(Geometry geometry, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        try {
            int type = geometry.getType().value();
            switch (type) {
                case 33: {
                    OperatorExportToJsonCursor.exportPointToJson((Point)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 550: {
                    OperatorExportToJsonCursor.exportMultiPointToJson((MultiPoint)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 1607: {
                    OperatorExportToJsonCursor.exportPolylineToJson((Polyline)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 1736: {
                    OperatorExportToJsonCursor.exportPolygonToJson((Polygon)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 197: {
                    OperatorExportToJsonCursor.exportEnvelopeToJson((Envelope)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                default: {
                    throw new RuntimeException("not implemented for this geometry type");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void exportPolygonToJson(Polygon pp, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        OperatorExportToJsonCursor.exportPolypathToJson(pp, "rings", spatialReference, jsonWriter, exportProperties);
    }

    private static void exportPolylineToJson(Polyline pp, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        OperatorExportToJsonCursor.exportPolypathToJson(pp, "paths", spatialReference, jsonWriter, exportProperties);
    }

    private static void exportPolypathToJson(MultiPath pp, String name, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        Object numberOfDecimalsXY;
        boolean bExportZs = pp.hasAttribute(1);
        boolean bExportMs = pp.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        if (exportProperties != null && (numberOfDecimalsXY = exportProperties.get("numberOfDecimalsXY")) != null && numberOfDecimalsXY instanceof Number) {
            bPositionAsF = true;
            decimals = ((Number)numberOfDecimalsXY).intValue();
        }
        jsonWriter.startObject();
        if (bExportZs) {
            jsonWriter.addPairBoolean("hasZ", true);
        }
        if (bExportMs) {
            jsonWriter.addPairBoolean("hasM", true);
        }
        jsonWriter.addPairArray(name);
        if (!pp.isEmpty()) {
            int n = pp.getPathCount();
            MultiPathImpl mpImpl = (MultiPathImpl)pp._getImpl();
            AttributeStreamOfDbl zs = null;
            AttributeStreamOfDbl ms = null;
            if (bExportZs) {
                zs = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1);
            }
            if (bExportMs) {
                ms = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(2);
            }
            boolean bPolygon = pp instanceof Polygon;
            Point2D pt = new Point2D();
            for (int i = 0; i < n; ++i) {
                jsonWriter.addValueArray();
                int startindex = pp.getPathStart(i);
                int numVertices = pp.getPathSize(i);
                double startx = 0.0;
                double starty = 0.0;
                double startz = NumberUtils.NaN();
                double startm = NumberUtils.NaN();
                double z = NumberUtils.NaN();
                double m3 = NumberUtils.NaN();
                boolean bClosed = pp.isClosedPath(i);
                for (int j = startindex; j < startindex + numVertices; ++j) {
                    pp.getXY(j, pt);
                    jsonWriter.addValueArray();
                    if (bPositionAsF) {
                        jsonWriter.addValueDouble(pt.x, decimals, true);
                        jsonWriter.addValueDouble(pt.y, decimals, true);
                    } else {
                        jsonWriter.addValueDouble(pt.x);
                        jsonWriter.addValueDouble(pt.y);
                    }
                    if (bExportZs) {
                        z = zs.get(j);
                        jsonWriter.addValueDouble(z);
                    }
                    if (bExportMs) {
                        m3 = ms.get(j);
                        jsonWriter.addValueDouble(m3);
                    }
                    if (j == startindex && bClosed) {
                        startx = pt.x;
                        starty = pt.y;
                        startz = z;
                        startm = m3;
                    }
                    jsonWriter.endArray();
                }
                if (!(!bClosed || startx == pt.x && starty == pt.y && (!bExportZs || NumberUtils.isNaN(startz) && NumberUtils.isNaN(z) || startz == z) && (!bExportMs || NumberUtils.isNaN(startm) && NumberUtils.isNaN(m3) || startm == m3))) {
                    pp.getXY(startindex, pt);
                    jsonWriter.addValueArray();
                    if (bPositionAsF) {
                        jsonWriter.addValueDouble(pt.x, decimals, true);
                        jsonWriter.addValueDouble(pt.y, decimals, true);
                    } else {
                        jsonWriter.addValueDouble(pt.x);
                        jsonWriter.addValueDouble(pt.y);
                    }
                    if (bExportZs) {
                        z = zs.get(startindex);
                        jsonWriter.addValueDouble(z);
                    }
                    if (bExportMs) {
                        m3 = ms.get(startindex);
                        jsonWriter.addValueDouble(m3);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endArray();
            }
        }
        jsonWriter.endArray();
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void exportMultiPointToJson(MultiPoint mpt, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        Object numberOfDecimalsXY;
        boolean bExportZs = mpt.hasAttribute(1);
        boolean bExportMs = mpt.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        if (exportProperties != null && (numberOfDecimalsXY = exportProperties.get("numberOfDecimalsXY")) != null && numberOfDecimalsXY instanceof Number) {
            bPositionAsF = true;
            decimals = ((Number)numberOfDecimalsXY).intValue();
        }
        jsonWriter.startObject();
        if (bExportZs) {
            jsonWriter.addPairBoolean("hasZ", true);
        }
        if (bExportMs) {
            jsonWriter.addPairBoolean("hasM", true);
        }
        jsonWriter.addPairArray("points");
        if (!mpt.isEmpty()) {
            MultiPointImpl mpImpl = (MultiPointImpl)mpt._getImpl();
            AttributeStreamOfDbl zs = null;
            AttributeStreamOfDbl ms = null;
            if (bExportZs) {
                zs = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1);
            }
            if (bExportMs) {
                ms = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(2);
            }
            Point2D pt = new Point2D();
            int n = mpt.getPointCount();
            for (int i = 0; i < n; ++i) {
                mpt.getXY(i, pt);
                jsonWriter.addValueArray();
                if (bPositionAsF) {
                    jsonWriter.addValueDouble(pt.x, decimals, true);
                    jsonWriter.addValueDouble(pt.y, decimals, true);
                } else {
                    jsonWriter.addValueDouble(pt.x);
                    jsonWriter.addValueDouble(pt.y);
                }
                if (bExportZs) {
                    double z = zs.get(i);
                    jsonWriter.addValueDouble(z);
                }
                if (bExportMs) {
                    double m3 = ms.get(i);
                    jsonWriter.addValueDouble(m3);
                }
                jsonWriter.endArray();
            }
        }
        jsonWriter.endArray();
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void exportPointToJson(Point pt, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        Object numberOfDecimalsXY;
        boolean bExportZs = pt.hasAttribute(1);
        boolean bExportMs = pt.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        if (exportProperties != null && (numberOfDecimalsXY = exportProperties.get("numberOfDecimalsXY")) != null && numberOfDecimalsXY instanceof Number) {
            bPositionAsF = true;
            decimals = ((Number)numberOfDecimalsXY).intValue();
        }
        jsonWriter.startObject();
        if (pt.isEmpty()) {
            jsonWriter.addPairNull("x");
            jsonWriter.addPairNull("y");
            if (bExportZs) {
                jsonWriter.addPairNull("z");
            }
            if (bExportMs) {
                jsonWriter.addPairNull("m");
            }
        } else {
            if (bPositionAsF) {
                jsonWriter.addPairDouble("x", pt.getX(), decimals, true);
                jsonWriter.addPairDouble("y", pt.getY(), decimals, true);
            } else {
                jsonWriter.addPairDouble("x", pt.getX());
                jsonWriter.addPairDouble("y", pt.getY());
            }
            if (bExportZs) {
                jsonWriter.addPairDouble("z", pt.getZ());
            }
            if (bExportMs) {
                jsonWriter.addPairDouble("m", pt.getM());
            }
        }
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void exportEnvelopeToJson(Envelope env, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        Object numberOfDecimalsXY;
        boolean bExportZs = env.hasAttribute(1);
        boolean bExportMs = env.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        if (exportProperties != null && (numberOfDecimalsXY = exportProperties.get("numberOfDecimalsXY")) != null && numberOfDecimalsXY instanceof Number) {
            bPositionAsF = true;
            decimals = ((Number)numberOfDecimalsXY).intValue();
        }
        jsonWriter.startObject();
        if (env.isEmpty()) {
            jsonWriter.addPairNull("xmin");
            jsonWriter.addPairNull("ymin");
            jsonWriter.addPairNull("xmax");
            jsonWriter.addPairNull("ymax");
            if (bExportZs) {
                jsonWriter.addPairNull("zmin");
                jsonWriter.addPairNull("zmax");
            }
            if (bExportMs) {
                jsonWriter.addPairNull("mmin");
                jsonWriter.addPairNull("mmax");
            }
        } else {
            if (bPositionAsF) {
                jsonWriter.addPairDouble("xmin", env.getXMin(), decimals, true);
                jsonWriter.addPairDouble("ymin", env.getYMin(), decimals, true);
                jsonWriter.addPairDouble("xmax", env.getXMax(), decimals, true);
                jsonWriter.addPairDouble("ymax", env.getYMax(), decimals, true);
            } else {
                jsonWriter.addPairDouble("xmin", env.getXMin());
                jsonWriter.addPairDouble("ymin", env.getYMin());
                jsonWriter.addPairDouble("xmax", env.getXMax());
                jsonWriter.addPairDouble("ymax", env.getYMax());
            }
            if (bExportZs) {
                Envelope1D z = env.queryInterval(1, 0);
                jsonWriter.addPairDouble("zmin", z.vmin);
                jsonWriter.addPairDouble("zmax", z.vmax);
            }
            if (bExportMs) {
                Envelope1D m3 = env.queryInterval(2, 0);
                jsonWriter.addPairDouble("mmin", m3.vmin);
                jsonWriter.addPairDouble("mmax", m3.vmax);
            }
        }
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void writeSR(SpatialReference spatialReference, JsonWriter jsonWriter) {
        int wkid = spatialReference.getOldID();
        if (wkid > 0) {
            jsonWriter.addPairObject("spatialReference");
            jsonWriter.addPairInt("wkid", wkid);
            int latest_wkid = spatialReference.getLatestID();
            if (latest_wkid > 0 && latest_wkid != wkid) {
                jsonWriter.addPairInt("latestWkid", latest_wkid);
            }
            jsonWriter.endObject();
        } else {
            String wkt = spatialReference.getText();
            if (wkt != null) {
                jsonWriter.addPairObject("spatialReference");
                jsonWriter.addPairString("wkt", wkt);
                jsonWriter.endObject();
            }
        }
    }
}

