/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.flink.calcite.shaded.com.google.common.collect.RangeSet;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.ScalarOperatorGens$;
import org.apache.flink.table.planner.codegen.calls.SearchOperatorGen;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.plan.utils.RexLiteralUtil;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.runtime.BoxedUnit;

public final class SearchOperatorGen$ {
    public static SearchOperatorGen$ MODULE$;

    static {
        new SearchOperatorGen$();
    }

    public GeneratedExpression generateSearch(CodeGeneratorContext ctx, GeneratedExpression target, RexLiteral sargLiteral) {
        GeneratedExpression generatedExpression;
        Sarg sarg = sargLiteral.getValueAs(Sarg.class);
        LogicalType targetType = target.resultType();
        LogicalType sargType = FlinkTypeFactory$.MODULE$.toLogicalType(sargLiteral.getType());
        LogicalType commonType = (LogicalType)LogicalTypeMerging.findCommonType(Arrays.asList((Object[])new LogicalType[]{targetType, sargType})).orElseThrow(() -> new CodeGenException(new StringBuilder(36).append("Unable to find common type of ").append(target).append(" and ").append(sargLiteral).append(".").toString()));
        GeneratedExpression needle = ScalarOperatorGens$.MODULE$.generateCast(ctx, target, commonType, false);
        if (sarg.isPoints() || sarg.isComplementedPoints()) {
            RangeSet rangeSet = sarg.isPoints() ? sarg.rangeSet : sarg.rangeSet.complement();
            Set haystack = (Set)((scala.collection.SetLike)((scala.collection.SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(rangeSet.asRanges()).asScala()).map((Function1 & Serializable & scala.Serializable)r -> RexLiteralUtil.toFlinkInternalValue(r.lowerEndpoint(), sargType), Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> CastRuleProvider.cast(ScalarOperatorGens$.MODULE$.toCastContext(ctx), sargType, commonType, x$1), Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> GenerateUtils$.MODULE$.generateLiteral(ctx, x$2, commonType), Set$.MODULE$.canBuildFrom());
            Object object = sarg.containsNull ? haystack.$plus$eq((Object)GenerateUtils$.MODULE$.generateNullLiteral(commonType)) : BoxedUnit.UNIT;
            String setTerm = ctx.addReusableHashSet((Seq<GeneratedExpression>)haystack.toSeq(), commonType);
            String negation = sarg.isComplementedPoints() ? "!" : "";
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(253).append("\n           |").append(needle.code()).append("\n           |// --- Begin SEARCH ").append(target.resultTerm()).append("\n           |boolean ").append(resultTerm2).append(" = false;\n           |boolean ").append(nullTerm2).append(" = true;\n           |if (!").append(needle.nullTerm()).append(") {\n           |  ").append(resultTerm2).append(" = ").append(negation).append(setTerm).append(".contains(").append(needle.resultTerm()).append(");\n           |  ").append(nullTerm2).append(" = !").append(resultTerm2).append(" && ").append(setTerm).append(".containsNull();\n           |}\n           |// --- End SEARCH ").append(target.resultTerm()).append("\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            String finalCode;
            String x$5 = "";
            String x$6 = target.copy$default$1();
            String x$7 = target.copy$default$2();
            LogicalType x$8 = target.copy$default$4();
            Option<Object> x$9 = target.copy$default$5();
            GeneratedExpression dummyTarget = target.copy(x$6, x$7, x$5, x$8, x$9);
            SearchOperatorGen.RangeToExpression rangeToExpression = new SearchOperatorGen.RangeToExpression(ctx, sargType, dummyTarget);
            Seq rangeChecks = (Seq)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(sarg.rangeSet.asRanges()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$4 -> (GeneratedExpression)RangeSets.map(x$4, rangeToExpression), Seq$.MODULE$.canBuildFrom());
            if (sarg.containsNull) {
                rangeChecks = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{ScalarOperatorGens$.MODULE$.generateIsNull(target, (LogicalType)new BooleanType(target.resultType().isNullable()))}))).$plus$plus((GenTraversableOnce)rangeChecks, Seq$.MODULE$.canBuildFrom());
            }
            GeneratedExpression generatedRangeChecks = (GeneratedExpression)rangeChecks.reduce((Function2 & Serializable & scala.Serializable)(left, right) -> ScalarOperatorGens$.MODULE$.generateOr((GeneratedExpression)left, (GeneratedExpression)right, (LogicalType)new BooleanType(left.resultType().isNullable() || right.resultType().isNullable())));
            String x$10 = finalCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("\n           |").append(target.code()).append("\n           |// --- Begin SEARCH ").append(target.resultTerm()).append("\n           |").append(generatedRangeChecks.code()).append("\n           |// --- End SEARCH ").append(target.resultTerm()).append("\n           |").toString())).stripMargin().trim();
            String x$11 = generatedRangeChecks.copy$default$1();
            String x$12 = generatedRangeChecks.copy$default$2();
            LogicalType x$13 = generatedRangeChecks.copy$default$4();
            Option<Object> x$14 = generatedRangeChecks.copy$default$5();
            generatedExpression = generatedRangeChecks.copy(x$11, x$12, x$10, x$13, x$14);
        }
        return generatedExpression;
    }

    private SearchOperatorGen$() {
        MODULE$ = this;
    }
}

