/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.TableSchemaUtils;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001E\u0011\u0001\u0004T3hC\u000eL8)\u0019;bY><7k\\;sG\u0016$\u0016M\u00197f\u0015\t\u0019A!\u0001\u0004tG\",W.\u0019\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001)\"A\u0005/\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005]1E.\u001b8l!J,\u0007/\u0019:j]\u001e$\u0016M\u00197f\u0005\u0006\u001cX\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001a\u00031\u0011X\r\\(qiN\u001b\u0007.Z7b!\tQb$D\u0001\u001c\u0015\t)AD\u0003\u0002\u001e\u0019\u000591-\u00197dSR,\u0017BA\u0010\u001c\u00051\u0011V\r\\(qiN\u001b\u0007.Z7b\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!\u00028b[\u0016\u001c\bcA\u0012)U5\tAE\u0003\u0002&M\u0005!Q\u000f^5m\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\t1K7\u000f\u001e\t\u0003WQr!\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\u0002\u0012A\u0002\u001fs_>$hHC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a1\u0011!A\u0004A!A!\u0002\u0013I\u0014a\u0002:poRK\b/\u001a\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nA\u0001^=qK*\u0011a\bH\u0001\u0004e\u0016d\u0017B\u0001!<\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u0011\t\u0003!Q1A\u0005\u0002\r\u000b1b]2iK6\fG+\u00192mKV\tA\t\u0005\u0002F\u00116\taI\u0003\u0002H\r\u000591-\u0019;bY><\u0017BA%G\u0005I\u0019\u0015\r^1m_\u001e\u001c6\r[3nCR\u000b'\r\\3\t\u0011-\u0003!\u0011!Q\u0001\n\u0011\u000bAb]2iK6\fG+\u00192mK\u0002B\u0001\"\u0014\u0001\u0003\u0006\u0004%\tAT\u0001\rG\u0006$\u0018\r\\8h)\u0006\u0014G.Z\u000b\u0002\u001fB\u0011\u0001KU\u0007\u0002#*\u0011q\tC\u0005\u0003'F\u0013AbQ1uC2|w\rV1cY\u0016D\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IaT\u0001\u000eG\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0011\t\u000b]\u0003A\u0011\u0001-\u0002\rqJg.\u001b;?)\u0019Ifm\u001a5jUB\u0019A\u0003\u0001.\u0011\u0005mcF\u0002\u0001\u0003\u0006;\u0002\u0011\rA\u0018\u0002\u0002)F\u0011ql\u0019\t\u0003A\u0006l\u0011\u0001M\u0005\u0003EB\u0012qAT8uQ&tw\r\u0005\u0002aI&\u0011Q\r\r\u0002\u0004\u0003:L\b\"\u0002\rW\u0001\u0004I\u0002\"B\u0011W\u0001\u0004\u0011\u0003\"\u0002\u001dW\u0001\u0004I\u0004\"\u0002\"W\u0001\u0004!\u0005\"B'W\u0001\u0004y\u0005\u0002\u00037\u0001\u0011\u000b\u0007I\u0011A7\u0002\u0017\r|G.^7o\u000bb\u0004(o]\u000b\u0002]B!1f\u001c\u0016+\u0013\t\u0001hGA\u0002NCBDQA\u001d\u0001\u0005BM\fQ\u0001^8SK2$\"\u0001\u001e=\u0011\u0005U4X\"A\u001f\n\u0005]l$a\u0002*fY:{G-\u001a\u0005\u0006sF\u0004\rA_\u0001\bG>tG/\u001a=u!\tYhP\u0004\u0002\u001by&\u0011QpG\u0001\f%\u0016dw\n\u001d;UC\ndW-C\u0002\u0000\u0003\u0003\u0011A\u0002V8SK2\u001cuN\u001c;fqRT!!`\u000e\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u0005qb-\u001b8e\u0003:$7I]3bi\u0016dUmZ1dsR\u000b'\r\\3T_V\u00148-\u001a\u000b\u0007\u0003\u0013\t)\"a\u000f\u0011\u000b\u0005-\u0011\u0011\u0003.\u000e\u0005\u00055!bAA\b\u0011\u000591o\\;sG\u0016\u001c\u0018\u0002BA\n\u0003\u001b\u00111\u0002V1cY\u0016\u001cv.\u001e:dK\"A\u0011qCA\u0002\u0001\u0004\tI\"A\u0007iS:$X\rZ(qi&|gn\u001d\t\u0007\u00037\t)D\u000b\u0016\u000f\t\u0005u\u0011\u0011\u0007\b\u0005\u0003?\tyC\u0004\u0003\u0002\"\u00055b\u0002BA\u0012\u0003WqA!!\n\u0002*9\u0019Q&a\n\n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u00024\u0019\tq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0005e\"\u0001\u0002&NCBT1!a\r\u0007\u0011!\ti$a\u0001A\u0002\u0005}\u0012\u0001B2p]\u001a\u0004B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bR\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002J\u0005\r#A\u0004*fC\u0012\f'\r\\3D_:4\u0017n\u001a\u0005\b\u0003\u001b\u0002A\u0011BA(\u0003I)'/Y:f)&lW-\u00138eS\u000e\fGo\u001c:\u0015\u000fe\n\t&!\u0016\u0002d!9\u00111KA&\u0001\u0004I\u0014a\u0003:fY\u0012\u000bG/\u0019+za\u0016D\u0001\"a\u0016\u0002L\u0001\u0007\u0011\u0011L\u0001\bM\u0006\u001cGo\u001c:z!\u0011\tY&a\u0018\u000e\u0005\u0005u#BA\u000f\u0007\u0013\u0011\t\t'!\u0018\u0003!\u0019c\u0017N\\6UsB,g)Y2u_JL\b\u0002CA3\u0003\u0017\u0002\r!a\u001a\u0002\u0017Q\f'\r\\3T_V\u00148-\u001a\u0019\u0005\u0003S\ni\u0007\u0005\u0004\u0002\f\u0005E\u00111\u000e\t\u00047\u00065DaCA8\u0003G\n\t\u0011!A\u0003\u0002y\u00131a\u0018\u00132\u0001")
public class LegacyCatalogSourceTable<T>
extends FlinkPreparingTableBase {
    private scala.collection.immutable.Map<String, String> columnExprs;
    private final RelOptSchema relOptSchema;
    private final RelDataType rowType;
    private final CatalogSchemaTable schemaTable;
    private final CatalogTable catalogTable;
    private volatile boolean bitmap$0;

    public CatalogSchemaTable schemaTable() {
        return this.schemaTable;
    }

    public CatalogTable catalogTable() {
        return this.catalogTable;
    }

    private scala.collection.immutable.Map<String, String> columnExprs$lzycompute() {
        LegacyCatalogSourceTable legacyCatalogSourceTable = this;
        synchronized (legacyCatalogSourceTable) {
            if (!this.bitmap$0) {
                this.columnExprs = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.catalogTable().getSchema().getTableColumns()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iterable iterable;
                    TableColumn tableColumn = x0$1;
                    if (tableColumn instanceof TableColumn.ComputedColumn) {
                        TableColumn.ComputedColumn computedColumn = (TableColumn.ComputedColumn)tableColumn;
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)computedColumn.getName(), (Object)computedColumn.getExpression())));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = true;
            }
        }
        return this.columnExprs;
    }

    public scala.collection.immutable.Map<String, String> columnExprs() {
        return !this.bitmap$0 ? this.columnExprs$lzycompute() : this.columnExprs;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        Object object;
        Object object2;
        RelOptCluster cluster = context.getCluster();
        FlinkContext flinkContext = ShortcutUtils.unwrapContext(cluster);
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        TableConfig tableConfig = flinkContext.getTableConfig();
        Map<String, String> hintedOptions = FlinkHints.getHintedOptions(context.getTableHints());
        if (JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(hintedOptions).nonEmpty() && !Predef$.MODULE$.Boolean2boolean((Boolean)tableConfig.get(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED))) {
            throw new ValidationException(new StringBuilder(48).append("OPTIONS").append(" hint is allowed only when ").append(new StringBuilder(1).append(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED.key()).append(" ").toString()).append("is set to true").toString());
        }
        TableSource<T> tableSource = this.findAndCreateLegacyTableSource(hintedOptions, (ReadableConfig)tableConfig);
        RelDataType actualRowType = this.eraseTimeIndicator(this.rowType, typeFactory, tableSource);
        LegacyTableSourceTable<T> tableSourceTable = new LegacyTableSourceTable<T>(this.relOptSchema, this.schemaTable().getContextResolvedTable().getIdentifier(), actualRowType, this.statistic, tableSource, this.schemaTable().isStreamingMode(), this.catalogTable(), hintedOptions);
        int[] physicalFields = (int[])((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldList()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LegacyCatalogSourceTable.$anonfun$toRel$1(this, f)))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)f.getIndex()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        LegacyTableSourceTable<T> newRelTable = tableSourceTable.copy(tableSource, physicalFields);
        LogicalTableScan scan = LogicalTableScan.create(cluster, newRelTable, context.getTableHints());
        FlinkRelBuilder relBuilder = FlinkRelBuilder.of(cluster, this.getRelOptSchema());
        relBuilder.push(scan);
        RexFactory rexFactory = flinkContext.getRexFactory();
        Buffer fieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(actualRowType.getFieldNames()).asScala();
        if (this.columnExprs().nonEmpty()) {
            String[] fieldExprs = (String[])((TraversableOnce)fieldNames.map((Function1 & Serializable & scala.Serializable)name -> this.columnExprs().contains(name) ? (String)this.columnExprs().apply(name) : new StringBuilder(2).append("`").append((String)name).append("`").toString(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNode[] rexNodes = rexFactory.createSqlToRexConverter(newRelTable.getRowType(), null).convertToRexNodes(fieldExprs);
            object2 = relBuilder.projectNamed(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rexNodes)).toList()), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(fieldNames), true);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option watermarkSpec = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.catalogTable().getSchema().getWatermarkSpecs()).asScala()).headOption();
        if (this.schemaTable().isStreamingMode() && watermarkSpec.nonEmpty()) {
            if (TableSourceValidation.hasRowtimeAttribute(tableSource)) {
                throw new TableException("If watermark is specified in DDL, the underlying TableSource of connector shouldn't return an non-empty list of RowtimeAttributeDescriptor via DefinedRowtimeAttributes interface.");
            }
            String rowtime = ((WatermarkSpec)watermarkSpec.get()).getRowtimeAttribute();
            if (rowtime.contains(".")) {
                throw new TableException(new StringBuilder(64).append("Nested field '").append(rowtime).append("' as rowtime attribute is not supported right now.").toString());
            }
            int rowtimeIndex = fieldNames.indexOf((Object)rowtime);
            RexNode watermarkRexNode = rexFactory.createSqlToRexConverter(actualRowType, null).convertToRexNode(((WatermarkSpec)watermarkSpec.get()).getWatermarkExpr());
            object = relBuilder.watermark(rowtimeIndex, watermarkRexNode);
        } else {
            object = BoxedUnit.UNIT;
        }
        return relBuilder.build();
    }

    private TableSource<T> findAndCreateLegacyTableSource(Map<String, String> hintedOptions, ReadableConfig conf) {
        CatalogTable tableToFind = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(hintedOptions).nonEmpty() ? this.catalogTable().copy(FlinkHints.mergeTableOptions(hintedOptions, this.catalogTable().getOptions())) : this.catalogTable();
        ObjectIdentifier identifier = this.schemaTable().getContextResolvedTable().getIdentifier();
        TableSource tableSource = TableFactoryUtil.findAndCreateTableSource((Catalog)this.schemaTable().getContextResolvedTable().getCatalog().orElse(null), (ObjectIdentifier)identifier, (CatalogTable)new CatalogTableImpl(TableSchemaUtils.removeTimeAttributeFromResolvedSchema((ResolvedSchema)this.schemaTable().getContextResolvedTable().getResolvedSchema()), tableToFind.getPartitionKeys(), tableToFind.getOptions(), tableToFind.getComment()), (ReadableConfig)conf, (boolean)this.schemaTable().isTemporary());
        String tableName = identifier.asSummaryString();
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof StreamTableSource) {
            StreamTableSource streamTableSource = (StreamTableSource)tableSource2;
            if (!this.schemaTable().isStreamingMode() && !streamTableSource.isBounded()) {
                throw new ValidationException(new StringBuilder(51).append("Cannot query on an unbounded source in batch mode, ").append(new StringBuilder(20).append("but '").append(tableName).append("' is unbounded.").toString()).toString());
            }
        } else {
            throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return tableSource;
    }

    private RelDataType eraseTimeIndicator(RelDataType relDataType, FlinkTypeFactory factory, TableSource<?> tableSource) {
        RelDataType relDataType2;
        boolean hasLegacyTimeAttributes;
        boolean bl = hasLegacyTimeAttributes = TableSourceValidation.hasRowtimeAttribute(tableSource) || TableSourceValidation.hasProctimeAttribute(tableSource);
        if (this.columnExprs().isEmpty() && this.catalogTable().getSchema().getWatermarkSpecs().isEmpty() && hasLegacyTimeAttributes) {
            relDataType2 = relDataType;
        } else {
            RowType logicalRowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(relDataType);
            List fieldNames = logicalRowType.getFieldNames();
            Buffer fieldTypes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicalRowType.getFields()).map((Function1 & Serializable & scala.Serializable)f -> {
                LogicalType logicalType;
                if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(f.getType())) {
                    TimestampType timestampType;
                    LogicalType logicalType2 = f.getType();
                    if (logicalType2 instanceof TimestampType) {
                        TimestampType timestampType2 = (TimestampType)logicalType2;
                        timestampType = new TimestampType(timestampType2.isNullable(), TimestampKind.REGULAR, timestampType2.getPrecision());
                    } else if (logicalType2 instanceof LocalZonedTimestampType) {
                        LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)logicalType2;
                        timestampType = new LocalZonedTimestampType(localZonedTimestampType.isNullable(), TimestampKind.REGULAR, localZonedTimestampType.getPrecision());
                    } else {
                        throw new ValidationException(new StringBuilder(75).append("The supported time indicator type are TIMESTAMP and TIMESTAMP_LTZ, but is ").append(f.getType()).append(".").toString());
                    }
                    logicalType = timestampType;
                } else {
                    logicalType = f.getType();
                }
                return logicalType;
            }, Buffer$.MODULE$.canBuildFrom());
            relDataType2 = factory.buildRelNodeRowType((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(fieldNames).asScala()), (Seq<LogicalType>)fieldTypes);
        }
        return relDataType2;
    }

    public static final /* synthetic */ boolean $anonfun$toRel$1(LegacyCatalogSourceTable $this, RelDataTypeField f) {
        return !$this.columnExprs().contains((Object)f.getName());
    }

    public LegacyCatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable, CatalogTable catalogTable) {
        this.relOptSchema = relOptSchema;
        this.rowType = rowType;
        this.schemaTable = schemaTable;
        this.catalogTable = catalogTable;
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
    }
}

