/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.retrying;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ResultRetryAlgorithmWithContext;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingContext;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedRetryAlgorithmWithContext;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;

public class RetryAlgorithm<ResponseT> {
    private final ResultRetryAlgorithm<ResponseT> resultAlgorithm;
    private final TimedRetryAlgorithm timedAlgorithm;
    private final ResultRetryAlgorithmWithContext<ResponseT> resultAlgorithmWithContext;
    private final TimedRetryAlgorithmWithContext timedAlgorithmWithContext;

    @Deprecated
    public RetryAlgorithm(ResultRetryAlgorithm<ResponseT> resultAlgorithm, TimedRetryAlgorithm timedAlgorithm) {
        this.resultAlgorithm = Preconditions.checkNotNull(resultAlgorithm);
        this.timedAlgorithm = Preconditions.checkNotNull(timedAlgorithm);
        this.resultAlgorithmWithContext = null;
        this.timedAlgorithmWithContext = null;
    }

    public RetryAlgorithm(ResultRetryAlgorithmWithContext<ResponseT> resultAlgorithm, TimedRetryAlgorithmWithContext timedAlgorithm) {
        this.resultAlgorithm = null;
        this.timedAlgorithm = null;
        this.resultAlgorithmWithContext = Preconditions.checkNotNull(resultAlgorithm);
        this.timedAlgorithmWithContext = Preconditions.checkNotNull(timedAlgorithm);
    }

    @Deprecated
    public TimedAttemptSettings createFirstAttempt() {
        return this.createFirstAttempt(null);
    }

    public TimedAttemptSettings createFirstAttempt(RetryingContext context) {
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.createFirstAttempt(context);
        }
        return this.getTimedAlgorithm().createFirstAttempt();
    }

    @Deprecated
    public TimedAttemptSettings createNextAttempt(Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        return this.createNextAttempt(null, previousThrowable, previousResponse, previousSettings);
    }

    public TimedAttemptSettings createNextAttempt(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        if (!this.shouldRetryBasedOnResult(context, previousThrowable, previousResponse)) {
            return null;
        }
        TimedAttemptSettings newSettings = this.createNextAttemptBasedOnResult(context, previousThrowable, previousResponse, previousSettings);
        if (newSettings == null) {
            newSettings = this.createNextAttemptBasedOnTiming(context, previousSettings);
        }
        return newSettings;
    }

    private TimedAttemptSettings createNextAttemptBasedOnResult(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        if (this.resultAlgorithmWithContext != null && context != null) {
            return this.resultAlgorithmWithContext.createNextAttempt(context, previousThrowable, previousResponse, previousSettings);
        }
        return this.getResultAlgorithm().createNextAttempt(previousThrowable, previousResponse, previousSettings);
    }

    private TimedAttemptSettings createNextAttemptBasedOnTiming(RetryingContext context, TimedAttemptSettings previousSettings) {
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.createNextAttempt(context, previousSettings);
        }
        return this.getTimedAlgorithm().createNextAttempt(previousSettings);
    }

    @Deprecated
    public boolean shouldRetry(Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings nextAttemptSettings) throws CancellationException {
        return this.shouldRetry(null, previousThrowable, previousResponse, nextAttemptSettings);
    }

    public boolean shouldRetry(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings nextAttemptSettings) throws CancellationException {
        return this.shouldRetryBasedOnResult(context, previousThrowable, previousResponse) && this.shouldRetryBasedOnTiming(context, nextAttemptSettings);
    }

    boolean shouldRetryBasedOnResult(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse) {
        if (this.resultAlgorithmWithContext != null && context != null) {
            return this.resultAlgorithmWithContext.shouldRetry(context, previousThrowable, previousResponse);
        }
        return this.getResultAlgorithm().shouldRetry(previousThrowable, previousResponse);
    }

    private boolean shouldRetryBasedOnTiming(RetryingContext context, TimedAttemptSettings nextAttemptSettings) {
        if (nextAttemptSettings == null) {
            return false;
        }
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.shouldRetry(context, nextAttemptSettings);
        }
        return this.getTimedAlgorithm().shouldRetry(nextAttemptSettings);
    }

    @BetaApi(value="Surface for inspecting the a RetryAlgorithm is not yet stable")
    public ResultRetryAlgorithm<ResponseT> getResultAlgorithm() {
        return this.resultAlgorithmWithContext != null ? this.resultAlgorithmWithContext : this.resultAlgorithm;
    }

    @BetaApi(value="Surface for inspecting the a RetryAlgorithm is not yet stable")
    public TimedRetryAlgorithm getTimedAlgorithm() {
        return this.timedAlgorithmWithContext != null ? this.timedAlgorithmWithContext : this.timedAlgorithm;
    }
}

