/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent;

import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.netty.NegotiationType;
import com.google.bigtable.repackaged.io.grpc.netty.NettyChannelBuilder;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent.MetricsProtoUtils;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent.OcAgentMetricsServiceExportRpcHandler;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent.OcAgentNodeUtils;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricProducer;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricProducerManager;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.metrics.v1.ExportMetricsServiceRequest;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.metrics.v1.MetricsServiceGrpc;
import com.google.bigtable.repackaged.io.opencensus.proto.metrics.v1.Metric;
import com.google.bigtable.repackaged.io.opencensus.proto.resource.v1.Resource;
import io.netty.handler.ssl.SslContext;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class OcAgentMetricsExporterWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger(OcAgentMetricsExporterWorker.class.getName());
    private final String endPoint;
    private final boolean useInsecure;
    @Nullable
    private final SslContext sslContext;
    private final long exportIntervalMillis;
    private final long retryIntervalMillis;
    private final String serviceName;
    private final MetricProducerManager metricProducerManager;
    private OcAgentMetricsServiceExportRpcHandler exportRpcHandler;

    OcAgentMetricsExporterWorker(String endPoint, boolean useInsecure, @Nullable SslContext sslContext, Duration exportInterval, Duration retryInterval, String serviceName, MetricProducerManager metricProducerManager) {
        this.endPoint = endPoint;
        this.useInsecure = useInsecure;
        this.sslContext = sslContext;
        this.exportIntervalMillis = exportInterval.toMillis();
        this.retryIntervalMillis = retryInterval.toMillis();
        this.serviceName = serviceName;
        this.metricProducerManager = metricProducerManager;
    }

    @Override
    public void run() {
        while (true) {
            this.connect();
            while (this.exportRpcHandler != null && !this.exportRpcHandler.isCompleted()) {
                this.export();
                OcAgentMetricsExporterWorker.sleep(this.exportIntervalMillis);
            }
            if (this.exportRpcHandler != null && this.exportRpcHandler.getTerminateStatus() != null) {
                TerminateStatusRunnable runnable = new TerminateStatusRunnable(this.exportRpcHandler.getTerminateStatus(), "Export");
                new Thread(runnable).start();
            }
            OcAgentMetricsExporterWorker.sleep(this.retryIntervalMillis);
        }
    }

    private void connect() {
        Object channelBuilder = this.useInsecure ? ManagedChannelBuilder.forTarget(this.endPoint).usePlaintext() : NettyChannelBuilder.forTarget(this.endPoint).negotiationType(NegotiationType.TLS).sslContext(this.sslContext);
        ManagedChannel channel = ((ManagedChannelBuilder)channelBuilder).build();
        MetricsServiceGrpc.MetricsServiceStub stub = MetricsServiceGrpc.newStub(channel);
        this.exportRpcHandler = OcAgentMetricsServiceExportRpcHandler.create(stub);
        ExportMetricsServiceRequest.Builder builder = ExportMetricsServiceRequest.newBuilder().setNode(OcAgentNodeUtils.getNodeInfo(this.serviceName));
        Resource resourceProto = OcAgentNodeUtils.getAutoDetectedResourceProto();
        if (resourceProto != null) {
            builder.setResource(resourceProto);
        }
        this.exportRpcHandler.onExport(builder.build());
    }

    private void export() {
        if (this.exportRpcHandler == null || this.exportRpcHandler.isCompleted()) {
            return;
        }
        ArrayList<com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric> metricsList = Lists.newArrayList();
        for (MetricProducer metricProducer : this.metricProducerManager.getAllMetricProducer()) {
            metricsList.addAll(metricProducer.getMetrics());
        }
        ArrayList<Metric> metricProtos = Lists.newArrayList();
        for (com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric metric : metricsList) {
            metricProtos.add(MetricsProtoUtils.toMetricProto(metric, null));
        }
        this.exportRpcHandler.onExport(ExportMetricsServiceRequest.newBuilder().addAllMetrics(metricProtos).build());
    }

    private static void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            logger.log(Level.INFO, "OcAgentMetricsExporterWorker is interrupted.", e);
            Thread.currentThread().interrupt();
        }
    }

    private static final class TerminateStatusRunnable
    implements Runnable {
        private final Status status;
        private final String rpcName;

        TerminateStatusRunnable(Status status, String rpcName) {
            this.status = status;
            this.rpcName = rpcName;
        }

        @Override
        public void run() {
            logger.log(Level.INFO, "RPC " + this.rpcName + " terminated with Status ", this.status);
        }
    }
}

