/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.hbase.adapters.MutationAdapter;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;

@InternalApi(value="For internal usage only")
public class HBaseMutationAdapter
extends MutationAdapter<Mutation> {
    private final AdapterInstanceMap adapterMap = new AdapterInstanceMap();

    public HBaseMutationAdapter(MutationAdapter<Delete> deleteAdapter, MutationAdapter<Put> putAdapter, MutationAdapter<Increment> incrementAdapter, MutationAdapter<Append> appendAdapter) {
        this.adapterMap.put(Delete.class, deleteAdapter);
        this.adapterMap.put(Put.class, putAdapter);
        this.adapterMap.put(Increment.class, incrementAdapter);
        this.adapterMap.put(Append.class, appendAdapter);
    }

    @Override
    public void adapt(Mutation mutation, MutationApi<?> mutationModel) {
        Object adapter = this.adapterMap.get(mutation.getClass());
        if (adapter == null) {
            throw new UnsupportedOperationException(String.format("Cannot adapt mutation of type %s.", mutation.getClass().getCanonicalName()));
        }
        ((MutationAdapter)adapter).adapt((Mutation)mutation, mutationModel);
    }

    static class AdapterInstanceMap {
        private Map<Class<?>, MutationAdapter<?>> unsafeMap = new HashMap();

        AdapterInstanceMap() {
        }

        public <S extends Mutation, U extends MutationAdapter<S>> Class<S> put(Class<S> key, U adapter) {
            this.unsafeMap.put(key, adapter);
            return key;
        }

        public <S extends Mutation, U extends MutationAdapter<S>> U get(Class<? extends S> key) {
            return (U)this.unsafeMap.get(key);
        }
    }
}

