/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUtils;
import org.apache.beam.sdk.values.RowUtils;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.sdk.values.RowWithStorage;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class Row
implements Serializable {
    private final Schema schema;

    Row(Schema schema) {
        this.schema = schema;
    }

    public abstract <T> @Nullable T getValue(int var1);

    public abstract int getFieldCount();

    @Internal
    public abstract List<Object> getValues();

    public List<Object> getBaseValues() {
        return IntStream.range(0, this.getFieldCount()).mapToObj(i -> this.getBaseValue(i)).collect(Collectors.toList());
    }

    public <T> @Nullable T getValue(String fieldName) {
        return this.getValue(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Byte getByte(String fieldName) {
        return this.getByte(this.getSchema().indexOf(fieldName));
    }

    public byte @Nullable [] getBytes(String fieldName) {
        return this.getBytes(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Short getInt16(String fieldName) {
        return this.getInt16(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Integer getInt32(String fieldName) {
        return this.getInt32(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Long getInt64(String fieldName) {
        return this.getInt64(this.getSchema().indexOf(fieldName));
    }

    public @Nullable BigDecimal getDecimal(String fieldName) {
        return this.getDecimal(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Float getFloat(String fieldName) {
        return this.getFloat(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Double getDouble(String fieldName) {
        return this.getDouble(this.getSchema().indexOf(fieldName));
    }

    public @Nullable String getString(String fieldName) {
        return this.getString(this.getSchema().indexOf(fieldName));
    }

    public @Nullable ReadableDateTime getDateTime(String fieldName) {
        return this.getDateTime(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Boolean getBoolean(String fieldName) {
        return this.getBoolean(this.getSchema().indexOf(fieldName));
    }

    public <T> @Nullable Collection<T> getArray(String fieldName) {
        return this.getArray(this.getSchema().indexOf(fieldName));
    }

    public <T> @Nullable Iterable<T> getIterable(String fieldName) {
        return this.getIterable(this.getSchema().indexOf(fieldName));
    }

    public <T1, T2> @Nullable Map<T1, T2> getMap(String fieldName) {
        return this.getMap(this.getSchema().indexOf(fieldName));
    }

    public <T> @Nullable T getLogicalTypeValue(String fieldName, Class<T> clazz) {
        return this.getLogicalTypeValue(this.getSchema().indexOf(fieldName), clazz);
    }

    public <T> @Nullable T getBaseValue(String fieldName, Class<T> clazz) {
        return this.getBaseValue(this.getSchema().indexOf(fieldName), clazz);
    }

    public @Nullable Object getBaseValue(String fieldName) {
        return this.getBaseValue(fieldName, Object.class);
    }

    public @Nullable Row getRow(String fieldName) {
        return this.getRow(this.getSchema().indexOf(fieldName));
    }

    public @Nullable Byte getByte(int idx) {
        return (Byte)this.getValue(idx);
    }

    public byte @Nullable [] getBytes(int idx) {
        return (byte[])this.getValue(idx);
    }

    public @Nullable Short getInt16(int idx) {
        return (Short)this.getValue(idx);
    }

    public @Nullable Integer getInt32(int idx) {
        return (Integer)this.getValue(idx);
    }

    public @Nullable Float getFloat(int idx) {
        return (Float)this.getValue(idx);
    }

    public @Nullable Double getDouble(int idx) {
        return (Double)this.getValue(idx);
    }

    public @Nullable Long getInt64(int idx) {
        return (Long)this.getValue(idx);
    }

    public @Nullable String getString(int idx) {
        return (String)this.getValue(idx);
    }

    public @Nullable ReadableDateTime getDateTime(int idx) {
        ReadableInstant instant = (ReadableInstant)this.getValue(idx);
        return instant == null ? null : new DateTime((Object)instant).withZone(instant.getZone());
    }

    public @Nullable BigDecimal getDecimal(int idx) {
        return (BigDecimal)this.getValue(idx);
    }

    public @Nullable Boolean getBoolean(int idx) {
        return (Boolean)this.getValue(idx);
    }

    public <T> @Nullable Collection<T> getArray(int idx) {
        return (Collection)this.getValue(idx);
    }

    public <T> @Nullable Iterable<T> getIterable(int idx) {
        return (Iterable)this.getValue(idx);
    }

    public <T1, T2> @Nullable Map<T1, T2> getMap(int idx) {
        return (Map)this.getValue(idx);
    }

    public <T> @Nullable T getLogicalTypeValue(int idx, Class<T> clazz) {
        return this.getValue(idx);
    }

    public <T> @Nullable T getBaseValue(int idx, Class<T> clazz) {
        Object value = this.getValue(idx);
        Schema.FieldType fieldType = this.getSchema().getField(idx).getType();
        if (fieldType.getTypeName().isLogicalType() && value != null) {
            while (fieldType.getTypeName().isLogicalType()) {
                value = fieldType.getLogicalType().toBaseType(value);
                fieldType = fieldType.getLogicalType().getBaseType();
            }
        }
        return value;
    }

    public @Nullable Object getBaseValue(int idx) {
        return this.getBaseValue(idx, Object.class);
    }

    public @Nullable Row getRow(int idx) {
        return (Row)this.getValue(idx);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)o;
        if (!Objects.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (Equals.deepEquals(this.getValue(i), other.getValue(i), this.getSchema().getField(i).getType())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            h = 31 * h + Equals.deepHashCode(this.getValue(i), this.getSchema().getField(i).getType());
        }
        return h;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeFieldNames) {
        StringBuilder builder = new StringBuilder();
        builder.append("Row: ");
        builder.append(System.lineSeparator());
        for (int i = 0; i < this.getSchema().getFieldCount(); ++i) {
            Schema.Field field = this.getSchema().getField(i);
            if (includeFieldNames) {
                builder.append(field.getName() + ":");
            }
            builder.append(this.toString(field.getType(), this.getValue(i), includeFieldNames));
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    private String toString(Schema.FieldType fieldType, Object value, boolean includeFieldNames) {
        if (value == null) {
            return "<null>";
        }
        StringBuilder builder = new StringBuilder();
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                builder.append("[");
                for (Object element : (Iterable)value) {
                    builder.append(this.toString(fieldType.getCollectionElementType(), element, includeFieldNames));
                    builder.append(", ");
                }
                builder.append("]");
                break;
            }
            case MAP: {
                builder.append("{");
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    builder.append("(");
                    builder.append(this.toString(fieldType.getMapKeyType(), entry.getKey(), includeFieldNames));
                    builder.append(", ");
                    builder.append(this.toString(fieldType.getMapValueType(), entry.getValue(), includeFieldNames));
                    builder.append("), ");
                }
                builder.append("}");
                break;
            }
            case BYTES: {
                builder.append(Arrays.toString((byte[])value));
                break;
            }
            case ROW: {
                builder.append(((Row)value).toString(includeFieldNames));
                break;
            }
            default: {
                builder.append(value);
            }
        }
        return builder.toString();
    }

    public static Builder withSchema(Schema schema) {
        return new Builder(schema);
    }

    public static FieldValueBuilder fromRow(Row row) {
        return new FieldValueBuilder(row.getSchema(), row);
    }

    public static <T> Collector<T, List<Object>, Row> toRow(Schema schema) {
        return Collector.of(() -> new ArrayList(schema.getFieldCount()), List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, values -> Row.withSchema(schema).addValues((List<Object>)values).build(), new Collector.Characteristics[0]);
    }

    public static Row nullRow(Schema schema) {
        return Row.withSchema(schema).addValues(Collections.nCopies(schema.getFieldCount(), null)).build();
    }

    public static class Builder {
        private List<Object> values = Lists.newArrayList();
        private final Schema schema;

        Builder(Schema schema) {
            this.schema = schema;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public FieldValueBuilder withFieldValue(String fieldName, Object value) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValue(fieldName, value);
        }

        public FieldValueBuilder withFieldValue(Integer fieldId, Object value) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValue(fieldId, value);
        }

        public FieldValueBuilder withFieldValue(FieldAccessDescriptor fieldAccessDescriptor, Object value) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValue(fieldAccessDescriptor, value);
        }

        public FieldValueBuilder withFieldValues(Map<String, Object> values) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new FieldValueBuilder(this.schema, null).withFieldValues(values);
        }

        public Builder addValue(@Nullable Object values) {
            this.values.add(values);
            return this;
        }

        public Builder addValues(List<Object> values) {
            this.values.addAll(values);
            return this;
        }

        public Builder addValues(Object ... values) {
            return this.addValues(Arrays.asList(values));
        }

        public <T> Builder addArray(Collection<T> values) {
            this.values.add(values);
            return this;
        }

        public Builder addArray(Object ... values) {
            this.addArray(Arrays.asList(values));
            return this;
        }

        public <T> Builder addIterable(Iterable<T> values) {
            this.values.add(values);
            return this;
        }

        @Internal
        public Row attachValues(List<Object> attachedValues) {
            Preconditions.checkState((boolean)this.values.isEmpty());
            return new RowWithStorage(this.schema, attachedValues);
        }

        public Row attachValues(Object ... values) {
            return this.attachValues(Arrays.asList(values));
        }

        public int nextFieldId() {
            return this.values.size();
        }

        @Internal
        public Row withFieldValueGetters(Factory<List<FieldValueGetter>> fieldValueGetterFactory, Object getterTarget) {
            Preconditions.checkState((getterTarget != null ? 1 : 0) != 0, (Object)"getters require withGetterTarget.");
            return new RowWithGetters(this.schema, fieldValueGetterFactory, getterTarget);
        }

        public Row build() {
            RowUtils.FieldOverrides fieldOverrides;
            Preconditions.checkNotNull((Object)this.schema);
            if (!this.values.isEmpty() && this.values.size() != this.schema.getFieldCount()) {
                throw new IllegalArgumentException("Row expected " + this.schema.getFieldCount() + " fields. initialized with " + this.values.size() + " fields.");
            }
            if (!this.values.isEmpty() && !(fieldOverrides = new RowUtils.FieldOverrides(this.schema, this.values)).isEmpty()) {
                return (Row)new RowUtils.RowFieldMatcher().match(new RowUtils.CapturingRowCases(this.schema, fieldOverrides), Schema.FieldType.row(this.schema), new RowUtils.RowPosition(FieldAccessDescriptor.create()), null);
            }
            return new RowWithStorage(this.schema, Collections.emptyList());
        }
    }

    public static class FieldValueBuilder {
        private final Schema schema;
        private final @Nullable Row sourceRow;
        private final RowUtils.FieldOverrides fieldOverrides;

        private FieldValueBuilder(Schema schema, @Nullable Row sourceRow) {
            this.schema = schema;
            this.sourceRow = sourceRow;
            this.fieldOverrides = new RowUtils.FieldOverrides(schema);
        }

        public Schema getSchema() {
            return this.schema;
        }

        public FieldValueBuilder withFieldValue(String fieldName, Object value) {
            return this.withFieldValue(FieldAccessDescriptor.withFieldNames(fieldName), value);
        }

        public FieldValueBuilder withFieldValue(Integer fieldId, Object value) {
            return this.withFieldValue(FieldAccessDescriptor.withFieldIds(fieldId), value);
        }

        public FieldValueBuilder withFieldValue(FieldAccessDescriptor fieldAccessDescriptor, Object value) {
            FieldAccessDescriptor fieldAccess = fieldAccessDescriptor.resolve(this.getSchema());
            Preconditions.checkArgument((boolean)fieldAccess.referencesSingleField(), (Object)"");
            this.fieldOverrides.addOverride(fieldAccess, new RowUtils.FieldOverride(value));
            return this;
        }

        public FieldValueBuilder withFieldValues(Map<String, Object> values) {
            values.entrySet().stream().forEach(e -> this.fieldOverrides.addOverride(FieldAccessDescriptor.withFieldNames((String)e.getKey()).resolve(this.getSchema()), new RowUtils.FieldOverride(e.getValue())));
            return this;
        }

        public FieldValueBuilder withFieldAccessDescriptors(Map<FieldAccessDescriptor, Object> values) {
            values.entrySet().stream().forEach(e -> this.fieldOverrides.addOverride((FieldAccessDescriptor)e.getKey(), new RowUtils.FieldOverride(e.getValue())));
            return this;
        }

        public Row build() {
            Row row = (Row)new RowUtils.RowFieldMatcher().match(new RowUtils.CapturingRowCases(this.getSchema(), this.fieldOverrides), Schema.FieldType.row(this.getSchema()), new RowUtils.RowPosition(FieldAccessDescriptor.create()), this.sourceRow);
            return row;
        }
    }

    public static class Equals {
        public static boolean deepEquals(Object a, Object b, Schema.FieldType fieldType) {
            if (a == null || b == null) {
                return a == b;
            }
            if (fieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
                return Equals.deepEquals(SchemaUtils.toLogicalBaseType(fieldType.getLogicalType(), a), SchemaUtils.toLogicalBaseType(fieldType.getLogicalType(), b), fieldType.getLogicalType().getBaseType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.BYTES) {
                return Arrays.equals((byte[])a, (byte[])b);
            }
            if (fieldType.getTypeName() == Schema.TypeName.ARRAY) {
                return Equals.deepEqualsForCollection((Collection)a, (Collection)b, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.ITERABLE) {
                return Equals.deepEqualsForIterable((Iterable)a, (Iterable)b, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return Equals.deepEqualsForMap((Map)a, (Map)b, fieldType.getMapValueType());
            }
            return Objects.equals(a, b);
        }

        public static int deepHashCode(Object a, Schema.FieldType fieldType) {
            if (a == null) {
                return 0;
            }
            if (fieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
                return Equals.deepHashCode(a, fieldType.getLogicalType().getBaseType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.BYTES) {
                return Arrays.hashCode((byte[])a);
            }
            if (fieldType.getTypeName().isCollectionType()) {
                return Equals.deepHashCodeForIterable((Iterable)a, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return Equals.deepHashCodeForMap((Map)a, fieldType.getMapKeyType(), fieldType.getMapValueType());
            }
            return Objects.hashCode(a);
        }

        static <K, V> boolean deepEqualsForMap(Map<K, V> a, Map<K, V> b, Schema.FieldType valueType) {
            if (a == b) {
                return true;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : a.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                V otherValue = b.get(key);
                if (!(value == null ? otherValue != null || !b.containsKey(key) : !Equals.deepEquals(value, otherValue, valueType))) continue;
                return false;
            }
            return true;
        }

        static int deepHashCodeForMap(Map<Object, Object> a, Schema.FieldType keyType, Schema.FieldType valueType) {
            int h = 0;
            for (Map.Entry<Object, Object> e : a.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                h += Equals.deepHashCode(key, keyType) ^ Equals.deepHashCode(value, valueType);
            }
            return h;
        }

        static boolean deepEqualsForCollection(Collection<Object> a, Collection<Object> b, Schema.FieldType elementType) {
            if (a == b) {
                return true;
            }
            if (a.size() != b.size()) {
                return false;
            }
            return Equals.deepEqualsForIterable(a, b, elementType);
        }

        static boolean deepEqualsForIterable(Iterable<Object> a, Iterable<Object> b, Schema.FieldType elementType) {
            if (a == b) {
                return true;
            }
            Iterator<Object> bIter = b.iterator();
            for (Object currentA : a) {
                if (!bIter.hasNext()) {
                    return false;
                }
                if (Equals.deepEquals(currentA, bIter.next(), elementType)) continue;
                return false;
            }
            return !bIter.hasNext();
        }

        static int deepHashCodeForIterable(Iterable<Object> a, Schema.FieldType elementType) {
            int h = 1;
            for (Object o : a) {
                h = 31 * h + Equals.deepHashCode(o, elementType);
            }
            return h;
        }
    }
}

