/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalListener;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalNotification;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrobatchSource<T, CheckpointMarkT extends UnboundedSource.CheckpointMark>
extends Source<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MicrobatchSource.class);
    private static volatile Cache<MicrobatchSource<?, ?>, Source.Reader<?>> readerCache;
    private final UnboundedSource<T, CheckpointMarkT> source;
    private final Duration maxReadTime;
    private final int numInitialSplits;
    private final long maxNumRecords;
    private final int sourceId;
    private final double readerCacheInterval;
    private final int splitId;

    MicrobatchSource(UnboundedSource<T, CheckpointMarkT> source, Duration maxReadTime, int numInitialSplits, long maxNumRecords, int splitId, int sourceId, double readerCacheInterval) {
        this.source = source;
        this.maxReadTime = maxReadTime;
        this.numInitialSplits = numInitialSplits;
        this.maxNumRecords = maxNumRecords;
        this.splitId = splitId;
        this.sourceId = sourceId;
        this.readerCacheInterval = readerCacheInterval;
    }

    private static synchronized void initReaderCache(long readerCacheInterval) {
        if (readerCache == null) {
            LOG.info("Creating reader cache. Cache interval = {} ms.", (Object)readerCacheInterval);
            readerCache = CacheBuilder.newBuilder().expireAfterAccess(readerCacheInterval, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new ReaderCacheRemovalListener()).build();
        }
    }

    private static long[] splitNumRecords(long numRecords, int numSplits) {
        int i;
        long[] splitNumRecords = new long[numSplits];
        for (i = 0; i < numSplits; ++i) {
            splitNumRecords[i] = numRecords / (long)numSplits;
        }
        i = 0;
        while ((long)i < numRecords % (long)numSplits) {
            splitNumRecords[i] = splitNumRecords[i] + 1L;
            ++i;
        }
        return splitNumRecords;
    }

    List<? extends Source<T>> split(PipelineOptions options) throws Exception {
        ArrayList<MicrobatchSource<T, CheckpointMarkT>> result = new ArrayList<MicrobatchSource<T, CheckpointMarkT>>();
        List splits = this.source.split(this.numInitialSplits, options);
        int numSplits = splits.size();
        long[] numRecords = MicrobatchSource.splitNumRecords(this.maxNumRecords, numSplits);
        for (int i = 0; i < numSplits; ++i) {
            result.add(new MicrobatchSource<T, CheckpointMarkT>((UnboundedSource)splits.get(i), this.maxReadTime, 1, numRecords[i], i, this.sourceId, this.readerCacheInterval));
        }
        return result;
    }

    public Source.Reader<T> getOrCreateReader(PipelineOptions options, CheckpointMarkT checkpointMark) throws IOException {
        try {
            MicrobatchSource.initReaderCache((long)this.readerCacheInterval);
            return (Source.Reader)readerCache.get((Object)this, (Callable)new ReaderLoader(this, options, checkpointMark));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get or create reader", e);
        }
    }

    public void validate() {
        this.source.validate();
    }

    public Coder<T> getOutputCoder() {
        return this.source.getOutputCoder();
    }

    public Coder<CheckpointMarkT> getCheckpointMarkCoder() {
        return this.source.getCheckpointMarkCoder();
    }

    public String getId() {
        return this.sourceId + "_" + this.splitId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MicrobatchSource)) {
            return false;
        }
        MicrobatchSource that = (MicrobatchSource)((Object)o);
        if (this.sourceId != that.sourceId) {
            return false;
        }
        return this.splitId == that.splitId;
    }

    public int hashCode() {
        int result = this.sourceId;
        result = 31 * result + this.splitId;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearCache() {
        Class<MicrobatchSource> clazz = MicrobatchSource.class;
        synchronized (MicrobatchSource.class) {
            readerCache.invalidateAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class ReaderCacheRemovalListener
    implements RemovalListener<MicrobatchSource<?, ?>, Source.Reader<?>> {
        private ReaderCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<MicrobatchSource<?, ?>, Source.Reader<?>> notification) {
            try {
                ((Source.Reader)notification.getValue()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReaderLoader
    implements Callable<Source.Reader<T>> {
        private final PipelineOptions options;
        private final CheckpointMarkT checkpointMark;
        final /* synthetic */ MicrobatchSource this$0;

        ReaderLoader(PipelineOptions options, CheckpointMarkT checkpointMark) {
            this.this$0 = var1_1;
            this.options = options;
            this.checkpointMark = checkpointMark;
        }

        @Override
        public Reader call() throws Exception {
            LOG.info("No cached reader found for split: [" + this.this$0.source + "]. Creating new reader at checkpoint mark " + this.checkpointMark);
            return this.this$0.new Reader(this.this$0.source.createReader(this.options, this.checkpointMark));
        }
    }

    public class Reader
    extends Source.Reader<T> {
        private long recordsRead = 0L;
        private Instant readEndTime;
        private final FluentBackoff backoffFactory;
        private final UnboundedSource.UnboundedReader<T> unboundedReader;
        private boolean started;

        private Reader(UnboundedSource.UnboundedReader<T> unboundedReader) {
            this.unboundedReader = unboundedReader;
            this.backoffFactory = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)10L)).withMaxBackoff(MicrobatchSource.this.maxReadTime.minus((ReadableDuration)Duration.millis((long)1L))).withMaxCumulativeBackoff(MicrobatchSource.this.maxReadTime.minus((ReadableDuration)Duration.millis((long)1L)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean startIfNeeded() throws IOException {
            if (this.started) return false;
            this.started = true;
            if (!true) return false;
            if (!this.unboundedReader.start()) return false;
            return true;
        }

        private void prepareForNewBatchReading() {
            this.readEndTime = Instant.now().plus((ReadableDuration)MicrobatchSource.this.maxReadTime);
            this.recordsRead = 0L;
        }

        public boolean start() throws IOException {
            LOG.debug("MicrobatchReader-{}: Starting a microbatch read from an unbounded source with a max read time of {} millis, and max number of records {}.", new Object[]{MicrobatchSource.this.splitId, MicrobatchSource.this.maxReadTime, MicrobatchSource.this.maxNumRecords});
            this.prepareForNewBatchReading();
            return this.startIfNeeded() || this.advanceWithBackoff();
        }

        public boolean advance() throws IOException {
            if (this.recordsRead >= MicrobatchSource.this.maxNumRecords) {
                this.finalizeCheckpoint();
                return false;
            }
            return this.advanceWithBackoff();
        }

        private boolean advanceWithBackoff() throws IOException {
            BackOff backoff = this.backoffFactory.backoff();
            long nextSleep = backoff.nextBackOffMillis();
            while (nextSleep != -1L) {
                if (this.readEndTime != null && Instant.now().isAfter((ReadableInstant)this.readEndTime)) {
                    this.finalizeCheckpoint();
                    return false;
                }
                if (this.unboundedReader.advance()) {
                    ++this.recordsRead;
                    return true;
                }
                Uninterruptibles.sleepUninterruptibly((long)nextSleep, (TimeUnit)TimeUnit.MILLISECONDS);
                nextSleep = backoff.nextBackOffMillis();
            }
            this.finalizeCheckpoint();
            return false;
        }

        private void finalizeCheckpoint() throws IOException {
            this.unboundedReader.getCheckpointMark().finalizeCheckpoint();
            LOG.debug("MicrobatchReader-{}: finalized CheckpointMark successfully after reading {} records.", (Object)MicrobatchSource.this.splitId, (Object)this.recordsRead);
        }

        public T getCurrent() throws NoSuchElementException {
            return this.unboundedReader.getCurrent();
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.unboundedReader.getCurrentTimestamp();
        }

        public void close() throws IOException {
            this.unboundedReader.close();
        }

        public Source<T> getCurrentSource() {
            return MicrobatchSource.this;
        }

        public CheckpointMarkT getCheckpointMark() {
            return this.unboundedReader.getCheckpointMark();
        }

        public Instant getWatermark() {
            return this.unboundedReader.getWatermark();
        }
    }
}

