/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitStats;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class CommitResponse {
    private final com.google.spanner.v1.CommitResponse proto;

    public CommitResponse(Timestamp commitTimestamp) {
        this.proto = com.google.spanner.v1.CommitResponse.newBuilder().setCommitTimestamp(commitTimestamp.toProto()).build();
    }

    CommitResponse(com.google.spanner.v1.CommitResponse proto) {
        this.proto = (com.google.spanner.v1.CommitResponse)Preconditions.checkNotNull((Object)proto);
    }

    public Timestamp getCommitTimestamp() {
        return Timestamp.fromProto((com.google.protobuf.Timestamp)this.proto.getCommitTimestamp());
    }

    public boolean hasCommitStats() {
        return this.proto.hasCommitStats();
    }

    public CommitStats getCommitStats() {
        Preconditions.checkState((boolean)this.proto.hasCommitStats(), (Object)"The CommitResponse does not contain any commit statistics.");
        return CommitStats.fromProto(this.proto.getCommitStats());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitResponse that = (CommitResponse)o;
        return Objects.equals(this.proto, that.proto);
    }

    public int hashCode() {
        return Objects.hash(this.proto);
    }
}

