/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.protobuf.Message;
import com.google.rpc.BadRequest;
import com.google.rpc.Help;
import com.google.rpc.LocalizedMessage;
import com.google.rpc.QuotaFailure;
import com.google.rpc.RequestInfo;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SpannerErrorInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(SpannerErrorInterceptor.class.getName());
    private static final Metadata.Key<LocalizedMessage> LOCALIZED_MESSAGE_KEY = ProtoUtils.keyForProto((Message)LocalizedMessage.getDefaultInstance());
    private static final Metadata.Key<BadRequest> BAD_REQUEST_KEY = ProtoUtils.keyForProto((Message)BadRequest.getDefaultInstance());
    private static final Metadata.Key<Help> HELP_KEY = ProtoUtils.keyForProto((Message)Help.getDefaultInstance());
    private static final Metadata.Key<QuotaFailure> QUOTA_FAILURE_KEY = ProtoUtils.keyForProto((Message)QuotaFailure.getDefaultInstance());
    private static final Metadata.Key<RequestInfo> REQUEST_INFO_KEY = ProtoUtils.keyForProto((Message)RequestInfo.getDefaultInstance());
    private static final Metadata.Key<ResourceInfo> RESOURCE_INFO_KEY = ProtoUtils.keyForProto((Message)ResourceInfo.getDefaultInstance());
    private static final Metadata.Key<RetryInfo> RETRY_INFO_KEY = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClose(Status status, Metadata trailers) {
                        try {
                            if (trailers.containsKey(LOCALIZED_MESSAGE_KEY)) {
                                status = Status.fromCodeValue((int)status.getCode().value()).withDescription(((LocalizedMessage)trailers.get(LOCALIZED_MESSAGE_KEY)).getMessage());
                            }
                            if (trailers.containsKey(BAD_REQUEST_KEY)) {
                                status = status.augmentDescription(((BadRequest)trailers.get(BAD_REQUEST_KEY)).toString());
                            }
                            if (trailers.containsKey(HELP_KEY)) {
                                status = status.augmentDescription(((Help)trailers.get(HELP_KEY)).toString());
                            }
                            if (trailers.containsKey(QUOTA_FAILURE_KEY)) {
                                status = status.augmentDescription(((QuotaFailure)trailers.get(QUOTA_FAILURE_KEY)).toString());
                            }
                            if (trailers.containsKey(REQUEST_INFO_KEY)) {
                                status = status.augmentDescription(((RequestInfo)trailers.get(REQUEST_INFO_KEY)).toString());
                            }
                            if (trailers.containsKey(RESOURCE_INFO_KEY)) {
                                status = status.augmentDescription(((ResourceInfo)trailers.get(RESOURCE_INFO_KEY)).toString());
                            }
                            if (trailers.containsKey(RETRY_INFO_KEY)) {
                                status = status.augmentDescription(((RetryInfo)trailers.get(RETRY_INFO_KEY)).toString());
                            }
                        }
                        catch (IllegalArgumentException e) {
                            logger.log(Level.WARNING, "Invalid protocol message in metadata", e);
                        }
                        finally {
                            super.onClose(status, trailers);
                        }
                    }
                }, headers);
            }
        };
    }
}

