/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.shared.VariableValue;
import org.apache.hop.beam.core.transform.BeamRowHandler;
import org.apache.hop.beam.core.transform.TransformBaseFn;
import org.apache.hop.beam.core.util.HopBeamUtil;
import org.apache.hop.beam.engines.HopPipelineExecutionOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowHandler;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transforms.dummy.DummyMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorField;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;
import org.joda.time.Instant;
import org.json.simple.parser.ParseException;

public class TransformFn
extends TransformBaseFn {
    private static final long serialVersionUID = 95700000000000001L;
    public static final String INJECTOR_TRANSFORM_NAME = "_INJECTOR_";
    protected List<VariableValue> variableValues;
    protected String metastoreJson;
    protected List<String> transformPluginClasses;
    protected List<String> xpPluginClasses;
    protected String transformPluginId;
    protected String transformMetaInterfaceXml;
    protected String inputRowMetaJson;
    protected String dataSamplersJson;
    protected List<String> targetTransforms;
    protected List<String> infoTransforms;
    protected List<String> infoRowMetaJsons;
    protected boolean inputTransform;
    protected boolean initialize;
    protected List<PCollectionView<List<HopRow>>> infoCollectionViews;
    protected List<PCollection<HopRow>> infoCollections;
    private final Counter numErrors = Metrics.counter((String)"main", (String)"TransformProcessErrors");
    private transient PipelineMeta pipelineMeta;
    private transient TransformMeta transformMeta;
    private transient IRowMeta inputRowMeta;
    private transient List<TransformMetaDataCombi> transformCombis;
    private transient LocalPipelineEngine pipeline;
    private transient RowProducer rowProducer;
    private transient List<HopRow> resultRows;
    private transient List<List<Object[]>> targetResultRowsList;
    private transient TupleTag<HopRow> mainTupleTag;
    private transient List<TupleTag<HopRow>> tupleTagList;
    private transient Counter readCounter;
    private transient Counter writtenCounter;

    public TransformFn() {
        super(null, null, null);
    }

    public TransformFn(List<VariableValue> variableValues, String metastoreJson, List<String> transformPluginClasses, List<String> xpPluginClasses, String transformName, String transformPluginId, String transformMetaInterfaceXml, String inputRowMetaJson, boolean inputTransform, List<String> targetTransforms, List<String> infoTransforms, List<String> infoRowMetaJsons, String dataSamplersJson, String runConfigName, String parentLogChannelId, List<PCollectionView<List<HopRow>>> infoCollectionViews) {
        super(parentLogChannelId, runConfigName, dataSamplersJson);
        this.variableValues = variableValues;
        this.metastoreJson = metastoreJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
        this.transformName = transformName;
        this.transformPluginId = transformPluginId;
        this.transformMetaInterfaceXml = transformMetaInterfaceXml;
        this.inputRowMetaJson = inputRowMetaJson;
        this.inputTransform = inputTransform;
        this.targetTransforms = targetTransforms;
        this.infoTransforms = infoTransforms;
        this.infoRowMetaJsons = infoRowMetaJsons;
        this.dataSamplersJson = dataSamplersJson;
        this.infoCollectionViews = infoCollectionViews;
        this.initialize = true;
    }

    @DoFn.Setup
    public void setup() {
    }

    @DoFn.StartBundle
    public void startBundle(DoFn.StartBundleContext startBundleContext) {
        try {
            if (this.executor != null) {
                this.executor.getPipeline().getTransforms().forEach(combi -> combi.data.setBeamBundleNr(combi.data.getBeamBundleNr() + 1));
                this.executor.startBundle();
            }
        }
        catch (HopException e) {
            throw new RuntimeException("Error at start of bundle!", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context, BoundedWindow window) {
        try {
            if (this.initialize) {
                this.initializeTransformPipeline(context);
            }
            HopRow originalInputRow = (HopRow)context.element();
            HopRow inputRow = HopBeamUtil.copyHopRow(originalInputRow, this.inputRowMeta);
            this.readCounter.inc();
            this.emptyRowBuffer(new TransformProcessContext(context), inputRow);
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Transform execution error :" + e.getMessage());
            throw new RuntimeException("Error executing TransformFn", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTransformPipeline(DoFn.ProcessContext context) throws HopException, ParseException, JsonProcessingException {
        this.initialize = false;
        BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
        SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(this.metastoreJson);
        Variables variables = new Variables();
        for (VariableValue variableValue : this.variableValues) {
            if (!StringUtils.isNotEmpty((String)variableValue.getVariable())) continue;
            variables.setVariable(variableValue.getVariable(), variableValue.getValue());
        }
        this.pipelineMeta = new PipelineMeta();
        this.pipelineMeta.setName(this.transformName);
        this.pipelineMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
        this.pipelineMeta.setMetadataProvider((IHopMetadataProvider)metadataProvider);
        this.inputRowMeta = JsonRowMeta.fromJson((String)this.inputRowMetaJson);
        ArrayList<IRowMeta> infoRowMetas = new ArrayList<IRowMeta>();
        for (String infoRowMetaJson : this.infoRowMetaJsons) {
            IRowMeta infoRowMeta = JsonRowMeta.fromJson((String)infoRowMetaJson);
            infoRowMetas.add(infoRowMeta);
        }
        Object var5_7 = null;
        if (!this.inputTransform) {
            TransformMeta transformMeta = this.createInjectorTransform(this.pipelineMeta, INJECTOR_TRANSFORM_NAME, this.inputRowMeta, 200, 200);
        }
        int targetLocationY = 200;
        ArrayList<TransformMeta> targetTransformMetas = new ArrayList<TransformMeta>();
        for (String targetTransform : this.targetTransforms) {
            DummyMeta dummyMeta = new DummyMeta();
            TransformMeta targetTransformMeta = new TransformMeta(targetTransform, (ITransformMeta)dummyMeta);
            targetTransformMeta.setLocation(600, targetLocationY);
            targetLocationY += 150;
            targetTransformMetas.add(targetTransformMeta);
            this.pipelineMeta.addTransform(targetTransformMeta);
        }
        ArrayList<List> infoDataSets = new ArrayList<List>();
        ArrayList<TransformMeta> infoTransformMetas = new ArrayList<TransformMeta>();
        for (int i = 0; i < this.infoTransforms.size(); ++i) {
            String infoTransform = this.infoTransforms.get(i);
            PCollectionView<List<HopRow>> cv = this.infoCollectionViews.get(i);
            List list = (List)context.sideInput(cv);
            infoDataSets.add(list);
            IRowMeta infoRowMeta = (IRowMeta)infoRowMetas.get(i);
            TransformMeta infoTransformMeta = this.createInjectorTransform(this.pipelineMeta, infoTransform, infoRowMeta, 200, 350 + 150 * i);
            infoTransformMetas.add(infoTransformMeta);
        }
        this.transformCombis = new ArrayList<TransformMetaDataCombi>();
        PluginRegistry registry = PluginRegistry.getInstance();
        ITransformMeta iTransformMeta = (ITransformMeta)registry.loadClass(TransformPluginType.class, this.transformPluginId, ITransformMeta.class);
        if (iTransformMeta == null) {
            throw new HopException("Unable to load transform plugin with ID " + this.transformPluginId + ", this plugin isn't in the plugin registry or classpath");
        }
        HopBeamUtil.loadTransformMetadataFromXml(this.transformName, iTransformMeta, this.transformMetaInterfaceXml, this.pipelineMeta.getMetadataProvider());
        this.transformMeta = new TransformMeta(this.transformName, iTransformMeta);
        this.transformMeta.setTransformPluginId(this.transformPluginId);
        this.transformMeta.setLocation(400, 200);
        this.pipelineMeta.addTransform(this.transformMeta);
        if (!this.inputTransform) {
            void var5_9;
            this.pipelineMeta.addPipelineHop(new PipelineHopMeta((TransformMeta)var5_9, this.transformMeta));
        }
        for (TransformMeta transformMeta : targetTransformMetas) {
            this.pipelineMeta.addPipelineHop(new PipelineHopMeta(this.transformMeta, transformMeta));
        }
        for (TransformMeta transformMeta : infoTransformMetas) {
            this.pipelineMeta.addPipelineHop(new PipelineHopMeta(transformMeta, this.transformMeta));
        }
        this.lookupExecutionInformation((IVariables)variables, (IHopMetadataProvider)metadataProvider);
        iTransformMeta.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
        this.pipeline = new LocalPipelineEngine(this.pipelineMeta, (IVariables)variables, (ILoggingObject)new LoggingObject((Object)"apache-beam-transform"));
        this.pipeline.setLogLevel(((HopPipelineExecutionOptions)context.getPipelineOptions().as(HopPipelineExecutionOptions.class)).getLogLevel());
        this.pipeline.setMetadataProvider(this.pipelineMeta.getMetadataProvider());
        this.pipeline.getPipelineRunConfiguration().setName("beam-transform-local (" + this.transformName + ")");
        this.pipeline.prepareExecution();
        this.pipeline.getTransforms().forEach(c -> {
            c.data.setBeamContext(true);
            c.data.setBeamBundleNr(1);
        });
        this.rowProducer = null;
        if (!this.inputTransform) {
            this.rowProducer = this.pipeline.addRowProducer(INJECTOR_TRANSFORM_NAME, 0);
        }
        ArrayList<RowProducer> infoRowProducers = new ArrayList<RowProducer>();
        for (String infoTransform : this.infoTransforms) {
            RowProducer infoRowProducer = this.pipeline.addRowProducer(infoTransform, 0);
            infoRowProducers.add(infoRowProducer);
        }
        if (!this.inputTransform) {
            TransformMetaDataCombi transformMetaDataCombi = this.findCombi((Pipeline)this.pipeline, INJECTOR_TRANSFORM_NAME);
            this.transformCombis.add(transformMetaDataCombi);
        }
        TransformMetaDataCombi transformMetaDataCombi = this.findCombi((Pipeline)this.pipeline, this.transformName);
        this.transformCombis.add(transformMetaDataCombi);
        if (this.targetTransforms.isEmpty()) {
            RowAdapter rowListener = new RowAdapter(){

                public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                    TransformFn.this.resultRows.add(new HopRow(row, rowMeta.size()));
                }
            };
            transformMetaDataCombi.transform.addRowListener((IRowListener)rowListener);
        }
        this.mainTupleTag = new TupleTag<HopRow>(HopBeamUtil.createMainOutputTupleId(this.transformName)){};
        this.tupleTagList = new ArrayList<TupleTag<HopRow>>();
        this.targetResultRowsList = new ArrayList<List<Object[]>>();
        for (String targetTransform : this.targetTransforms) {
            TransformMetaDataCombi targetCombi = this.findCombi((Pipeline)this.pipeline, targetTransform);
            this.transformCombis.add(targetCombi);
            String tupleId = HopBeamUtil.createTargetTupleId(this.transformName, targetTransform);
            TupleTag<HopRow> tupleTag = new TupleTag<HopRow>(tupleId){};
            this.tupleTagList.add(tupleTag);
            final ArrayList targetResultRows = new ArrayList();
            this.targetResultRowsList.add(targetResultRows);
            targetCombi.transform.addRowListener((IRowListener)new RowAdapter(){

                public void rowReadEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                    targetResultRows.add(row);
                }
            });
        }
        this.attachExecutionSamplersToOutput((IVariables)variables, this.transformName, this.pipeline.getLogChannelId(), this.inputRowMeta, this.pipelineMeta.getTransformFields((IVariables)variables, this.transformName), this.pipeline.getTransform(this.transformName, 0));
        for (TransformMetaDataCombi c2 : this.pipeline.getTransforms()) {
            ((BaseTransform)c2.transform).setRowHandler((IRowHandler)new BeamRowHandler((BaseTransform)c2.transform));
        }
        this.executor = new SingleThreadedPipelineExecutor((Pipeline)this.pipeline);
        this.executor.init();
        Counter initCounter = Metrics.counter((String)"init", (String)this.transformName);
        this.readCounter = Metrics.counter((String)"read", (String)this.transformName);
        this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
        initCounter.inc();
        this.pipeline.startThreads();
        this.resultRows = new ArrayList<HopRow>();
        for (int i = 0; i < this.infoTransforms.size(); ++i) {
            RowProducer infoRowProducer = (RowProducer)infoRowProducers.get(i);
            List infoDataSet = (List)infoDataSets.get(i);
            TransformMetaDataCombi combi = this.findCombi((Pipeline)this.pipeline, this.infoTransforms.get(i));
            IRowMeta infoRowMeta = (IRowMeta)infoRowMetas.get(i);
            for (HopRow infoRowData : infoDataSet) {
                infoRowProducer.putRow(infoRowMeta, infoRowData.getRow());
                combi.transform.processRow();
            }
            infoRowProducer.finished();
            combi.transform.processRow();
        }
        this.executor.startBundle();
    }

    private synchronized void emptyRowBuffer(TupleOutputContext<HopRow> context, HopRow inputRow) throws HopException {
        this.resultRows.clear();
        for (int t = 0; t < this.targetTransforms.size(); ++t) {
            this.targetResultRowsList.get(t).clear();
        }
        if (!this.inputTransform) {
            this.rowProducer.putRow(this.inputRowMeta, inputRow.getRow(), false);
        }
        this.executor.oneIteration();
        for (HopRow resultRow : this.resultRows) {
            context.output(this.mainTupleTag, resultRow);
            this.writtenCounter.inc();
        }
        for (int t = 0; t < this.targetResultRowsList.size(); ++t) {
            List<Object[]> targetRowsList = this.targetResultRowsList.get(t);
            TupleTag<HopRow> tupleTag = this.tupleTagList.get(t);
            for (Object[] targetRow : targetRowsList) {
                context.output(tupleTag, new HopRow(targetRow));
            }
        }
    }

    private TransformMeta createInjectorTransform(PipelineMeta pipelineMeta, String injectorTransformName, IRowMeta injectorRowMeta, int x, int y) {
        InjectorMeta injectorMeta = new InjectorMeta();
        for (IValueMeta valueMeta : injectorRowMeta.getValueMetaList()) {
            injectorMeta.getInjectorFields().add(new InjectorField(valueMeta.getName(), valueMeta.getTypeDesc(), Integer.toString(valueMeta.getLength()), Integer.toString(valueMeta.getPrecision())));
        }
        TransformMeta injectorTransformMeta = new TransformMeta(injectorTransformName, (ITransformMeta)injectorMeta);
        injectorTransformMeta.setLocation(x, y);
        pipelineMeta.addTransform(injectorTransformMeta);
        return injectorTransformMeta;
    }

    private TransformMetaDataCombi findCombi(Pipeline pipeline, String transformName) {
        for (TransformMetaDataCombi combi : pipeline.getTransforms()) {
            if (!combi.transformName.equals(transformName)) continue;
            return combi;
        }
        throw new RuntimeException("Configuration error, transform '" + transformName + "' not found in transformation");
    }

    @DoFn.FinishBundle
    public void finishBundle(DoFn.FinishBundleContext context) {
        try {
            if (this.executor != null) {
                this.executor.finishBundle();
            }
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Transform finishing bundle error :" + e.getMessage());
            throw new RuntimeException("Error finalizing bundle of transform '" + this.transformName + "'", e);
        }
    }

    @DoFn.Teardown
    public void tearDown() {
        try {
            if (this.executor != null) {
                this.executor.dispose();
            }
            if (this.executionInfoLocation != null) {
                if (this.executionInfoTimer != null) {
                    this.executionInfoTimer.cancel();
                }
                this.sendSamplesToLocation(true);
                this.executionInfoLocation.getExecutionInfoLocation().close();
            }
        }
        catch (Exception e) {
            LOG.error("Error sending row samples to execution info location for transform " + this.transformName, (Throwable)e);
            throw new RuntimeException("Error sending row samples to execution info location for transform " + this.transformName, e);
        }
    }

    private class TransformFinishBundleContext
    implements TupleOutputContext<HopRow> {
        private DoFn.FinishBundleContext context;
        private BoundedWindow batchWindow;

        public TransformFinishBundleContext(DoFn.FinishBundleContext context, BoundedWindow batchWindow) {
            this.context = context;
            this.batchWindow = batchWindow;
        }

        @Override
        public void output(TupleTag<HopRow> tupleTag, HopRow output) {
            this.context.output(tupleTag, (Object)output, Instant.now(), this.batchWindow);
        }
    }

    private static interface TupleOutputContext<T> {
        public void output(TupleTag<T> var1, T var2);
    }

    private class TransformProcessContext
    implements TupleOutputContext<HopRow> {
        private DoFn.ProcessContext context;

        public TransformProcessContext(DoFn.ProcessContext processContext) {
            this.context = processContext;
        }

        @Override
        public void output(TupleTag<HopRow> tupleTag, HopRow output) {
            this.context.output(tupleTag, (Object)output);
        }
    }
}

