/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.localsingle;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineCapabilities;
import org.apache.hop.pipeline.engines.localsingle.LocalSinglePipelineRunConfiguration;

public class LocalSinglePipelineEngine
extends Pipeline
implements IPipelineEngine<PipelineMeta> {
    public LocalSinglePipelineEngine() {
    }

    public LocalSinglePipelineEngine(PipelineMeta pipelineMeta) {
        super(pipelineMeta);
    }

    public LocalSinglePipelineEngine(PipelineMeta pipelineMeta, IVariables variables, ILoggingObject parent) {
        super(pipelineMeta, variables, parent);
    }

    public <Parent extends IVariables & INamedParameters> LocalSinglePipelineEngine(Parent parent, String name, String filename, IHopMetadataProvider metadataProvider) throws HopException {
        super(parent, name, filename, metadataProvider);
    }

    @Override
    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration() {
        return new LocalSinglePipelineRunConfiguration();
    }

    @Override
    public PipelineEngineCapabilities getEngineCapabilities() {
        return new PipelineEngineCapabilities(true, true, true, true);
    }

    @Override
    public void prepareExecution() throws HopException {
        this.pipelineMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
        super.prepareExecution();
    }

    @Override
    public void startThreads() throws HopException {
        super.startThreads();
        SingleThreadedPipelineExecutor executor = new SingleThreadedPipelineExecutor(this);
        if (!executor.init()) {
            throw new HopException("Error initializing single threaded pipeline execution. See the log for more details.");
        }
        while (executor.oneIteration() && !this.isStopped()) {
        }
    }

    @Override
    public String getStatusDescription() {
        return super.getStatus();
    }
}

