/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tablecompare;

import java.util.Arrays;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompare;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompareMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.LabelCombo;
import org.apache.hop.ui.core.widget.LabelText;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TableCompareDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = TableCompare.class;
    private final TableCompareMeta input;
    private IRowMeta prevFields = null;
    private MetaSelectionLine<DatabaseMeta> wReferenceDB;
    private LabelCombo wReferenceSchema;
    private LabelCombo wReferenceTable;
    private MetaSelectionLine<DatabaseMeta> wCompareDB;
    private LabelCombo wCompareSchema;
    private LabelCombo wCompareTable;
    private LabelCombo wKeyFields;
    private LabelCombo wExcludeFields;
    private LabelText wNrErrors;
    private LabelText wNrRecordsReference;
    private LabelText wNrRecordsCompare;
    private LabelText wNrErrorsLeftJoin;
    private LabelText wNrErrorsInnerJoin;
    private LabelText wNrErrorsRightJoin;
    private LabelCombo wKeyDesc;
    private LabelCombo wReferenceValue;
    private LabelCombo wCompareValue;

    public TableCompareDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (TableCompareMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableCompareDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.Shell.Title", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        ScrolledComposite sc = new ScrolledComposite((Composite)this.shell, 768);
        CTabFolder wTabFolder = new CTabFolder((Composite)sc, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wReferenceTab = new CTabItem(wTabFolder, 0);
        wReferenceTab.setText(BaseMessages.getString(PKG, (String)"TableComparisonDialog.ReferenceTab.TabTitle", (String[])new String[0]));
        FormLayout referenceLayout = new FormLayout();
        referenceLayout.marginWidth = 3;
        referenceLayout.marginHeight = 3;
        Composite wReferenceComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wReferenceComp);
        wReferenceComp.setLayout((Layout)referenceLayout);
        DatabaseMeta refDatabaseMeta = this.pipelineMeta.findDatabase(this.input.getReferenceConnection(), this.variables);
        this.wReferenceDB = this.addConnectionLine(wReferenceComp, null, refDatabaseMeta, lsMod, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceDB.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceDB.Tooltip", (String[])new String[0]));
        this.wReferenceDB.addSelectionListener((SelectionListener)lsSelection);
        LabelCombo lastControl = this.wReferenceDB;
        this.wReferenceSchema = new LabelCombo(wReferenceComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceSchemaField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceSchemaField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceSchema);
        FormData fdReferenceSchema = new FormData();
        fdReferenceSchema.left = new FormAttachment(0, 0);
        fdReferenceSchema.top = new FormAttachment(lastControl, margin);
        fdReferenceSchema.right = new FormAttachment(100, 0);
        this.wReferenceSchema.setLayoutData((Object)fdReferenceSchema);
        lastControl = this.wReferenceSchema;
        this.wReferenceTable = new LabelCombo(wReferenceComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceTableField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceTableField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceTable);
        FormData fdReferenceTable = new FormData();
        fdReferenceTable.left = new FormAttachment(0, 0);
        fdReferenceTable.top = new FormAttachment((Control)lastControl, margin);
        fdReferenceTable.right = new FormAttachment(100, 0);
        this.wReferenceTable.setLayoutData((Object)fdReferenceTable);
        FormData fdReferenceComp = new FormData();
        fdReferenceComp.left = new FormAttachment(0, 0);
        fdReferenceComp.top = new FormAttachment(0, 0);
        fdReferenceComp.right = new FormAttachment(100, 0);
        fdReferenceComp.bottom = new FormAttachment(100, 0);
        wReferenceComp.setLayoutData((Object)fdReferenceComp);
        wReferenceComp.layout();
        wReferenceTab.setControl((Control)wReferenceComp);
        CTabItem wComparisonTab = new CTabItem(wTabFolder, 0);
        wComparisonTab.setText(BaseMessages.getString(PKG, (String)"TableComparisonDialog.ComparisonTab.TabTitle", (String[])new String[0]));
        FormLayout comparisonLayout = new FormLayout();
        comparisonLayout.marginWidth = 3;
        comparisonLayout.marginHeight = 3;
        Composite wComparisonComp = new Composite((Composite)wTabFolder, 0);
        wComparisonComp.setLayout((Layout)comparisonLayout);
        this.props.setLook((Control)wComparisonComp);
        DatabaseMeta compDatabaseMeta = this.pipelineMeta.findDatabase(this.input.getCompareConnection(), this.variables);
        this.wCompareDB = this.addConnectionLine(wComparisonComp, null, compDatabaseMeta, lsMod, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareDB.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareDB.Tooltip", (String[])new String[0]));
        this.wCompareDB.addSelectionListener((SelectionListener)lsSelection);
        lastControl = this.wCompareDB;
        this.wCompareSchema = new LabelCombo(wComparisonComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareSchemaField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareSchemaField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareSchema);
        FormData fdCompareSchema = new FormData();
        fdCompareSchema.left = new FormAttachment(0, 0);
        fdCompareSchema.top = new FormAttachment(lastControl, margin);
        fdCompareSchema.right = new FormAttachment(100, 0);
        this.wCompareSchema.setLayoutData((Object)fdCompareSchema);
        lastControl = this.wCompareSchema;
        this.wCompareTable = new LabelCombo(wComparisonComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareTableField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareTableField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareTable);
        FormData fdCompareTable = new FormData();
        fdCompareTable.left = new FormAttachment(0, 0);
        fdCompareTable.top = new FormAttachment((Control)lastControl, margin);
        fdCompareTable.right = new FormAttachment(100, 0);
        this.wCompareTable.setLayoutData((Object)fdCompareTable);
        FormData fdComparisonComp = new FormData();
        fdComparisonComp.left = new FormAttachment(0, 0);
        fdComparisonComp.top = new FormAttachment(0, 0);
        fdComparisonComp.right = new FormAttachment(100, 0);
        fdComparisonComp.bottom = new FormAttachment(100, 0);
        wComparisonComp.setLayoutData((Object)fdComparisonComp);
        wComparisonComp.layout();
        wComparisonTab.setControl((Control)wComparisonComp);
        CTabItem wOtherFieldsTab = new CTabItem(wTabFolder, 0);
        wOtherFieldsTab.setText(BaseMessages.getString(PKG, (String)"TableComparisonDialog.OtherFieldsTab.TabTitle", (String[])new String[0]));
        FormLayout otherFieldsLayout = new FormLayout();
        otherFieldsLayout.marginWidth = 3;
        otherFieldsLayout.marginHeight = 3;
        Composite wOtherFieldsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wOtherFieldsComp);
        wOtherFieldsComp.setLayout((Layout)otherFieldsLayout);
        this.wKeyFields = new LabelCombo(wOtherFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyFieldsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyFieldsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyFields);
        FormData fdKeyFields = new FormData();
        fdKeyFields.left = new FormAttachment(0, 0);
        fdKeyFields.top = new FormAttachment(0, margin);
        fdKeyFields.right = new FormAttachment(100, 0);
        this.wKeyFields.setLayoutData((Object)fdKeyFields);
        lastControl = this.wKeyFields;
        this.wExcludeFields = new LabelCombo(wOtherFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.ExcludeFieldsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ExcludeFieldsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExcludeFields);
        FormData fdExcludeFields = new FormData();
        fdExcludeFields.left = new FormAttachment(0, 0);
        fdExcludeFields.top = new FormAttachment((Control)lastControl, margin);
        fdExcludeFields.right = new FormAttachment(100, 0);
        this.wExcludeFields.setLayoutData((Object)fdExcludeFields);
        lastControl = this.wExcludeFields;
        this.wKeyDesc = new LabelCombo(wOtherFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyDescField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyDescField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyDesc);
        FormData fdKeyDesc = new FormData();
        fdKeyDesc.left = new FormAttachment(0, 0);
        fdKeyDesc.top = new FormAttachment((Control)lastControl, margin * 3);
        fdKeyDesc.right = new FormAttachment(100, 0);
        this.wKeyDesc.setLayoutData((Object)fdKeyDesc);
        lastControl = this.wKeyDesc;
        this.wReferenceValue = new LabelCombo(wOtherFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceValue);
        FormData fdReferenceValue = new FormData();
        fdReferenceValue.left = new FormAttachment(0, 0);
        fdReferenceValue.top = new FormAttachment((Control)lastControl, margin);
        fdReferenceValue.right = new FormAttachment(100, 0);
        this.wReferenceValue.setLayoutData((Object)fdReferenceValue);
        lastControl = this.wReferenceValue;
        this.wCompareValue = new LabelCombo(wOtherFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareValue);
        FormData fdCompareValue = new FormData();
        fdCompareValue.left = new FormAttachment(0, 0);
        fdCompareValue.top = new FormAttachment((Control)lastControl, margin);
        fdCompareValue.right = new FormAttachment(100, 0);
        this.wCompareValue.setLayoutData((Object)fdCompareValue);
        FormData fdOtherFieldsComp = new FormData();
        fdOtherFieldsComp.left = new FormAttachment(0, 0);
        fdOtherFieldsComp.top = new FormAttachment(0, 0);
        fdOtherFieldsComp.right = new FormAttachment(100, 0);
        fdOtherFieldsComp.bottom = new FormAttachment(100, 0);
        wOtherFieldsComp.setLayoutData((Object)fdOtherFieldsComp);
        wOtherFieldsComp.layout();
        wOtherFieldsTab.setControl((Control)wOtherFieldsComp);
        CTabItem wAdditionalFieldsTab = new CTabItem(wTabFolder, 0);
        wAdditionalFieldsTab.setText(BaseMessages.getString(PKG, (String)"TableComparisonDialog.AdditionalFieldsTab.TabTitle", (String[])new String[0]));
        FormLayout additionalFieldsLayout = new FormLayout();
        additionalFieldsLayout.marginWidth = 3;
        additionalFieldsLayout.marginHeight = 3;
        Composite wAdditionalFieldsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wAdditionalFieldsComp);
        wAdditionalFieldsComp.setLayout((Layout)additionalFieldsLayout);
        this.wNrErrors = new LabelText(wAdditionalFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrors);
        FormData fdNrErrors = new FormData();
        fdNrErrors.left = new FormAttachment(0, 0);
        fdNrErrors.top = new FormAttachment(0, margin * 3);
        fdNrErrors.right = new FormAttachment(100, 0);
        this.wNrErrors.setLayoutData((Object)fdNrErrors);
        lastControl = this.wNrErrors;
        this.wNrRecordsReference = new LabelText(wAdditionalFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsReferenceField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsReferenceField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrRecordsReference);
        FormData fdNrRecordsReference = new FormData();
        fdNrRecordsReference.left = new FormAttachment(0, 0);
        fdNrRecordsReference.top = new FormAttachment((Control)lastControl, margin);
        fdNrRecordsReference.right = new FormAttachment(100, 0);
        this.wNrRecordsReference.setLayoutData((Object)fdNrRecordsReference);
        lastControl = this.wNrRecordsReference;
        this.wNrRecordsCompare = new LabelText(wAdditionalFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsCompareField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsCompareField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrRecordsCompare);
        FormData fdNrRecordsCompare = new FormData();
        fdNrRecordsCompare.left = new FormAttachment(0, 0);
        fdNrRecordsCompare.top = new FormAttachment((Control)lastControl, margin);
        fdNrRecordsCompare.right = new FormAttachment(100, 0);
        this.wNrRecordsCompare.setLayoutData((Object)fdNrRecordsCompare);
        lastControl = this.wNrRecordsCompare;
        this.wNrErrorsLeftJoin = new LabelText(wAdditionalFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsLeftJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsLeftJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsLeftJoin);
        FormData fdNrErrorsLeftJoin = new FormData();
        fdNrErrorsLeftJoin.left = new FormAttachment(0, 0);
        fdNrErrorsLeftJoin.top = new FormAttachment((Control)lastControl, margin);
        fdNrErrorsLeftJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsLeftJoin.setLayoutData((Object)fdNrErrorsLeftJoin);
        lastControl = this.wNrErrorsLeftJoin;
        this.wNrErrorsInnerJoin = new LabelText(wAdditionalFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsInnerJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsInnerJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsInnerJoin);
        FormData fdNrErrorsInnerJoin = new FormData();
        fdNrErrorsInnerJoin.left = new FormAttachment(0, 0);
        fdNrErrorsInnerJoin.top = new FormAttachment((Control)lastControl, margin);
        fdNrErrorsInnerJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsInnerJoin.setLayoutData((Object)fdNrErrorsInnerJoin);
        lastControl = this.wNrErrorsInnerJoin;
        this.wNrErrorsRightJoin = new LabelText(wAdditionalFieldsComp, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsRightJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsRightJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsRightJoin);
        FormData fdNrErrorsRightJoin = new FormData();
        fdNrErrorsRightJoin.left = new FormAttachment(0, 0);
        fdNrErrorsRightJoin.top = new FormAttachment((Control)lastControl, margin);
        fdNrErrorsRightJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsRightJoin.setLayoutData((Object)fdNrErrorsRightJoin);
        lastControl = this.wNrErrorsRightJoin;
        FormData fdAdditionalFieldsComp = new FormData();
        fdAdditionalFieldsComp.left = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.top = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.right = new FormAttachment(100, 0);
        fdAdditionalFieldsComp.bottom = new FormAttachment(100, 0);
        wAdditionalFieldsComp.setLayoutData((Object)fdAdditionalFieldsComp);
        wAdditionalFieldsComp.layout();
        wAdditionalFieldsTab.setControl((Control)wAdditionalFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        FormData fdSc = new FormData();
        fdSc.left = new FormAttachment(0, 0);
        fdSc.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSc.right = new FormAttachment(100, 0);
        fdSc.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        sc.setLayoutData((Object)fdSc);
        sc.setContent((Control)wTabFolder);
        wTabFolder.setSelection(0);
        this.getData();
        this.input.setChanged(this.changed);
        sc.setMinSize(wTabFolder.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                try {
                    TableCompareDialog.this.prevFields = TableCompareDialog.this.pipelineMeta.getPrevTransformFields(TableCompareDialog.this.variables, TableCompareDialog.this.transformName);
                }
                catch (HopException e) {
                    String msg = BaseMessages.getString(PKG, (String)"TableCompareDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                    TableCompareDialog.this.log.logError(this.toString(), new Object[]{msg});
                }
                Object[] prevTransformFieldNames = TableCompareDialog.this.prevFields.getFieldNames();
                if (prevTransformFieldNames != null) {
                    Arrays.sort(prevTransformFieldNames);
                    TableCompareDialog.this.wReferenceSchema.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wReferenceTable.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wCompareSchema.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wCompareTable.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wKeyFields.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wExcludeFields.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wKeyDesc.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wReferenceValue.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wCompareValue.setItems((String[])prevTransformFieldNames);
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        this.wReferenceDB.setText(this.input.getReferenceConnection() != null ? this.input.getReferenceConnection() : "");
        this.wReferenceSchema.setText(Const.NVL((String)this.input.getReferenceSchemaField(), (String)""));
        this.wReferenceTable.setText(Const.NVL((String)this.input.getReferenceTableField(), (String)""));
        this.wCompareDB.setText(this.input.getCompareConnection() != null ? this.input.getCompareConnection() : "");
        this.wCompareSchema.setText(Const.NVL((String)this.input.getCompareSchemaField(), (String)""));
        this.wCompareTable.setText(Const.NVL((String)this.input.getCompareTableField(), (String)""));
        this.wKeyFields.setText(Const.NVL((String)this.input.getKeyFieldsField(), (String)""));
        this.wExcludeFields.setText(Const.NVL((String)this.input.getExcludeFieldsField(), (String)""));
        this.wNrErrors.setText(Const.NVL((String)this.input.getNrErrorsField(), (String)""));
        this.wNrRecordsReference.setText(Const.NVL((String)this.input.getNrRecordsReferenceField(), (String)""));
        this.wNrRecordsCompare.setText(Const.NVL((String)this.input.getNrRecordsCompareField(), (String)""));
        this.wNrErrorsLeftJoin.setText(Const.NVL((String)this.input.getNrErrorsLeftJoinField(), (String)""));
        this.wNrErrorsInnerJoin.setText(Const.NVL((String)this.input.getNrErrorsInnerJoinField(), (String)""));
        this.wNrErrorsRightJoin.setText(Const.NVL((String)this.input.getNrErrorsRightJoinField(), (String)""));
        this.wKeyDesc.setText(Const.NVL((String)this.input.getKeyDescriptionField(), (String)""));
        this.wReferenceValue.setText(Const.NVL((String)this.input.getValueReferenceField(), (String)""));
        this.wCompareValue.setText(Const.NVL((String)this.input.getValueCompareField(), (String)""));
        this.setComboValues();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        DatabaseMeta compDatabaseMeta;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setReferenceConnection(this.wReferenceDB.getText());
        this.input.setReferenceSchemaField(this.wReferenceSchema.getText());
        this.input.setReferenceTableField(this.wReferenceTable.getText());
        this.input.setCompareConnection(this.wCompareDB.getText());
        this.input.setCompareSchemaField(this.wCompareSchema.getText());
        this.input.setCompareTableField(this.wCompareTable.getText());
        this.input.setKeyFieldsField(this.wKeyFields.getText());
        this.input.setExcludeFieldsField(this.wExcludeFields.getText());
        this.input.setNrErrorsField(this.wNrErrors.getText());
        this.input.setNrRecordsReferenceField(this.wNrRecordsReference.getText());
        this.input.setNrRecordsCompareField(this.wNrRecordsCompare.getText());
        this.input.setNrErrorsLeftJoinField(this.wNrErrorsLeftJoin.getText());
        this.input.setNrErrorsInnerJoinField(this.wNrErrorsInnerJoin.getText());
        this.input.setNrErrorsRightJoinField(this.wNrErrorsRightJoin.getText());
        this.input.setKeyDescriptionField(this.wKeyDesc.getText());
        this.input.setValueReferenceField(this.wReferenceValue.getText());
        this.input.setValueCompareField(this.wCompareValue.getText());
        DatabaseMeta refDatabaseMeta = this.pipelineMeta.findDatabase(this.input.getReferenceConnection(), this.variables);
        if (refDatabaseMeta == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableCompareDialog.InvalidConnection.ReferenceConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.InvalidConnection.ReferenceConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        if ((compDatabaseMeta = this.pipelineMeta.findDatabase(this.input.getCompareConnection(), this.variables)) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableCompareDialog.InvalidConnection.ComparisonConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.InvalidConnection.ComparisonConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }
}

