/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_BigQueryIO_TypedRead<T>
extends BigQueryIO.TypedRead<T> {
    private final @Nullable ValueProvider<String> jsonTableRef;
    private final @Nullable ValueProvider<String> query;
    private final boolean validate;
    private final @Nullable Boolean flattenResults;
    private final @Nullable Boolean useLegacySql;
    private final Boolean withTemplateCompatibility;
    private final BigQueryServices bigQueryServices;
    private final SerializableFunction<SchemaAndRecord, T> parseFn;
    private final @Nullable BigQueryIO.TypedRead.QueryPriority queryPriority;
    private final @Nullable String queryLocation;
    private final @Nullable String queryTempDataset;
    private final BigQueryIO.TypedRead.Method method;
    private final DataFormat format;
    private final @Nullable ValueProvider<List<String>> selectedFields;
    private final @Nullable ValueProvider<String> rowRestriction;
    private final @Nullable Coder<T> coder;
    private final @Nullable String kmsKey;
    private final @Nullable TypeDescriptor<T> typeDescriptor;
    private final @Nullable BigQueryIO.TypedRead.ToBeamRowFunction<T> toBeamRowFn;
    private final @Nullable BigQueryIO.TypedRead.FromBeamRowFunction<T> fromBeamRowFn;
    private final Boolean useAvroLogicalTypes;
    private final boolean projectionPushdownApplied;

    private AutoValue_BigQueryIO_TypedRead(@Nullable ValueProvider<String> jsonTableRef, @Nullable ValueProvider<String> query, boolean validate, @Nullable Boolean flattenResults, @Nullable Boolean useLegacySql, Boolean withTemplateCompatibility, BigQueryServices bigQueryServices, SerializableFunction<SchemaAndRecord, T> parseFn, @Nullable BigQueryIO.TypedRead.QueryPriority queryPriority, @Nullable String queryLocation, @Nullable String queryTempDataset, BigQueryIO.TypedRead.Method method, DataFormat format, @Nullable ValueProvider<List<String>> selectedFields, @Nullable ValueProvider<String> rowRestriction, @Nullable Coder<T> coder, @Nullable String kmsKey, @Nullable TypeDescriptor<T> typeDescriptor, @Nullable BigQueryIO.TypedRead.ToBeamRowFunction<T> toBeamRowFn, @Nullable BigQueryIO.TypedRead.FromBeamRowFunction<T> fromBeamRowFn, Boolean useAvroLogicalTypes, boolean projectionPushdownApplied) {
        this.jsonTableRef = jsonTableRef;
        this.query = query;
        this.validate = validate;
        this.flattenResults = flattenResults;
        this.useLegacySql = useLegacySql;
        this.withTemplateCompatibility = withTemplateCompatibility;
        this.bigQueryServices = bigQueryServices;
        this.parseFn = parseFn;
        this.queryPriority = queryPriority;
        this.queryLocation = queryLocation;
        this.queryTempDataset = queryTempDataset;
        this.method = method;
        this.format = format;
        this.selectedFields = selectedFields;
        this.rowRestriction = rowRestriction;
        this.coder = coder;
        this.kmsKey = kmsKey;
        this.typeDescriptor = typeDescriptor;
        this.toBeamRowFn = toBeamRowFn;
        this.fromBeamRowFn = fromBeamRowFn;
        this.useAvroLogicalTypes = useAvroLogicalTypes;
        this.projectionPushdownApplied = projectionPushdownApplied;
    }

    @Override
    @Nullable ValueProvider<String> getJsonTableRef() {
        return this.jsonTableRef;
    }

    @Override
    @Nullable ValueProvider<String> getQuery() {
        return this.query;
    }

    @Override
    boolean getValidate() {
        return this.validate;
    }

    @Override
    @Nullable Boolean getFlattenResults() {
        return this.flattenResults;
    }

    @Override
    @Nullable Boolean getUseLegacySql() {
        return this.useLegacySql;
    }

    @Override
    Boolean getWithTemplateCompatibility() {
        return this.withTemplateCompatibility;
    }

    @Override
    BigQueryServices getBigQueryServices() {
        return this.bigQueryServices;
    }

    @Override
    SerializableFunction<SchemaAndRecord, T> getParseFn() {
        return this.parseFn;
    }

    @Override
    @Nullable BigQueryIO.TypedRead.QueryPriority getQueryPriority() {
        return this.queryPriority;
    }

    @Override
    @Nullable String getQueryLocation() {
        return this.queryLocation;
    }

    @Override
    @Nullable String getQueryTempDataset() {
        return this.queryTempDataset;
    }

    @Override
    BigQueryIO.TypedRead.Method getMethod() {
        return this.method;
    }

    @Override
    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    DataFormat getFormat() {
        return this.format;
    }

    @Override
    @Nullable ValueProvider<List<String>> getSelectedFields() {
        return this.selectedFields;
    }

    @Override
    @Nullable ValueProvider<String> getRowRestriction() {
        return this.rowRestriction;
    }

    @Override
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    @Nullable String getKmsKey() {
        return this.kmsKey;
    }

    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    @Nullable TypeDescriptor<T> getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    @Nullable BigQueryIO.TypedRead.ToBeamRowFunction<T> getToBeamRowFn() {
        return this.toBeamRowFn;
    }

    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    @Nullable BigQueryIO.TypedRead.FromBeamRowFunction<T> getFromBeamRowFn() {
        return this.fromBeamRowFn;
    }

    @Override
    Boolean getUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    @Override
    boolean getProjectionPushdownApplied() {
        return this.projectionPushdownApplied;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryIO.TypedRead) {
            BigQueryIO.TypedRead that = (BigQueryIO.TypedRead)((Object)o);
            return (this.jsonTableRef == null ? that.getJsonTableRef() == null : this.jsonTableRef.equals(that.getJsonTableRef())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && this.validate == that.getValidate() && (this.flattenResults == null ? that.getFlattenResults() == null : this.flattenResults.equals(that.getFlattenResults())) && (this.useLegacySql == null ? that.getUseLegacySql() == null : this.useLegacySql.equals(that.getUseLegacySql())) && this.withTemplateCompatibility.equals(that.getWithTemplateCompatibility()) && this.bigQueryServices.equals(that.getBigQueryServices()) && this.parseFn.equals(that.getParseFn()) && (this.queryPriority == null ? that.getQueryPriority() == null : this.queryPriority.equals((Object)that.getQueryPriority())) && (this.queryLocation == null ? that.getQueryLocation() == null : this.queryLocation.equals(that.getQueryLocation())) && (this.queryTempDataset == null ? that.getQueryTempDataset() == null : this.queryTempDataset.equals(that.getQueryTempDataset())) && this.method.equals((Object)that.getMethod()) && this.format.equals((Object)that.getFormat()) && (this.selectedFields == null ? that.getSelectedFields() == null : this.selectedFields.equals(that.getSelectedFields())) && (this.rowRestriction == null ? that.getRowRestriction() == null : this.rowRestriction.equals(that.getRowRestriction())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && (this.kmsKey == null ? that.getKmsKey() == null : this.kmsKey.equals(that.getKmsKey())) && (this.typeDescriptor == null ? that.getTypeDescriptor() == null : this.typeDescriptor.equals(that.getTypeDescriptor())) && (this.toBeamRowFn == null ? that.getToBeamRowFn() == null : this.toBeamRowFn.equals(that.getToBeamRowFn())) && (this.fromBeamRowFn == null ? that.getFromBeamRowFn() == null : this.fromBeamRowFn.equals(that.getFromBeamRowFn())) && this.useAvroLogicalTypes.equals(that.getUseAvroLogicalTypes()) && this.projectionPushdownApplied == that.getProjectionPushdownApplied();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jsonTableRef == null ? 0 : this.jsonTableRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.validate ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.flattenResults == null ? 0 : this.flattenResults.hashCode();
        h$ *= 1000003;
        h$ ^= this.useLegacySql == null ? 0 : this.useLegacySql.hashCode();
        h$ *= 1000003;
        h$ ^= this.withTemplateCompatibility.hashCode();
        h$ *= 1000003;
        h$ ^= this.bigQueryServices.hashCode();
        h$ *= 1000003;
        h$ ^= this.parseFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryPriority == null ? 0 : this.queryPriority.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryLocation == null ? 0 : this.queryLocation.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryTempDataset == null ? 0 : this.queryTempDataset.hashCode();
        h$ *= 1000003;
        h$ ^= this.method.hashCode();
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.selectedFields == null ? 0 : this.selectedFields.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowRestriction == null ? 0 : this.rowRestriction.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.kmsKey == null ? 0 : this.kmsKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.typeDescriptor == null ? 0 : this.typeDescriptor.hashCode();
        h$ *= 1000003;
        h$ ^= this.toBeamRowFn == null ? 0 : this.toBeamRowFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.fromBeamRowFn == null ? 0 : this.fromBeamRowFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.useAvroLogicalTypes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.projectionPushdownApplied ? 1231 : 1237;
    }

    @Override
    BigQueryIO.TypedRead.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends BigQueryIO.TypedRead.Builder<T> {
        private @Nullable ValueProvider<String> jsonTableRef;
        private @Nullable ValueProvider<String> query;
        private Boolean validate;
        private @Nullable Boolean flattenResults;
        private @Nullable Boolean useLegacySql;
        private Boolean withTemplateCompatibility;
        private BigQueryServices bigQueryServices;
        private SerializableFunction<SchemaAndRecord, T> parseFn;
        private @Nullable BigQueryIO.TypedRead.QueryPriority queryPriority;
        private @Nullable String queryLocation;
        private @Nullable String queryTempDataset;
        private BigQueryIO.TypedRead.Method method;
        private DataFormat format;
        private @Nullable ValueProvider<List<String>> selectedFields;
        private @Nullable ValueProvider<String> rowRestriction;
        private @Nullable Coder<T> coder;
        private @Nullable String kmsKey;
        private @Nullable TypeDescriptor<T> typeDescriptor;
        private @Nullable BigQueryIO.TypedRead.ToBeamRowFunction<T> toBeamRowFn;
        private @Nullable BigQueryIO.TypedRead.FromBeamRowFunction<T> fromBeamRowFn;
        private Boolean useAvroLogicalTypes;
        private Boolean projectionPushdownApplied;

        Builder() {
        }

        private Builder(BigQueryIO.TypedRead<T> source) {
            this.jsonTableRef = source.getJsonTableRef();
            this.query = source.getQuery();
            this.validate = source.getValidate();
            this.flattenResults = source.getFlattenResults();
            this.useLegacySql = source.getUseLegacySql();
            this.withTemplateCompatibility = source.getWithTemplateCompatibility();
            this.bigQueryServices = source.getBigQueryServices();
            this.parseFn = source.getParseFn();
            this.queryPriority = source.getQueryPriority();
            this.queryLocation = source.getQueryLocation();
            this.queryTempDataset = source.getQueryTempDataset();
            this.method = source.getMethod();
            this.format = source.getFormat();
            this.selectedFields = source.getSelectedFields();
            this.rowRestriction = source.getRowRestriction();
            this.coder = source.getCoder();
            this.kmsKey = source.getKmsKey();
            this.typeDescriptor = source.getTypeDescriptor();
            this.toBeamRowFn = source.getToBeamRowFn();
            this.fromBeamRowFn = source.getFromBeamRowFn();
            this.useAvroLogicalTypes = source.getUseAvroLogicalTypes();
            this.projectionPushdownApplied = source.getProjectionPushdownApplied();
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setJsonTableRef(ValueProvider<String> jsonTableRef) {
            this.jsonTableRef = jsonTableRef;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setQuery(ValueProvider<String> query) {
            this.query = query;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setFlattenResults(Boolean flattenResults) {
            this.flattenResults = flattenResults;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setUseLegacySql(Boolean useLegacySql) {
            this.useLegacySql = useLegacySql;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setWithTemplateCompatibility(Boolean withTemplateCompatibility) {
            if (withTemplateCompatibility == null) {
                throw new NullPointerException("Null withTemplateCompatibility");
            }
            this.withTemplateCompatibility = withTemplateCompatibility;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setBigQueryServices(BigQueryServices bigQueryServices) {
            if (bigQueryServices == null) {
                throw new NullPointerException("Null bigQueryServices");
            }
            this.bigQueryServices = bigQueryServices;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setParseFn(SerializableFunction<SchemaAndRecord, T> parseFn) {
            if (parseFn == null) {
                throw new NullPointerException("Null parseFn");
            }
            this.parseFn = parseFn;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setQueryPriority(BigQueryIO.TypedRead.QueryPriority queryPriority) {
            this.queryPriority = queryPriority;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setQueryLocation(String queryLocation) {
            this.queryLocation = queryLocation;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setQueryTempDataset(String queryTempDataset) {
            this.queryTempDataset = queryTempDataset;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setMethod(BigQueryIO.TypedRead.Method method) {
            if (method == null) {
                throw new NullPointerException("Null method");
            }
            this.method = method;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setFormat(DataFormat format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setSelectedFields(ValueProvider<List<String>> selectedFields) {
            this.selectedFields = selectedFields;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setRowRestriction(ValueProvider<String> rowRestriction) {
            this.rowRestriction = rowRestriction;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setTypeDescriptor(TypeDescriptor<T> typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setToBeamRowFn(BigQueryIO.TypedRead.ToBeamRowFunction<T> toBeamRowFn) {
            this.toBeamRowFn = toBeamRowFn;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setFromBeamRowFn(BigQueryIO.TypedRead.FromBeamRowFunction<T> fromBeamRowFn) {
            this.fromBeamRowFn = fromBeamRowFn;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setUseAvroLogicalTypes(Boolean useAvroLogicalTypes) {
            if (useAvroLogicalTypes == null) {
                throw new NullPointerException("Null useAvroLogicalTypes");
            }
            this.useAvroLogicalTypes = useAvroLogicalTypes;
            return this;
        }

        @Override
        BigQueryIO.TypedRead.Builder<T> setProjectionPushdownApplied(boolean projectionPushdownApplied) {
            this.projectionPushdownApplied = projectionPushdownApplied;
            return this;
        }

        @Override
        BigQueryIO.TypedRead<T> build() {
            if (this.validate == null || this.withTemplateCompatibility == null || this.bigQueryServices == null || this.parseFn == null || this.method == null || this.format == null || this.useAvroLogicalTypes == null || this.projectionPushdownApplied == null) {
                StringBuilder missing = new StringBuilder();
                if (this.validate == null) {
                    missing.append(" validate");
                }
                if (this.withTemplateCompatibility == null) {
                    missing.append(" withTemplateCompatibility");
                }
                if (this.bigQueryServices == null) {
                    missing.append(" bigQueryServices");
                }
                if (this.parseFn == null) {
                    missing.append(" parseFn");
                }
                if (this.method == null) {
                    missing.append(" method");
                }
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.useAvroLogicalTypes == null) {
                    missing.append(" useAvroLogicalTypes");
                }
                if (this.projectionPushdownApplied == null) {
                    missing.append(" projectionPushdownApplied");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryIO_TypedRead(this.jsonTableRef, this.query, this.validate, this.flattenResults, this.useLegacySql, this.withTemplateCompatibility, this.bigQueryServices, this.parseFn, this.queryPriority, this.queryLocation, this.queryTempDataset, this.method, this.format, this.selectedFields, this.rowRestriction, this.coder, this.kmsKey, this.typeDescriptor, this.toBeamRowFn, this.fromBeamRowFn, this.useAvroLogicalTypes, this.projectionPushdownApplied);
        }
    }
}

