/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transform.common;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.pipeline.transform.common.IGetFieldsCapableTransformDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class GetFieldsSampleDataDialog
extends EnterNumberDialog {
    private static final Class<?> PKG = GetFieldsSampleDataDialog.class;
    private static final int SAMPLE_SIZE = 100;
    private static final int SHELL_WIDTH = 700;
    private final IGetFieldsCapableTransformDialog parentDialog;
    private final boolean reloadAllFields;

    public GetFieldsSampleDataDialog(Shell parentShell, IGetFieldsCapableTransformDialog parentDialog, boolean reloadAllFields) {
        super(parentShell, 100, BaseMessages.getString(PKG, (String)"GetFieldsSampleSizeDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFieldsSampleSizeDialog.Message", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFieldsSampleSizeDialog.ShowSample.Message", (String[])new String[0]), 700);
        this.parentDialog = parentDialog;
        this.reloadAllFields = reloadAllFields;
    }

    @Override
    protected void ok() {
        try {
            this.samples = Integer.parseInt(this.wNumber.getText());
            this.handleOk(this.samples);
            this.dispose();
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.getParent(), 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Dialog.Error.EnterInteger", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Dialog.Error.Header", (String[])new String[0]));
            mb.open();
            this.wNumber.selectAll();
        }
    }

    protected void handleOk(int samples) {
        if (samples >= 0) {
            String message = this.parentDialog.loadFields(this.parentDialog.getPopulatedMeta(), samples, this.reloadAllFields);
            if (this.wCheckbox != null && this.wCheckbox.getSelection()) {
                if (StringUtils.isNotBlank((String)message)) {
                    EnterTextDialog etd = new EnterTextDialog(this.parentDialog.getShell(), BaseMessages.getString(PKG, (String)"GetFieldsSampleDataDialog.ScanResults.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFieldsSampleDataDialog.ScanResults.DialogMessage", (String[])new String[0]), message, true);
                    etd.setReadOnly();
                    etd.setModal();
                    etd.open();
                } else {
                    MessageBox box = new MessageBox(this.shell, 33);
                    box.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString(PKG, (String)"GetFieldsSampleDataDialog.ScanResults.Error.Message", (String[])new String[0]));
                    box.open();
                }
            }
        }
    }
}

