/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.spark.api.python.Converter;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00013Q!\u0002\u0004\u0001\rAA\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006Y\u0001!\t!\f\u0005\u0006a\u0001!I!\r\u0005\u0006y\u0001!\t%\u0010\u0002\u0018/JLG/\u00192mKR{'*\u0019<b\u0007>tg/\u001a:uKJT!a\u0002\u0005\u0002\rALH\u000f[8o\u0015\tI!\"A\u0002ba&T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0003\u00193mYR\"\u0001\u0004\n\u0005i1!!C\"p]Z,'\u000f^3s!\t\u0011B$\u0003\u0002\u001e'\t\u0019\u0011I\\=\u0002\t\r|gNZ\u0002\u0001!\r\tCEJ\u0007\u0002E)\u00111EC\u0001\nEJ|\u0017\rZ2bgRL!!\n\u0012\u0003\u0013\t\u0013x.\u00193dCN$\bCA\u0014+\u001b\u0005A#BA\u0015\u000b\u0003\u0011)H/\u001b7\n\u0005-B#!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDC\u0001\u00180!\tA\u0002\u0001C\u0003\u001f\u0005\u0001\u0007\u0001%A\bd_:4XM\u001d;Xe&$\u0018M\u00197f)\tY\"\u0007C\u00034\u0007\u0001\u0007A'\u0001\u0005xe&$\u0018M\u00197f!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0002j_*\u0011\u0011\bD\u0001\u0007Q\u0006$wn\u001c9\n\u0005m2$\u0001C,sSR\f'\r\\3\u0002\u000f\r|gN^3siR\u00111D\u0010\u0005\u0006\u007f\u0011\u0001\raG\u0001\u0004_\nT\u0007")
public class WritableToJavaConverter
implements Converter<Object, Object> {
    private final Broadcast<SerializableConfiguration> conf;

    private Object convertWritable(Writable writable) {
        HashMap hashMap;
        Writable writable2 = writable;
        if (writable2 instanceof IntWritable) {
            IntWritable intWritable = (IntWritable)writable2;
            hashMap = BoxesRunTime.boxToInteger((int)intWritable.get());
        } else if (writable2 instanceof DoubleWritable) {
            DoubleWritable doubleWritable = (DoubleWritable)writable2;
            hashMap = BoxesRunTime.boxToDouble((double)doubleWritable.get());
        } else if (writable2 instanceof LongWritable) {
            LongWritable longWritable = (LongWritable)writable2;
            hashMap = BoxesRunTime.boxToLong((long)longWritable.get());
        } else if (writable2 instanceof ShortWritable) {
            ShortWritable shortWritable = (ShortWritable)writable2;
            hashMap = BoxesRunTime.boxToShort((short)shortWritable.get());
        } else if (writable2 instanceof FloatWritable) {
            FloatWritable floatWritable = (FloatWritable)writable2;
            hashMap = BoxesRunTime.boxToFloat((float)floatWritable.get());
        } else if (writable2 instanceof Text) {
            Text text = (Text)writable2;
            hashMap = text.toString();
        } else if (writable2 instanceof BooleanWritable) {
            BooleanWritable booleanWritable = (BooleanWritable)writable2;
            hashMap = BoxesRunTime.boxToBoolean((boolean)booleanWritable.get());
        } else if (writable2 instanceof ByteWritable) {
            ByteWritable byteWritable = (ByteWritable)writable2;
            hashMap = BoxesRunTime.boxToByte((byte)byteWritable.get());
        } else if (writable2 instanceof BytesWritable) {
            BytesWritable bytesWritable = (BytesWritable)writable2;
            byte[] bytes = new byte[bytesWritable.getLength()];
            System.arraycopy(bytesWritable.getBytes(), 0, bytes, 0, bytesWritable.getLength());
            hashMap = (HashMap)bytes;
        } else if (writable2 instanceof NullWritable) {
            hashMap = null;
        } else if (writable2 instanceof ArrayWritable) {
            ArrayWritable arrayWritable = (ArrayWritable)writable2;
            hashMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayWritable.get())).map((Function1 & Serializable & scala.Serializable)x$1 -> this.convertWritable((Writable)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        } else if (writable2 instanceof MapWritable) {
            MapWritable mapWritable = (MapWritable)writable2;
            HashMap map = new HashMap();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)mapWritable).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Writable k = (Writable)tuple2._1();
                Writable v = (Writable)tuple2._2();
                Object object = map.put(this.convertWritable(k), this.convertWritable(v));
                return object;
            });
            hashMap = map;
        } else if (writable2 != null) {
            Writable writable3 = writable2;
            hashMap = WritableUtils.clone((Writable)writable3, (Configuration)this.conf.value().value());
        } else {
            hashMap = writable2;
        }
        return hashMap;
    }

    @Override
    public Object convert(Object obj) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof Writable) {
            Writable writable = (Writable)object2;
            object = this.convertWritable(writable);
        } else {
            object = obj;
        }
        return object;
    }

    public WritableToJavaConverter(Broadcast<SerializableConfiguration> conf) {
        this.conf = conf;
    }
}

