/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.ScanNode;
import org.jetbrains.annotations.Nullable;

public class ScanStorageNode<Row>
extends ScanNode<Row> {
    @Nullable
    private final AtomicLong processedRowsCntr;

    public ScanStorageNode(String storageName, ExecutionContext<Row> ctx, RelDataType rowType, Iterable<Row> src, @Nullable Predicate<Row> filter, @Nullable Function<Row, Row> rowTransformer) {
        super(ctx, rowType, src, filter, rowTransformer);
        this.processedRowsCntr = this.context().ioTracker().processedRowsCounter("Scanned " + storageName);
    }

    public ScanStorageNode(String storageName, ExecutionContext<Row> ctx, RelDataType rowType, Iterable<Row> src) {
        this(storageName, ctx, rowType, src, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int processNextBatch() throws Exception {
        boolean trackingStarted = this.context().ioTracker().startTracking();
        try {
            int processed = super.processNextBatch();
            if (this.processedRowsCntr != null) {
                this.processedRowsCntr.addAndGet(processed);
            }
            int n = processed;
            return n;
        }
        finally {
            if (trackingStarted) {
                this.context().ioTracker().stopTracking();
            }
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.context().ioTracker().flush();
    }
}

