/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongFloatAssociativeContainer;
import com.carrotsearch.hppc.LongFloatHashMap;
import com.carrotsearch.hppc.LongFloatMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.comparators.LongComparator;
import com.carrotsearch.hppc.comparators.LongFloatComparator;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.LongFloatPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.LongFloatProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationLongFloatHashMap
implements LongFloatMap {
    public final LongFloatHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationLongFloatHashMap(LongFloatHashMap delegate, LongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationLongFloatHashMap(LongFloatHashMap delegate, LongFloatComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        long[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0L) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, LongComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            long[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final LongFloatComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final long[] keys;
            final float[] values;
            {
                this.keys = SortedIterationLongFloatHashMap.this.delegate.keys;
                this.values = SortedIterationLongFloatHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<LongFloatCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(LongContainer container) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(LongFloatPredicate predicate) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public <T extends LongFloatProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongFloatPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        long[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public LongCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public float get(long key) {
        return this.delegate.get(key);
    }

    @Override
    public float getOrDefault(long key, float defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public float put(long key, float value) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(LongFloatAssociativeContainer container) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends LongFloatCursor> iterable) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public float putOrAdd(long key, float putValue, float incrementValue) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public float addTo(long key, float additionValue) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public float remove(long key) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public int indexOf(long key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public float indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public float indexReplace(int index, float newValue) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, long key, float value) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public float indexRemove(int index) {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationLongFloatHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<LongFloatCursor> {
        private final LongFloatCursor cursor = new LongFloatCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected LongFloatCursor fetch() {
            if (this.index < SortedIterationLongFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationLongFloatHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationLongFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongFloatCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final SortedIterationLongFloatHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationLongFloatHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final SortedIterationLongFloatHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationLongFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (LongFloatCursor c : this.owner) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationLongFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected FloatCursor fetch() {
            if (this.index < SortedIterationLongFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationLongFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationLongFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationLongFloatHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

