/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.distributedlog.common.util.PermitManager;
import org.apache.distributedlog.zk.LimitedPermitManager;
import org.junit.Assert;
import org.junit.Test;

public class TestPermitManager {
    @Test(timeout=60000L)
    public void testUnlimitedPermitManager() {
        int i;
        int i2;
        PermitManager pm = PermitManager.UNLIMITED_PERMIT_MANAGER;
        ArrayList<PermitManager.Permit> permits = new ArrayList<PermitManager.Permit>();
        for (i2 = 0; i2 < 10; ++i2) {
            permits.add(pm.acquirePermit());
        }
        for (i2 = 0; i2 < 10; ++i2) {
            Assert.assertTrue((boolean)((PermitManager.Permit)permits.get(i2)).isAllowed());
            pm.releasePermit((PermitManager.Permit)permits.get(i2));
        }
        PermitManager.Permit permit = pm.acquirePermit();
        pm.disallowObtainPermits(permit);
        pm.releasePermit(permit);
        for (i = 0; i < 10; ++i) {
            permits.add(pm.acquirePermit());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)((PermitManager.Permit)permits.get(i)).isAllowed());
            pm.releasePermit((PermitManager.Permit)permits.get(i));
        }
    }

    @Test(timeout=60000L)
    public void testLimitedPermitManager() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        LimitedPermitManager pm = new LimitedPermitManager(1, 0, TimeUnit.SECONDS, executorService);
        PermitManager.Permit permit1 = pm.acquirePermit();
        PermitManager.Permit permit2 = pm.acquirePermit();
        Assert.assertTrue((boolean)permit1.isAllowed());
        Assert.assertFalse((boolean)permit2.isAllowed());
        pm.releasePermit(permit2);
        PermitManager.Permit permit3 = pm.acquirePermit();
        Assert.assertFalse((boolean)permit3.isAllowed());
        pm.releasePermit(permit3);
        pm.releasePermit(permit1);
        PermitManager.Permit permit4 = pm.acquirePermit();
        Assert.assertTrue((boolean)permit4.isAllowed());
        pm.releasePermit(permit4);
        LimitedPermitManager pm2 = new LimitedPermitManager(2, 0, TimeUnit.SECONDS, executorService);
        PermitManager.Permit permit5 = pm2.acquirePermit();
        PermitManager.Permit permit6 = pm2.acquirePermit();
        Assert.assertTrue((boolean)permit5.isAllowed());
        Assert.assertTrue((boolean)permit6.isAllowed());
        Assert.assertTrue((boolean)pm2.disallowObtainPermits(permit5));
        Assert.assertFalse((boolean)pm2.disallowObtainPermits(permit6));
        pm2.releasePermit(permit5);
        pm2.releasePermit(permit6);
        PermitManager.Permit permit7 = pm2.acquirePermit();
        Assert.assertFalse((boolean)permit7.isAllowed());
        pm2.releasePermit(permit7);
        pm2.allowObtainPermits();
        PermitManager.Permit permit8 = pm2.acquirePermit();
        Assert.assertTrue((boolean)permit8.isAllowed());
        pm2.releasePermit(permit2);
    }
}

