/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509TestContext;
import org.apache.zookeeper.test.ClientBase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.provider.Arguments;

public abstract class BaseX509ParameterizedTestCase
extends ZKTestCase {
    protected static final String KEY_NON_EMPTY_PASSWORD = "pa$$w0rd";
    protected static final String KEY_EMPTY_PASSWORD = "";
    protected static Map<Integer, X509TestContext> cachedTestContexts;
    protected static File tempDir;
    protected X509TestContext x509TestContext;

    public static Stream<Arguments> data() {
        ArrayList<Arguments> result = new ArrayList<Arguments>();
        int paramIndex = 0;
        for (X509KeyType caKeyType : X509KeyType.values()) {
            for (X509KeyType certKeyType : X509KeyType.values()) {
                for (String keyPassword : new String[]{KEY_EMPTY_PASSWORD, KEY_NON_EMPTY_PASSWORD}) {
                    result.add(Arguments.of((Object[])new Object[]{caKeyType, certKeyType, keyPassword, paramIndex++}));
                }
            }
        }
        return result.stream();
    }

    @BeforeAll
    public static void setUpBaseClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        cachedTestContexts = new HashMap<Integer, X509TestContext>();
        tempDir = ClientBase.createEmptyTestDir();
    }

    @AfterAll
    public static void cleanUpBaseClass() {
        Security.removeProvider("BC");
        cachedTestContexts.clear();
        cachedTestContexts = null;
        try {
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void init(Integer paramIndex, Supplier<X509TestContext> contextSupplier) {
        if (cachedTestContexts.containsKey(paramIndex)) {
            this.x509TestContext = cachedTestContexts.get(paramIndex);
        } else {
            this.x509TestContext = contextSupplier.get();
            cachedTestContexts.put(paramIndex, this.x509TestContext);
        }
    }

    protected void init(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(paramIndex, () -> {
            try {
                return X509TestContext.newBuilder().setTempDir(tempDir).setKeyStorePassword(keyPassword).setKeyStoreKeyType(certKeyType).setTrustStorePassword(keyPassword).setTrustStoreKeyType(caKeyType).build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

