/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.service;

import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.bookkeeper.stream.storage.api.metadata.RangeStoreService;
import org.apache.bookkeeper.stream.storage.api.service.RangeStoreServiceFactory;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.bookkeeper.stream.storage.impl.service.RangeStoreServiceImpl;
import org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;

public class RangeStoreServiceFactoryImpl
implements RangeStoreServiceFactory {
    private final StorageConfiguration storageConf;
    private final StorageContainerPlacementPolicy rangePlacementPolicy;
    private final SharedResourceManager.Resource<OrderedScheduler> schedulerResource;
    private final OrderedScheduler scheduler;
    private final MVCCStoreFactory storeFactory;
    private final StorageServerClientManager clientManager;

    public RangeStoreServiceFactoryImpl(StorageConfiguration storageConf, StorageContainerPlacementPolicy rangePlacementPolicy, SharedResourceManager.Resource<OrderedScheduler> schedulerResource, MVCCStoreFactory storeFactory, StorageServerClientManager clientManager) {
        this.storageConf = storageConf;
        this.rangePlacementPolicy = rangePlacementPolicy;
        this.schedulerResource = schedulerResource;
        this.scheduler = (OrderedScheduler)SharedResourceManager.shared().get(schedulerResource);
        this.storeFactory = storeFactory;
        this.clientManager = clientManager;
    }

    public RangeStoreService createService(long scId) {
        return new RangeStoreServiceImpl(scId, this.rangePlacementPolicy, this.scheduler, this.storeFactory, this.clientManager);
    }

    public void close() {
        SharedResourceManager.shared().release(this.schedulerResource, (Object)this.scheduler);
    }
}

