/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.HashMap;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class LearnerMetricsTest
extends QuorumPeerTestBase {
    private static final int SERVER_COUNT = 4;
    private final QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[4];
    private ZooKeeper zk_client;
    private static boolean bakAsyncSending;

    @BeforeAll
    public static void saveAsyncSendingFlag() {
        bakAsyncSending = Learner.getAsyncSending();
    }

    @AfterAll
    public static void resetAsyncSendingFlag() {
        Learner.setAsyncSending((boolean)bakAsyncSending);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLearnerMetricsTest(boolean asyncSending) throws Exception {
        Learner.setAsyncSending((boolean)asyncSending);
        ServerMetrics.getMetrics().resetAll();
        ClientBase.setupTestEnv();
        String path = "/zk-testLeanerMetrics";
        byte[] data = new byte[512];
        int[] clientPorts = new int[4];
        StringBuilder sb = new StringBuilder();
        int observer = 0;
        clientPorts[observer] = PortAssignment.unique();
        sb.append("server." + observer + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer\n");
        for (int i = 1; i < 4; ++i) {
            clientPorts[i] = PortAssignment.unique();
            sb.append("server." + i + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\n");
        }
        String quorumCfgSection = sb.toString();
        for (int i = 1; i < 4; ++i) {
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfgSection);
            this.mt[i].start();
        }
        HashMap<String, String> observerConfig = new HashMap<String, String>();
        observerConfig.put("peerType", "observer");
        this.mt[observer] = new QuorumPeerTestBase.MainThread(observer, clientPorts[observer], quorumCfgSection, observerConfig);
        this.mt[observer].start();
        this.zk_client = new ZooKeeper("127.0.0.1:" + clientPorts[observer], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        LearnerMetricsTest.waitForOne(this.zk_client, ZooKeeper.States.CONNECTED);
        this.zk_client.create("/zk-testLeanerMetrics", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LearnerMetricsTest.waitForMetric("learner_proposal_received_count", Is.is((Object)4L));
        LearnerMetricsTest.waitForMetric("cnt_proposal_latency", Is.is((Object)4L));
        LearnerMetricsTest.waitForMetric("min_proposal_latency", OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        LearnerMetricsTest.waitForMetric("cnt_proposal_ack_creation_latency", Is.is((Object)6L));
        LearnerMetricsTest.waitForMetric("min_proposal_ack_creation_latency", OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        LearnerMetricsTest.waitForMetric("learner_commit_received_count", Is.is((Object)6L));
        LearnerMetricsTest.waitForMetric("cnt_commit_propagation_latency", Is.is((Object)6L));
        LearnerMetricsTest.waitForMetric("min_commit_propagation_latency", OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.zk_client.close();
        for (int i = 0; i < 4; ++i) {
            this.mt[i].shutdown();
        }
    }
}

