/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.embedded;

import java.lang.management.ManagementFactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.server.ConnectionMXBean;
import org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.zookeeper.server.quorum.LocalPeerMXBean;
import org.apache.zookeeper.server.quorum.QuorumBean;
import org.apache.zookeeper.server.quorum.QuorumMXBean;
import org.apache.zookeeper.server.quorum.RemotePeerMXBean;

public final class ZookeeperServeInfo {
    private static final MBeanServer localServer = ManagementFactory.getPlatformMBeanServer();

    private ZookeeperServeInfo() {
    }

    public static ServerInfo getStatus() throws Exception {
        return ZookeeperServeInfo.getStatus("*");
    }

    public static ServerInfo getStatus(String beanName) throws Exception {
        ObjectName objectName;
        Set<ObjectInstance> first_level_beans;
        ServerInfo info = new ServerInfo();
        boolean standalonemode = false;
        if (StringUtils.isBlank((String)beanName)) {
            beanName = "*";
        }
        if ((first_level_beans = localServer.queryMBeans(objectName = new ObjectName("org.apache.ZooKeeperService:name0=" + beanName), null)).isEmpty()) {
            throw new IllegalStateException("No ZooKeeper server found in this JVM with name " + objectName);
        }
        String myName = "";
        for (ObjectInstance objectInstance : first_level_beans) {
            if (objectInstance.getClassName().equalsIgnoreCase(ZooKeeperServerBean.class.getName())) {
                standalonemode = true;
                info.leader = true;
                info.addPeer(new PeerInfo("local", "local", "STANDALONE", true));
                continue;
            }
            if (!objectInstance.getClassName().equalsIgnoreCase(QuorumBean.class.getName())) continue;
            standalonemode = false;
            try {
                QuorumMXBean quorum = MBeanServerInvocationHandler.newProxyInstance(localServer, objectInstance.getObjectName(), QuorumMXBean.class, false);
                myName = quorum.getName();
            }
            catch (UndeclaredThrowableException err) {
                if (err.getCause() instanceof InstanceNotFoundException) continue;
                throw err;
            }
        }
        info.standaloneMode = standalonemode;
        if (standalonemode) {
            Set<ObjectInstance> connectionsbeans = localServer.queryMBeans(new ObjectName("org.apache.ZooKeeperService:name0=*,name1=Connections,name2=*,name3=*"), null);
            for (ObjectInstance conbean : connectionsbeans) {
                ConnectionMXBean cc = MBeanServerInvocationHandler.newProxyInstance(localServer, conbean.getObjectName(), ConnectionMXBean.class, false);
                try {
                    String nodes = "";
                    if (cc.getEphemeralNodes() != null) {
                        nodes = Arrays.asList(cc.getEphemeralNodes()) + "";
                    }
                    info.connections.add(new ConnectionInfo(cc.getSourceIP(), cc.getSessionId(), cc.getLastOperation(), cc.getLastResponseTime(), cc.getAvgLatency() + "", cc.getLastLatency() + "", nodes));
                }
                catch (Exception ex) {
                    if (ex instanceof InstanceNotFoundException && ex.getCause() instanceof InstanceNotFoundException) continue;
                    throw ex;
                }
            }
        } else {
            if (myName.isEmpty()) {
                throw new IllegalStateException("Cannot find local JMX name for current node, in quorum mode, scanned " + first_level_beans);
            }
            boolean leader = false;
            Set<ObjectInstance> set = localServer.queryMBeans(new ObjectName("org.apache.ZooKeeperService:name0=" + myName + ",name1=*"), null);
            for (ObjectInstance o : set) {
                if (o.getClassName().toLowerCase().contains("local")) {
                    LocalPeerMXBean local = MBeanServerInvocationHandler.newProxyInstance(localServer, o.getObjectName(), LocalPeerMXBean.class, false);
                    info.addPeer(new PeerInfo(local.getName(), local.getQuorumAddress(), local.getState() + "", local.isLeader()));
                    ObjectName asfollowername = new ObjectName(o.getObjectName() + ",name2=Follower");
                    ObjectName asleadername = new ObjectName(o.getObjectName() + ",name2=Leader");
                    boolean isleader = localServer.isRegistered(asleadername);
                    Set<ObjectInstance> connectionsbeans = null;
                    if (isleader) {
                        leader = true;
                        ObjectName asleaderconnections = new ObjectName(asleadername + ",name3=Connections,name4=*,name5=*");
                        connectionsbeans = localServer.queryMBeans(asleaderconnections, null);
                    } else {
                        leader = false;
                        ObjectName asfollowernameconnections = new ObjectName(asfollowername + ",name3=Connections,name4=*,name5=*");
                        connectionsbeans = localServer.queryMBeans(asfollowernameconnections, null);
                    }
                    for (ObjectInstance conbean : connectionsbeans) {
                        ConnectionMXBean cc = MBeanServerInvocationHandler.newProxyInstance(localServer, conbean.getObjectName(), ConnectionMXBean.class, false);
                        try {
                            String nodes = "";
                            if (cc.getEphemeralNodes() != null) {
                                nodes = Arrays.asList(cc.getEphemeralNodes()) + "";
                            }
                            info.connections.add(new ConnectionInfo(cc.getSourceIP(), cc.getSessionId(), cc.getLastOperation(), cc.getLastResponseTime(), cc.getAvgLatency() + "", cc.getLastLatency() + "", nodes));
                        }
                        catch (Exception ex) {
                            if (ex instanceof InstanceNotFoundException && ex.getCause() instanceof InstanceNotFoundException) continue;
                            throw ex;
                        }
                    }
                    continue;
                }
                RemotePeerMXBean remote = MBeanServerInvocationHandler.newProxyInstance(localServer, o.getObjectName(), RemotePeerMXBean.class, false);
                info.addPeer(new PeerInfo(remote.getName(), remote.getQuorumAddress(), "REMOTE", remote.isLeader()));
            }
            info.leader = leader;
        }
        return info;
    }

    public static class ServerInfo {
        private final List<ConnectionInfo> connections = new ArrayList<ConnectionInfo>();
        private boolean leader;
        private boolean standaloneMode;
        public List<PeerInfo> peers = new ArrayList<PeerInfo>();

        public boolean isStandaloneMode() {
            return this.standaloneMode;
        }

        public List<ConnectionInfo> getConnections() {
            return this.connections;
        }

        public boolean isLeader() {
            return this.leader;
        }

        public List<PeerInfo> getPeers() {
            return Collections.unmodifiableList(this.peers);
        }

        public void addPeer(PeerInfo peer) {
            this.peers.add(peer);
        }

        public String toString() {
            return "ServerInfo{connections=" + this.connections + ", leader=" + this.leader + ", standaloneMode=" + this.standaloneMode + ", peers=" + this.peers + '}';
        }
    }

    public static class ConnectionInfo {
        private final String sourceip;
        private final String sessionid;
        private final String lastoperation;
        private final String lastResponseTime;
        private final String avgLatency;
        private final String lastLatency;
        private final String nodes;

        public ConnectionInfo(String sourceip, String sessionid, String lastoperation, String lastResponseTime, String avgLatency, String lastLatency, String nodes) {
            this.sourceip = sourceip;
            this.sessionid = sessionid;
            this.lastoperation = lastoperation;
            this.lastResponseTime = lastResponseTime;
            this.avgLatency = avgLatency;
            this.lastLatency = lastLatency;
            this.nodes = nodes;
        }

        public String getLastLatency() {
            return this.lastLatency;
        }

        public String getSourceip() {
            return this.sourceip;
        }

        public String getSessionid() {
            return this.sessionid;
        }

        public String getLastoperation() {
            return this.lastoperation;
        }

        public String getLastResponseTime() {
            return this.lastResponseTime;
        }

        public String getAvgLatency() {
            return this.avgLatency;
        }

        public String getNodes() {
            return this.nodes;
        }

        public String toString() {
            return "ConnectionInfo{sourceip=" + this.sourceip + ", sessionid=" + this.sessionid + ", lastoperation=" + this.lastoperation + ", lastResponseTime=" + this.lastResponseTime + ", avgLatency=" + this.avgLatency + ", nodes=" + this.nodes + '}';
        }
    }

    public static class PeerInfo {
        private final String name;
        private final String quorumAddress;
        private final String state;
        private final boolean leader;

        public PeerInfo(String name, String quorumAddress, String state, boolean leader) {
            this.name = name;
            this.quorumAddress = quorumAddress;
            this.state = state;
            this.leader = leader;
        }

        public String getName() {
            return this.name;
        }

        public String getQuorumAddress() {
            return this.quorumAddress;
        }

        public String getState() {
            return this.state;
        }

        public boolean isLeader() {
            return this.leader;
        }

        public String toString() {
            return "PeerInfo{name=" + this.name + ", leader=" + this.leader + ", quorumAddress=" + this.quorumAddress + ", state=" + this.state + '}';
        }
    }
}

