/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import lombok.NonNull;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;

public class BookieInfoService
implements HttpEndpointService {
    @NonNull
    private final Bookie bookie;

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET != request.getMethod()) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("Only GET is supported.");
            return response;
        }
        BookieInfo bi = new BookieInfo(this.bookie.getTotalFreeSpace(), this.bookie.getTotalDiskSpace());
        String jsonResponse = JsonUtil.toJson((Object)bi);
        response.setBody(jsonResponse);
        response.setCode(HttpServer.StatusCode.OK);
        return response;
    }

    public BookieInfoService(@NonNull Bookie bookie) {
        if (bookie == null) {
            throw new NullPointerException("bookie is marked non-null but is null");
        }
        this.bookie = bookie;
    }

    public static class BookieInfo {
        private long freeSpace;
        private long totalSpace;

        public long getFreeSpace() {
            return this.freeSpace;
        }

        public long getTotalSpace() {
            return this.totalSpace;
        }

        public void setFreeSpace(long freeSpace) {
            this.freeSpace = freeSpace;
        }

        public void setTotalSpace(long totalSpace) {
            this.totalSpace = totalSpace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BookieInfo)) {
                return false;
            }
            BookieInfo other = (BookieInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFreeSpace() != other.getFreeSpace()) {
                return false;
            }
            return this.getTotalSpace() == other.getTotalSpace();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BookieInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $freeSpace = this.getFreeSpace();
            result = result * 59 + (int)($freeSpace >>> 32 ^ $freeSpace);
            long $totalSpace = this.getTotalSpace();
            result = result * 59 + (int)($totalSpace >>> 32 ^ $totalSpace);
            return result;
        }

        public String toString() {
            return "BookieInfoService.BookieInfo(freeSpace=" + this.getFreeSpace() + ", totalSpace=" + this.getTotalSpace() + ")";
        }

        public BookieInfo() {
        }

        public BookieInfo(long freeSpace, long totalSpace) {
            this.freeSpace = freeSpace;
            this.totalSpace = totalSpace;
        }
    }
}

