/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.embedded;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.embedded.ZookeeperServeInfo;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.function.ThrowingRunnable;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZookeeperServerEmbeddedTest {
    @TempDir
    public Path baseDir;

    @BeforeAll
    public static void setUpEnvironment() {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
    }

    @AfterAll
    public static void cleanUpEnvironment() throws InterruptedException, IOException {
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.4lw.commands.whitelist");
    }

    @Test
    public void testStart() throws Exception {
        ZookeeperServeInfo.ServerInfo status;
        int clientPort = PortAssignment.unique();
        Properties configZookeeper = new Properties();
        configZookeeper.put("clientPort", clientPort + "");
        configZookeeper.put("host", "localhost");
        configZookeeper.put("ticktime", "4000");
        try (ZooKeeperServerEmbedded zkServer = ZooKeeperServerEmbedded.builder().baseDir(this.baseDir).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();){
            zkServer.start();
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
            for (int i = 0; !(i >= 100 || (status = ZookeeperServeInfo.getStatus("StandaloneServer*")).isLeader() && status.isStandaloneMode()); ++i) {
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status2 = ZookeeperServeInfo.getStatus("StandaloneServer*");
            Assert.assertTrue((boolean)status2.isLeader());
            Assert.assertTrue((boolean)status2.isStandaloneMode());
        }
        zkServer = ZooKeeperServerEmbedded.builder().baseDir(this.baseDir).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();
        try {
            zkServer.start();
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
            for (int i = 0; !(i >= 100 || (status = ZookeeperServeInfo.getStatus("StandaloneServer*")).isLeader() && status.isStandaloneMode()); ++i) {
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status3 = ZookeeperServeInfo.getStatus("StandaloneServer*");
            Assert.assertTrue((boolean)status3.isLeader());
            Assert.assertTrue((boolean)status3.isStandaloneMode());
        }
        finally {
            if (zkServer != null) {
                zkServer.close();
            }
        }
    }

    @Test
    public void testBindPortZero() throws Exception {
        Properties configZookeeper = new Properties();
        ZooKeeperServerEmbedded.ZookKeeperServerEmbeddedBuilder builder = ZooKeeperServerEmbedded.builder().baseDir(this.baseDir).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY);
        try (final ZooKeeperServerEmbedded zkServer = builder.build();){
            zkServer.start();
            Assert.assertThrows(IllegalStateException.class, (ThrowingRunnable)new ThrowingRunnable(){

                public void run() throws Throwable {
                    zkServer.getConnectionString();
                }
            });
        }
        configZookeeper.put("clientPort", "0");
        zkServer = builder.build();
        try {
            zkServer.start();
            MatcherAssert.assertThat((Object)zkServer.getConnectionString(), (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)":0")));
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
        }
        finally {
            if (zkServer != null) {
                zkServer.close();
            }
        }
    }
}

