/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKStats {
    private static final Logger LOG = LoggerFactory.getLogger(BKStats.class);
    private static BKStats instance = new BKStats();
    public static final int STATS_ADD = 0;
    public static final int STATS_READ = 1;
    public static final int STATS_UNKNOWN = 2;
    public static final int NUM_STATS = 3;
    OpStats[] stats = new OpStats[3];

    public static BKStats getInstance() {
        return instance;
    }

    private BKStats() {
        for (int i = 0; i < 3; ++i) {
            this.stats[i] = new OpStats();
        }
    }

    public OpStats getOpStats(int type) {
        return this.stats[type];
    }

    public void setOpStats(int type, OpStats stat) {
        this.stats[type] = stat;
    }

    public BKStats diff(BKStats base) {
        BKStats diff = new BKStats();
        for (int i = 0; i < 3; ++i) {
            diff.setOpStats(i, this.stats[i].diff(base.getOpStats(i)));
        }
        return diff;
    }

    public void copyOf(BKStats other) {
        for (int i = 0; i < 3; ++i) {
            this.stats[i].copyOf(other.getOpStats(i));
        }
    }

    public static class OpStats {
        static final int NUM_BUCKETS = 29;
        long maxLatency = 0L;
        long minLatency = Long.MAX_VALUE;
        double totalLatency = 0.0;
        long numSuccessOps = 0L;
        long numFailedOps = 0L;
        long[] latencyBuckets = new long[29];

        OpStats() {
        }

        public synchronized void incrementFailedOps() {
            ++this.numFailedOps;
        }

        public synchronized void updateLatency(long latency) {
            if (latency < 0L) {
                LOG.warn("Latency time coming negative");
                return;
            }
            this.totalLatency += (double)latency;
            ++this.numSuccessOps;
            if (latency < this.minLatency) {
                this.minLatency = latency;
            }
            if (latency > this.maxLatency) {
                this.maxLatency = latency;
            }
            int bucket = latency <= 100L ? (int)(latency / 10L) : (latency <= 1000L ? 9 + (int)(latency / 100L) : (latency <= 10000L ? 18 + (int)(latency / 1000L) : 28));
            int n = bucket;
            this.latencyBuckets[n] = this.latencyBuckets[n] + 1L;
        }

        public OpStatData toOpStatData() {
            double avgLatency = this.numSuccessOps > 0L ? this.totalLatency / (double)this.numSuccessOps : 0.0;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 29; ++i) {
                sb.append(this.latencyBuckets[i]);
                if (i == 28) continue;
                sb.append(',');
            }
            return new OpStatData(this.maxLatency, this.minLatency, avgLatency, this.numSuccessOps, this.numFailedOps, sb.toString());
        }

        public OpStats diff(OpStats base) {
            OpStats diff = new OpStats();
            diff.maxLatency = this.maxLatency > base.maxLatency ? this.maxLatency : base.maxLatency;
            diff.minLatency = this.minLatency > base.minLatency ? base.minLatency : this.minLatency;
            diff.totalLatency = this.totalLatency - base.totalLatency;
            diff.numSuccessOps = this.numSuccessOps - base.numSuccessOps;
            diff.numFailedOps = this.numFailedOps - base.numFailedOps;
            for (int i = 0; i < 29; ++i) {
                diff.latencyBuckets[i] = this.latencyBuckets[i] - base.latencyBuckets[i];
            }
            return diff;
        }

        public synchronized void copyOf(OpStats other) {
            this.maxLatency = other.maxLatency;
            this.minLatency = other.minLatency;
            this.totalLatency = other.totalLatency;
            this.numSuccessOps = other.numSuccessOps;
            this.numFailedOps = other.numFailedOps;
            System.arraycopy(other.latencyBuckets, 0, this.latencyBuckets, 0, this.latencyBuckets.length);
        }
    }

    public static class OpStatData {
        private final long maxLatency;
        private final long minLatency;
        private final double avgLatency;
        private final long numSuccessOps;
        private final long numFailedOps;
        private final String latencyHist;

        @ConstructorProperties(value={"maxLatency", "minLatency", "avgLatency", "numSuccessOps", "numFailedOps", "latencyHist"})
        public OpStatData(long maxLatency, long minLatency, double avgLatency, long numSuccessOps, long numFailedOps, String latencyHist) {
            this.maxLatency = maxLatency;
            this.minLatency = minLatency == Long.MAX_VALUE ? 0L : minLatency;
            this.avgLatency = avgLatency;
            this.numSuccessOps = numSuccessOps;
            this.numFailedOps = numFailedOps;
            this.latencyHist = latencyHist;
        }

        public long getMaxLatency() {
            return this.maxLatency;
        }

        public long getMinLatency() {
            return this.minLatency;
        }

        public double getAvgLatency() {
            return this.avgLatency;
        }

        public long getNumSuccessOps() {
            return this.numSuccessOps;
        }

        public long getNumFailedOps() {
            return this.numFailedOps;
        }

        public String getLatencyHist() {
            return this.latencyHist;
        }
    }
}

