/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public class ByteBufVisitor {
    private static final int DEFAULT_VISIT_MAX_DEPTH = 10;
    private static final int TL_COPY_BUFFER_SIZE = 65536;
    private static final FastThreadLocal<byte[]> TL_COPY_BUFFER = new FastThreadLocal<byte[]>(){

        protected byte[] initialValue() {
            return new byte[65536];
        }
    };

    private ByteBufVisitor() {
    }

    public static <T> void visitBuffers(ByteBuf buffer, int offset, int length, ByteBufVisitorCallback<T> callback, T context) {
        ByteBufVisitor.visitBuffers(buffer, offset, length, callback, context, 10);
    }

    public static <T> void visitBuffers(ByteBuf buffer, int offset, int length, ByteBufVisitorCallback<T> callback, T context, int maxDepth) {
        if (length == 0) {
            return;
        }
        InternalContext internalContext = new InternalContext();
        internalContext.maxDepth = maxDepth;
        internalContext.callbackContext = context;
        internalContext.callback = callback;
        internalContext.recursivelyVisitBuffers(buffer, offset, length);
    }

    static class GetBytesCallbackByteBuf<T>
    extends ByteBuf {
        private final InternalContext<T> internalContext;

        GetBytesCallbackByteBuf(InternalContext<T> internalContext) {
            this.internalContext = internalContext;
        }

        public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
            this.internalContext.handleBuffer(src, srcIndex, length);
            return this;
        }

        public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
            this.internalContext.handleArray(src, srcIndex, length);
            return this;
        }

        public boolean hasArray() {
            return false;
        }

        public boolean hasMemoryAddress() {
            return false;
        }

        public int nioBufferCount() {
            return 0;
        }

        public int capacity() {
            return Integer.MAX_VALUE;
        }

        public ByteBuf capacity(int newCapacity) {
            throw new UnsupportedOperationException();
        }

        public int maxCapacity() {
            throw new UnsupportedOperationException();
        }

        public ByteBufAllocator alloc() {
            throw new UnsupportedOperationException();
        }

        public ByteOrder order() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf order(ByteOrder endianness) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf unwrap() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirect() {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf asReadOnly() {
            throw new UnsupportedOperationException();
        }

        public int readerIndex() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readerIndex(int readerIndex) {
            throw new UnsupportedOperationException();
        }

        public int writerIndex() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writerIndex(int writerIndex) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setIndex(int readerIndex, int writerIndex) {
            throw new UnsupportedOperationException();
        }

        public int readableBytes() {
            throw new UnsupportedOperationException();
        }

        public int writableBytes() {
            throw new UnsupportedOperationException();
        }

        public int maxWritableBytes() {
            throw new UnsupportedOperationException();
        }

        public boolean isReadable() {
            throw new UnsupportedOperationException();
        }

        public boolean isReadable(int size) {
            throw new UnsupportedOperationException();
        }

        public boolean isWritable() {
            throw new UnsupportedOperationException();
        }

        public boolean isWritable(int size) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf clear() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf markReaderIndex() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf resetReaderIndex() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf markWriterIndex() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf resetWriterIndex() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf discardReadBytes() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf discardSomeReadBytes() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf ensureWritable(int minWritableBytes) {
            throw new UnsupportedOperationException();
        }

        public int ensureWritable(int minWritableBytes, boolean force) {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean(int index) {
            throw new UnsupportedOperationException();
        }

        public byte getByte(int index) {
            throw new UnsupportedOperationException();
        }

        public short getUnsignedByte(int index) {
            throw new UnsupportedOperationException();
        }

        public short getShort(int index) {
            throw new UnsupportedOperationException();
        }

        public short getShortLE(int index) {
            throw new UnsupportedOperationException();
        }

        public int getUnsignedShort(int index) {
            throw new UnsupportedOperationException();
        }

        public int getUnsignedShortLE(int index) {
            throw new UnsupportedOperationException();
        }

        public int getMedium(int index) {
            throw new UnsupportedOperationException();
        }

        public int getMediumLE(int index) {
            throw new UnsupportedOperationException();
        }

        public int getUnsignedMedium(int index) {
            throw new UnsupportedOperationException();
        }

        public int getUnsignedMediumLE(int index) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int index) {
            throw new UnsupportedOperationException();
        }

        public int getIntLE(int index) {
            throw new UnsupportedOperationException();
        }

        public long getUnsignedInt(int index) {
            throw new UnsupportedOperationException();
        }

        public long getUnsignedIntLE(int index) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int index) {
            throw new UnsupportedOperationException();
        }

        public long getLongLE(int index) {
            throw new UnsupportedOperationException();
        }

        public char getChar(int index) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int index) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int index) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, ByteBuf dst) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, ByteBuf dst, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, byte[] dst) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, ByteBuffer dst) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public CharSequence getCharSequence(int index, int length, Charset charset) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setBoolean(int index, boolean value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setByte(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setShort(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setShortLE(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setMedium(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setMediumLE(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setInt(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setIntLE(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setLong(int index, long value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setLongLE(int index, long value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setChar(int index, int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setFloat(int index, float value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setDouble(int index, double value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setBytes(int index, ByteBuf src) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setBytes(int index, ByteBuf src, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setBytes(int index, byte[] src) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setBytes(int index, ByteBuffer src) {
            throw new UnsupportedOperationException();
        }

        public int setBytes(int index, InputStream in, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ByteBuf setZero(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public int setCharSequence(int index, CharSequence sequence, Charset charset) {
            throw new UnsupportedOperationException();
        }

        public boolean readBoolean() {
            throw new UnsupportedOperationException();
        }

        public byte readByte() {
            throw new UnsupportedOperationException();
        }

        public short readUnsignedByte() {
            throw new UnsupportedOperationException();
        }

        public short readShort() {
            throw new UnsupportedOperationException();
        }

        public short readShortLE() {
            throw new UnsupportedOperationException();
        }

        public int readUnsignedShort() {
            throw new UnsupportedOperationException();
        }

        public int readUnsignedShortLE() {
            throw new UnsupportedOperationException();
        }

        public int readMedium() {
            throw new UnsupportedOperationException();
        }

        public int readMediumLE() {
            throw new UnsupportedOperationException();
        }

        public int readUnsignedMedium() {
            throw new UnsupportedOperationException();
        }

        public int readUnsignedMediumLE() {
            throw new UnsupportedOperationException();
        }

        public int readInt() {
            throw new UnsupportedOperationException();
        }

        public int readIntLE() {
            throw new UnsupportedOperationException();
        }

        public long readUnsignedInt() {
            throw new UnsupportedOperationException();
        }

        public long readUnsignedIntLE() {
            throw new UnsupportedOperationException();
        }

        public long readLong() {
            throw new UnsupportedOperationException();
        }

        public long readLongLE() {
            throw new UnsupportedOperationException();
        }

        public char readChar() {
            throw new UnsupportedOperationException();
        }

        public float readFloat() {
            throw new UnsupportedOperationException();
        }

        public double readDouble() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readSlice(int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readRetainedSlice(int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(ByteBuf dst) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(ByteBuf dst, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(byte[] dst) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(ByteBuffer dst) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf readBytes(OutputStream out, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int readBytes(GatheringByteChannel out, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public CharSequence readCharSequence(int length, Charset charset) {
            throw new UnsupportedOperationException();
        }

        public int readBytes(FileChannel out, long position, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ByteBuf skipBytes(int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBoolean(boolean value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeByte(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeShort(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeShortLE(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeMedium(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeMediumLE(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeInt(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeIntLE(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeLong(long value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeLongLE(long value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeChar(int value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeFloat(float value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeDouble(double value) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBytes(ByteBuf src) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBytes(ByteBuf src, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBytes(byte[] src) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeBytes(ByteBuffer src) {
            throw new UnsupportedOperationException();
        }

        public int writeBytes(InputStream in, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int writeBytes(FileChannel in, long position, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ByteBuf writeZero(int length) {
            throw new UnsupportedOperationException();
        }

        public int writeCharSequence(CharSequence sequence, Charset charset) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(int fromIndex, int toIndex, byte value) {
            throw new UnsupportedOperationException();
        }

        public int bytesBefore(byte value) {
            throw new UnsupportedOperationException();
        }

        public int bytesBefore(int length, byte value) {
            throw new UnsupportedOperationException();
        }

        public int bytesBefore(int index, int length, byte value) {
            throw new UnsupportedOperationException();
        }

        public int forEachByte(ByteProcessor processor) {
            throw new UnsupportedOperationException();
        }

        public int forEachByte(int index, int length, ByteProcessor processor) {
            throw new UnsupportedOperationException();
        }

        public int forEachByteDesc(ByteProcessor processor) {
            throw new UnsupportedOperationException();
        }

        public int forEachByteDesc(int index, int length, ByteProcessor processor) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf copy() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf copy(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf slice() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf retainedSlice() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf slice(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf retainedSlice(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf duplicate() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf retainedDuplicate() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer nioBuffer() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer nioBuffer(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer internalNioBuffer(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer[] nioBuffers() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer[] nioBuffers(int index, int length) {
            throw new UnsupportedOperationException();
        }

        public byte[] array() {
            throw new UnsupportedOperationException();
        }

        public int arrayOffset() {
            throw new UnsupportedOperationException();
        }

        public long memoryAddress() {
            throw new UnsupportedOperationException();
        }

        public String toString(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public String toString(int index, int length, Charset charset) {
            throw new UnsupportedOperationException();
        }

        public int compareTo(ByteBuf buffer) {
            throw new UnsupportedOperationException();
        }

        public ByteBuf retain(int increment) {
            throw new UnsupportedOperationException();
        }

        public int refCnt() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf retain() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf touch() {
            throw new UnsupportedOperationException();
        }

        public ByteBuf touch(Object hint) {
            throw new UnsupportedOperationException();
        }

        public boolean release() {
            throw new UnsupportedOperationException();
        }

        public boolean release(int decrement) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode((Object)this));
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }

    private static class InternalContext<T> {
        int depth;
        int maxDepth;
        ByteBuf parentBuffer;
        int parentOffset;
        int parentLength;
        T callbackContext;
        ByteBufVisitorCallback<T> callback;
        GetBytesCallbackByteBuf<T> callbackByteBuf = new GetBytesCallbackByteBuf(this);

        private InternalContext() {
        }

        void recursivelyVisitBuffers(ByteBuf visitBuffer, int visitIndex, int visitLength) {
            if (this.depth < this.maxDepth && !visitBuffer.hasMemoryAddress() && !visitBuffer.hasArray()) {
                this.parentBuffer = visitBuffer;
                this.parentOffset = visitIndex;
                this.parentLength = visitLength;
                ++this.depth;
                visitBuffer.getBytes(visitIndex, this.callbackByteBuf, 0, visitLength);
                --this.depth;
            } else {
                this.passBufferToCallback(visitBuffer, visitIndex, visitLength);
            }
        }

        void handleBuffer(ByteBuf visitBuffer, int visitIndex, int visitLength) {
            if (visitLength == 0) {
                return;
            }
            if (visitBuffer == this.parentBuffer && visitIndex == this.parentOffset && visitLength == this.parentLength) {
                this.passBufferToCallback(visitBuffer, visitIndex, visitLength);
            } else {
                this.recursivelyVisitBuffers(visitBuffer, visitIndex, visitLength);
            }
        }

        private void passBufferToCallback(ByteBuf visitBuffer, int visitIndex, int visitLength) {
            if (this.callback.preferArrayOrMemoryAddress(this.callbackContext)) {
                if (visitBuffer.hasArray()) {
                    this.handleArray(visitBuffer.array(), visitBuffer.arrayOffset() + visitIndex, visitLength);
                } else if (visitBuffer.hasMemoryAddress() && this.callback.acceptsMemoryAddress(this.callbackContext)) {
                    this.callback.visitBuffer(this.callbackContext, visitBuffer, visitIndex, visitLength);
                } else {
                    byte[] copyBuffer = (byte[])TL_COPY_BUFFER.get();
                    int remaining = visitLength;
                    int currentOffset = visitIndex;
                    while (remaining > 0) {
                        int readLen = Math.min(remaining, copyBuffer.length);
                        visitBuffer.getBytes(currentOffset, copyBuffer, 0, readLen);
                        this.handleArray(copyBuffer, 0, readLen);
                        remaining -= readLen;
                        currentOffset += readLen;
                    }
                }
            } else {
                this.callback.visitBuffer(this.callbackContext, visitBuffer, visitIndex, visitLength);
            }
        }

        void handleArray(byte[] visitArray, int visitIndex, int visitLength) {
            if (visitLength == 0) {
                return;
            }
            this.callback.visitArray(this.callbackContext, visitArray, visitIndex, visitLength);
        }
    }

    public static interface ByteBufVisitorCallback<T> {
        public void visitBuffer(T var1, ByteBuf var2, int var3, int var4);

        public void visitArray(T var1, byte[] var2, int var3, int var4);

        default public boolean preferArrayOrMemoryAddress(T context) {
            return true;
        }

        default public boolean acceptsMemoryAddress(T context) {
            return false;
        }
    }
}

