/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.stream.Stream;
import org.apache.zookeeper.PortAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PortAssignmentTest {
    public static Stream<Arguments> data() throws Exception {
        return Stream.of(Arguments.of((Object[])new Object[]{"8", "threadid=1", 11221, 13913}), Arguments.of((Object[])new Object[]{"8", "threadid=2", 13914, 16606}), Arguments.of((Object[])new Object[]{"8", "threadid=3", 16607, 19299}), Arguments.of((Object[])new Object[]{"8", "threadid=4", 19300, 21992}), Arguments.of((Object[])new Object[]{"8", "threadid=5", 21993, 24685}), Arguments.of((Object[])new Object[]{"8", "threadid=6", 24686, 27378}), Arguments.of((Object[])new Object[]{"8", "threadid=7", 27379, 30071}), Arguments.of((Object[])new Object[]{"8", "threadid=8", 30072, 32764}), Arguments.of((Object[])new Object[]{"1", "threadid=1", 11221, Short.MAX_VALUE}), Arguments.of((Object[])new Object[]{"2", "threadid=1", 11221, 21993}), Arguments.of((Object[])new Object[]{"2", "threadid=2", 21994, 32766}), Arguments.of((Object[])new Object[]{null, null, 11221, Short.MAX_VALUE}), Arguments.of((Object[])new Object[]{"", "", 11221, Short.MAX_VALUE}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetupPortRange(String strProcessCount, String cmdLine, int expectedMinimumPort, int expectedMaximumPort) {
        PortAssignment.PortRange portRange = PortAssignment.setupPortRange(strProcessCount, cmdLine);
        Assertions.assertEquals((int)expectedMinimumPort, (int)portRange.getMinimum(), (String)this.buildAssertionMessage("minimum", strProcessCount, cmdLine));
        Assertions.assertEquals((int)expectedMaximumPort, (int)portRange.getMaximum(), (String)this.buildAssertionMessage("maximum", strProcessCount, cmdLine));
    }

    private String buildAssertionMessage(String checkType, String strProcessCount, String cmdLine) {
        return String.format("strProcessCount = %s, cmdLine = %s, checking %s", strProcessCount, cmdLine, checkType);
    }
}

