/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.LoggerFactory;

public class LoggerTestTool
implements AutoCloseable {
    private final ByteArrayOutputStream os;
    private Appender<ILoggingEvent> appender;
    private Logger qlogger;

    public LoggerTestTool(Class<?> cls) {
        this.os = this.createLoggingStream(cls);
    }

    public LoggerTestTool(String cls) {
        this.os = this.createLoggingStream(cls);
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.os;
    }

    private ByteArrayOutputStream createLoggingStream(Class<?> cls) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.appender = this.getConsoleAppender(os);
        this.qlogger = (Logger)LoggerFactory.getLogger(cls);
        this.qlogger.addAppender(this.appender);
        this.qlogger.setLevel(Level.INFO);
        this.appender.start();
        return os;
    }

    private ByteArrayOutputStream createLoggingStream(String cls) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.appender = this.getConsoleAppender(os);
        this.qlogger = (Logger)LoggerFactory.getLogger((String)cls);
        this.qlogger.addAppender(this.appender);
        this.qlogger.setLevel(Level.INFO);
        this.appender.start();
        return os;
    }

    private OutputStreamAppender<ILoggingEvent> getConsoleAppender(ByteArrayOutputStream os) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Layout layout = ((LayoutWrappingEncoder)((OutputStreamAppender)rootLogger.getAppender("CONSOLE")).getEncoder()).getLayout();
        OutputStreamAppender appender = new OutputStreamAppender();
        appender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        appender.setOutputStream((OutputStream)os);
        appender.setLayout(layout);
        return appender;
    }

    @Override
    public void close() throws Exception {
        this.qlogger.detachAppender(this.appender);
        this.os.close();
    }
}

