/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.bookkeeper.stats.prometheus.SimpleGauge;

public class PrometheusTextFormat {
    Set<String> metricNameSet = new HashSet<String>();

    void writeGauge(Writer w, String name, SimpleGauge<? extends Number> gauge) {
        try {
            this.writeType(w, name, "gauge");
            w.append(name);
            this.writeLabels(w, gauge.getLabels());
            w.append(' ').append(gauge.getSample().toString()).append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void writeCounter(Writer w, String name, LongAdderCounter counter) {
        try {
            this.writeType(w, name, "counter");
            w.append(name);
            this.writeLabels(w, counter.getLabels());
            w.append(' ').append(counter.get().toString()).append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void writeOpStat(Writer w, String name, DataSketchesOpStatsLogger opStat) {
        try {
            this.writeType(w, name, "summary");
            this.writeQuantile(w, opStat, name, false, 0.5);
            this.writeQuantile(w, opStat, name, false, 0.75);
            this.writeQuantile(w, opStat, name, false, 0.95);
            this.writeQuantile(w, opStat, name, false, 0.99);
            this.writeQuantile(w, opStat, name, false, 0.999);
            this.writeQuantile(w, opStat, name, false, 0.9999);
            this.writeQuantile(w, opStat, name, false, 1.0);
            this.writeCount(w, opStat, name, false);
            this.writeSum(w, opStat, name, false);
            this.writeQuantile(w, opStat, name, true, 0.5);
            this.writeQuantile(w, opStat, name, true, 0.75);
            this.writeQuantile(w, opStat, name, true, 0.95);
            this.writeQuantile(w, opStat, name, true, 0.99);
            this.writeQuantile(w, opStat, name, true, 0.999);
            this.writeQuantile(w, opStat, name, true, 0.9999);
            this.writeQuantile(w, opStat, name, true, 1.0);
            this.writeCount(w, opStat, name, true);
            this.writeSum(w, opStat, name, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLabels(Writer w, Map<String, String> labels) throws IOException {
        if (labels.isEmpty()) {
            return;
        }
        w.append('{');
        this.writeLabelsNoBraces(w, labels);
        w.append('}');
    }

    private void writeLabelsNoBraces(Writer w, Map<String, String> labels) throws IOException {
        if (labels.isEmpty()) {
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> e : labels.entrySet()) {
            if (!isFirst) {
                w.append(',');
            }
            isFirst = false;
            w.append(e.getKey()).append("=\"").append(e.getValue()).append('\"');
        }
    }

    private void writeQuantile(Writer w, DataSketchesOpStatsLogger opStat, String name, Boolean success, double quantile) throws IOException {
        w.append(name).append("{success=\"").append(success.toString()).append("\",quantile=\"").append(Double.toString(quantile)).append("\"");
        if (!opStat.getLabels().isEmpty()) {
            w.append(", ");
            this.writeLabelsNoBraces(w, opStat.getLabels());
        }
        w.append("} ").append(Double.toString(opStat.getQuantileValue(success, quantile))).append('\n');
    }

    private void writeCount(Writer w, DataSketchesOpStatsLogger opStat, String name, Boolean success) throws IOException {
        w.append(name).append("_count{success=\"").append(success.toString()).append("\"");
        if (!opStat.getLabels().isEmpty()) {
            w.append(", ");
            this.writeLabelsNoBraces(w, opStat.getLabels());
        }
        w.append("} ").append(Long.toString(opStat.getCount(success))).append('\n');
    }

    private void writeSum(Writer w, DataSketchesOpStatsLogger opStat, String name, Boolean success) throws IOException {
        w.append(name).append("_sum{success=\"").append(success.toString()).append("\"");
        if (!opStat.getLabels().isEmpty()) {
            w.append(", ");
            this.writeLabelsNoBraces(w, opStat.getLabels());
        }
        w.append("} ").append(Double.toString(opStat.getSum(success))).append('\n');
    }

    static void writeMetricsCollectedByPrometheusClient(Writer w, CollectorRegistry registry) throws IOException {
        Enumeration metricFamilySamples = registry.metricFamilySamples();
        while (metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamily = (Collector.MetricFamilySamples)metricFamilySamples.nextElement();
            w.append("# TYPE ").append(metricFamily.name).append(PrometheusTextFormat.getTypeNameSuffix(metricFamily.type)).append(' ').append(PrometheusTextFormat.getTypeStr(metricFamily.type)).write(10);
            for (int i = 0; i < metricFamily.samples.size(); ++i) {
                Collector.MetricFamilySamples.Sample sample = (Collector.MetricFamilySamples.Sample)metricFamily.samples.get(i);
                w.write(sample.name);
                w.write(123);
                for (int j = 0; j < sample.labelNames.size(); ++j) {
                    if (j != 0) {
                        w.write(", ");
                    }
                    w.write((String)sample.labelNames.get(j));
                    w.write("=\"");
                    w.write((String)sample.labelValues.get(j));
                    w.write(34);
                }
                w.write("} ");
                w.write(Collector.doubleToGoString((double)sample.value));
                w.write(10);
            }
        }
    }

    static String getTypeNameSuffix(Collector.Type type) {
        if (type.equals((Object)Collector.Type.INFO)) {
            return "_info";
        }
        return "";
    }

    static String getTypeStr(Collector.Type type) {
        switch (type) {
            case COUNTER: {
                return "counter";
            }
            case GAUGE: 
            case INFO: {
                return "gauge";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "unknown";
    }

    void writeType(Writer w, String name, String type) throws IOException {
        if (this.metricNameSet.contains(name)) {
            return;
        }
        this.metricNameSet.add(name);
        w.append("# TYPE ").append(name).append(" ").append(type).append("\n");
    }
}

