/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.calcite.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Objects.requireNonNull;

/**
 * JSON object representing a type attribute.
 */
public class JsonTypeAttribute {
  /** Name of this attribute.
   *
   * <p>Required.
   */
  public final String name;

  /** Type of this attribute.
   *
   * <p>Required.
   */
  public final String type;

  @JsonCreator
  public JsonTypeAttribute(
      @JsonProperty(value = "name", required = true) String name,
      @JsonProperty(value = "type", required = true) String type) {
    this.name = requireNonNull(name, "name");
    this.type = requireNonNull(type, "type");
  }
}
