---
layout: news_item
date: "2017-01-09 08:15:00 +0000"
author: jhyde
version: 1.11.0
categories: [release]
tag: v1-11-0
sha: f8ba670
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

The [Apache Calcite PMC]({{ site.baseurl }})
is pleased to announce
[Apache Calcite release 1.11.0]({{ site.baseurl }}/docs/history.html#v1-11-0).

Nearly three months after the previous release, there is a
[long list of improvements and bug-fixes]({{ site.baseurl }}/docs/history.html#v1-11-0),
many of them making planner rules smarter. The following are some of
the more important ones.

Several adapters have improvements:

* The JDBC adapter can now push down DML (`INSERT`, `UPDATE`, `DELETE`),
  windowed aggregates (`OVER`), `IS NULL` and `IS NOT NULL` operators.
* The Cassandra adapter now supports authentication.
* Several key bug-fixes in the Druid adapter.

For correlated and uncorrelated sub-queries, we generate more
efficient plans (for example, in some correlated queries we no longer
require a sub-query to generate the values of the correlating
variable), can now handle multiple correlations, and have also fixed a
few correctness bugs.

New SQL syntax:

* `CROSS APPLY` and `OUTER APPLY`;
* `MINUS` as a synonym for `EXCEPT`;
* an `AS JSON` option for the `EXPLAIN` command;
* compound identifiers in the target list of `INSERT`, allowing you to
  insert into individual fields of record-valued columns (or column
  families if you are using the Apache Phoenix adapter).

A variety of new and extended built-in functions: `CONVERT`, `LTRIM`,
`RTRIM`, 3-parameter `LOCATE` and `POSITION`, `RAND`, `RAND_INTEGER`,
and `SUBSTRING` applied to binary types.

There are minor but potentially breaking API changes in
[<a href="https://issues.apache.org/jira/browse/CALCITE-1519">CALCITE-1519</a>]
\(interface `SubqueryConverter` becomes `SubQueryConverter` and some
similar changes in the case of classes and methods\) and
[<a href="https://issues.apache.org/jira/browse/CALCITE-1530">CALCITE-1530</a>]
\(rename `Shuttle` to `Visitor`, and create a new class `Visitor<R>`\).
See the cases for more details.
