---
layout: news_item
date: "2021-10-19 18:30:00 +0000"
author: jhyde
version: 1.28.0
categories: [release]
tag: v1-28-0
sha: dec167ac18272c0cd8be477d6b162d7a31a62114
---
<!--
{% comment %}
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
{% endcomment %}
-->

The [Apache Calcite PMC]({{ site.baseurl }})
is pleased to announce
[Apache Calcite release 1.28.0]({{ site.baseurl }}/docs/history.html#v1-28-0).

This release comes four months after [1.27.0]({{ site.baseurl }}/docs/history.html#v1-27-0),
contains contributions from 38 authors,
and resolves 76 issues.
New features include the
<a href="https://issues.apache.org/jira/browse/CALCITE-4486">UNIQUE</a>
sub-query predicate, the
<a href="https://issues.apache.org/jira/browse/CALCITE-4661">MODE</a> aggregate function,
<a href="https://issues.apache.org/jira/browse/CALCITE-4644">PERCENTILE_CONT and PERCENTILE_DISC</a>
inverse distribution functions, an
<a href="https://issues.apache.org/jira/browse/CALCITE-4614">Exasol dialect</a>
for the JDBC adapter, and improvements to
<a href="https://issues.apache.org/jira/browse/CALCITE-4779">materialized</a>
<a href="https://issues.apache.org/jira/browse/CALCITE-3935">view</a>
<a href="https://issues.apache.org/jira/browse/CALCITE-4774">recognition</a>.

This release contains some breaking changes (described below) due to the
[replacement of ImmutableBeans with Immutables](https://issues.apache.org/jira/browse/CALCITE-4787).
Two APIs are deprecated and will be
[removed in release 1.29]({{ site.baseurl }}/docs/history.html#to-be-removed-in-1-29-0).

## Breaking changes to ImmutableBeans

In 1.28, Calcite converted the recently introduced
[configuration system](https://issues.apache.org/jira/browse/CALCITE-3328)
from an internal system based on
[ImmutableBeans](https://github.com/apache/calcite/blob/main/core/src/main/java/org/apache/calcite/util/ImmutableBeans.java)
to instead use the [Immutables](https://immutables.github.io/)
annotation processor. This library brings a large number of additional
features that should make value-type classes in Calcite easier to
build and leverage. It also reduces reliance on dynamic proxies, which
should improve performance and reduce memory footprint. Lastly, this
change increases compatibility with ahead-of-time compilation
technologies such as [GraalVM](https://www.graalvm.org/). As part of
this change, a number of minor changes have been made and key methods
and classes have been deprecated. The change was designed to minimize
disruption to existing consumers of Calcite but the following minor
changes needed to be made:
* The
  [RelRule.Config.EMPTY](https://github.com/apache/calcite/blob/main/core/src/main/java/org/apache/calcite/plan/RelRule.java#L125)
  field is now deprecated. To create a new configuration subclass, you
  can either use your preferred interface-implementation based
  construction or you can leverage Immutables. To do the latter,
  [configure your project](https://immutables.github.io/getstarted.html)
  to use the Immutables annotation processor and annotate your
  subclass with the
  [`@Value.Immutable`](https://immutables.github.io/immutable.html#value)
  annotation.
* Where `RelRule.Config` subclasses were nested 2+ classes deep, the
  interfaces have been marked deprecated and are superceded by new,
  uniquely named interfaces. The original Configs extend the new
  uniquely named interfaces. Subclassing these work as before and the
  existing rule signatures accept any previously implemented Config
  implementations. However, this is a breaking change if a user stored
  an instance of the `DEFAULT` object using the Config class name (as
  the `DEFAULT` instance now only implements the uniquely named
  interface).
* The `RelRule.Config.as()` method should only be used for safe
  downcasts. Before, it could do arbitrary casts. The exception is
  that arbitrary `as()` will continue to work when using the
  deprecated `RelRule.Config.EMPTY` field. In most cases, this should
  be a non-breaking change. However, all Calcite-defined `DEFAULT`
  rule config instances use Immutables. As such, if one had previously
  subclassed a `RelRule.Config` subclass and then used the `DEFAULT`
  instance from that subclass, the `as()` call will no longer work to
  coerce the `DEFAULT` instance into a arbitrary subclass. In essence,
  outside the `EMPTY` use, `as()` is now only safe to do if a Java
  cast is also safe.
* `ExchangeRemoveConstantKeysRule.Config` and
  `ValuesReduceRule.Config` now declare concrete bounds for their
  matchHandler configuration. This is a breaking change if one did not
  use the Rule as a bounding variable.
* Collections used in Immutables value classes will be converted to
  Immutable collection types even if the passed in parameter is
  mutable (such as an `ArrayList`). As such, consumers of those
  configuration properties cannot mutate the returned collections.
