/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.remote.ClientConnection;
import org.apache.cayenne.rop.HttpClientConnection;
import org.apache.cayenne.rop.ProxyRemoteService;
import org.apache.cayenne.rop.ROPSerializationService;
import org.apache.cayenne.rop.http.HttpROPConnector;

public class HttpClientConnectionProvider
implements Provider<ClientConnection> {
    @Inject
    protected RuntimeProperties runtimeProperties;
    @Inject
    protected ROPSerializationService serializationService;

    public ClientConnection get() throws DIRuntimeException {
        String sharedSession = this.runtimeProperties.get("cayenne.rop.shared_session_name");
        HttpROPConnector ropConnector = this.createHttpRopConnector();
        ProxyRemoteService remoteService = new ProxyRemoteService(this.serializationService, ropConnector);
        HttpClientConnection clientConnection = new HttpClientConnection(remoteService, sharedSession);
        ropConnector.setClientConnection(clientConnection);
        return clientConnection;
    }

    protected HttpROPConnector createHttpRopConnector() {
        String url = this.runtimeProperties.get("cayenne.rop.service_url");
        if (url == null) {
            throw new ConfigurationException("No property defined for '%s', can't initialize HessianConnection", new Object[]{"cayenne.rop.service_url"});
        }
        String userName = this.runtimeProperties.get("cayenne.rop.service_username");
        String password = this.runtimeProperties.get("cayenne.rop.service_password");
        long readTimeout = this.runtimeProperties.getLong("cayenne.rop.service_timeout", -1L);
        HttpROPConnector result = new HttpROPConnector(url, userName, password);
        if (readTimeout > 0L) {
            result.setReadTimeout(readTimeout);
        }
        return result;
    }
}

