/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.celeborn.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingX509TrustManager
implements X509TrustManager,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ReloadingX509TrustManager.class);
    private final String type;
    private final File file;
    private String canonicalPath;
    private final String password;
    private long lastLoaded;
    private final long reloadInterval;
    @VisibleForTesting
    protected volatile int reloadCount;
    @VisibleForTesting
    protected volatile int needsReloadCheckCounts;
    private final AtomicReference<X509TrustManager> trustManagerRef;
    private Thread reloader;
    private static final X509Certificate[] EMPTY = new X509Certificate[0];

    public ReloadingX509TrustManager(String type, File trustStore, String password, long reloadInterval) throws IOException, GeneralSecurityException {
        this.type = type;
        this.file = trustStore;
        this.canonicalPath = this.file.getCanonicalPath();
        this.password = password;
        this.trustManagerRef = new AtomicReference();
        this.trustManagerRef.set(this.loadTrustManager());
        this.reloadInterval = reloadInterval;
        this.reloadCount = 0;
        this.needsReloadCheckCounts = 0;
    }

    public void init() {
        this.reloader = ThreadUtils.newDaemonThread(this, "Truststore reloader thread");
        this.reloader.start();
    }

    public void destroy() throws InterruptedException {
        this.reloader.interrupt();
        this.reloader.join();
    }

    public long getReloadInterval() {
        return this.reloadInterval;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown client chain certificate: " + chain[0].toString() + ". Please ensure the correct trust store is specified in the config");
        }
        tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown server chain certificate: " + chain[0].toString() + ". Please ensure the correct trust store is specified in the config");
        }
        tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = EMPTY;
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            issuers = tm.getAcceptedIssuers();
        }
        return issuers;
    }

    boolean needsReload() throws IOException {
        boolean reload = true;
        File latestCanonicalFile = this.file.getCanonicalFile();
        if (this.file.exists() && latestCanonicalFile.exists()) {
            if (latestCanonicalFile.getPath().equals(this.canonicalPath) && ReloadingX509TrustManager.getFileLastModified(latestCanonicalFile) == this.lastLoaded) {
                reload = false;
            }
        } else {
            this.lastLoaded = 0L;
        }
        return reload;
    }

    X509TrustManager loadTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        X509TrustManager trustManager = null;
        KeyStore ks = KeyStore.getInstance(this.type);
        File latestCanonicalFile = this.file.getCanonicalFile();
        this.canonicalPath = latestCanonicalFile.getPath();
        this.lastLoaded = ReloadingX509TrustManager.getFileLastModified(latestCanonicalFile);
        try (FileInputStream in = new FileInputStream(latestCanonicalFile);){
            char[] passwordCharacters = this.password != null ? this.password.toCharArray() : null;
            ks.load(in, passwordCharacters);
            logger.debug("Loaded truststore '" + this.file + "'");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        for (TrustManager trustManager1 : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager1 instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)trustManager1;
            break;
        }
        return trustManager;
    }

    @Override
    public void run() {
        boolean running = true;
        while (running) {
            try {
                Thread.sleep(this.reloadInterval);
            }
            catch (InterruptedException e) {
                running = false;
            }
            try {
                if (running && this.needsReload()) {
                    try {
                        this.trustManagerRef.set(this.loadTrustManager());
                        ++this.reloadCount;
                    }
                    catch (Exception ex) {
                        logger.warn("Could not load truststore (keep using existing one) : " + ex.toString(), (Throwable)ex);
                    }
                }
            }
            catch (IOException ex) {
                logger.warn("Could not check whether truststore needs reloading: " + ex.toString(), (Throwable)ex);
            }
            ++this.needsReloadCheckCounts;
        }
    }

    private static long getFileLastModified(File file) {
        try {
            return Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException ioEx) {
            logger.info("Unable to read attributes for {}", (Object)file, (Object)ioEx);
            return file.lastModified();
        }
    }
}

