/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.tags;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.tags.WorkerTagsMeta;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.DynamicConfig;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\b\u0010\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019Y\u0006\u0001)A\u0005\u0005\"9A\f\u0001b\u0001\n\u0013i\u0006BB1\u0001A\u0003%a\fC\u0003y\u0001\u0011%\u0011\tC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u001b\u0002A\u0011AA(\u0005-!\u0016mZ:NC:\fw-\u001a:\u000b\u0005A\t\u0012\u0001\u0002;bONT!AE\n\u0002\r5\f7\u000f^3s\u0015\t!R#\u0001\u0004eKBdw.\u001f\u0006\u0003-]\tqa]3sm&\u001cWM\u0003\u0002\u00193\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002+/\u000511m\\7n_:L!\u0001L\u0014\u0003\u000f1{wmZ5oO\u0006i1m\u001c8gS\u001e\u001cVM\u001d<jG\u0016\u00042\u0001I\u00182\u0013\t\u0001\u0014E\u0001\u0004PaRLwN\u001c\t\u0003eej\u0011a\r\u0006\u0003iU\naaY8oM&<'B\u0001\f7\u0015\tQsG\u0003\u00029/\u000511/\u001a:wKJL!AO\u001a\u0003\u001b\r{gNZ5h'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0011Qh\u0010\t\u0003}\u0001i\u0011a\u0004\u0005\u0006[\t\u0001\rAL\u0001\u0010I\u00164\u0017-\u001e7u)\u0006<7\u000b^8sKV\t!\t\u0005\u0003D\u00152;V\"\u0001#\u000b\u0005\u00153\u0015AC2p]\u000e,(O]3oi*\u0011q\tS\u0001\u0005kRLGNC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-#%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011Q\n\u0016\b\u0003\u001dJ\u0003\"aT\u0011\u000e\u0003AS!!U\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*\"!\rA\u0016\fT\u0007\u0002\r&\u0011!L\u0012\u0002\u0004'\u0016$\u0018\u0001\u00053fM\u0006,H\u000e\u001e+bON#xN]3!\u00035\tG\r\u001a(foR\u000bwMR;oGV\taLE\u0002`E\"4A\u0001\u0019\u0004\u0001=\naAH]3gS:,W.\u001a8u}\u0005q\u0011\r\u001a3OK^$\u0016m\u001a$v]\u000e\u0004\u0003CA2g\u001b\u0005!'BA3I\u0003\u0011a\u0017M\\4\n\u0005\u001d$'AB(cU\u0016\u001cG\u000f\u0005\u0003jY2sW\"\u00016\u000b\u0005-4\u0015\u0001\u00034v]\u000e$\u0018n\u001c8\n\u00055T'\u0001\u0003$v]\u000e$\u0018n\u001c8\u0011\t=\u0014H*\u001e\b\u0003\u0007BL!!\u001d#\u0002#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007/\u0003\u0002ti\nQ1*Z=TKR4\u0016.Z<\u000b\u0005E$\u0005CA2w\u0013\t9HMA\u0004C_>dW-\u00198\u0002\u0017\u001d,G\u000fV1h'R|'/Z\u0001\u0011O\u0016$H+Y4hK\u0012<vN]6feN$ra_A\u0005\u00033\ti\u0002E\u0002YyzL!! $\u0003\t1K7\u000f\u001e\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!K\u0001\u0005[\u0016$\u0018-\u0003\u0003\u0002\b\u0005\u0005!AC,pe.,'/\u00138g_\"9\u00111\u0002\u0005A\u0002\u00055\u0011AD;tKJLE-\u001a8uS\u001aLWM\u001d\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\u0015\u0002\u0011%$WM\u001c;jifLA!a\u0006\u0002\u0012\tqQk]3s\u0013\u0012,g\u000e^5gS\u0016\u0014\bBBA\u000e\u0011\u0001\u0007A*\u0001\bdY&,g\u000e\u001e+bON,\u0005\u0010\u001d:\t\r\u0005}\u0001\u00021\u0001|\u0003\u001d9xN]6feN\fa\"\u00193e)\u0006<Gk\\,pe.,'\u000f\u0006\u0004\u0002&\u0005-\u0012q\u0006\t\u0004A\u0005\u001d\u0012bAA\u0015C\t!QK\\5u\u0011\u0019\ti#\u0003a\u0001\u0019\u0006\u0019A/Y4\t\r\u0005E\u0012\u00021\u0001M\u0003!9xN]6fe&#\u0017a\u0005:f[>4X\rV1h\rJ|WnV8sW\u0016\u0014HCBA\u0013\u0003o\tI\u0004\u0003\u0004\u0002.)\u0001\r\u0001\u0014\u0005\u0007\u0003cQ\u0001\u0019\u0001'\u0002!\u001d,G\u000fV1hg\u001a{'oV8sW\u0016\u0014H\u0003BA \u0003\u0007\u0002B!TA!\u0019&\u0011!L\u0016\u0005\u0007\u0003\u000bZ\u0001\u0019\u0001@\u0002\r]|'o[3s\u0003Q\u0011X-\\8wKR\u000bwM\u0012:p[\u000ecWo\u001d;feR!\u0011QEA&\u0011\u0019\ti\u0003\u0004a\u0001\u0019\u0006\tr-\u001a;UC\u001e\u001chi\u001c:DYV\u001cH/\u001a:\u0016\u0005\u0005}\u0002")
public class TagsManager
implements Logging {
    private final Option<ConfigService> configService;
    private final ConcurrentHashMap<String, Set<String>> defaultTagStore;
    private final Function<String, ConcurrentHashMap.KeySetView<String, Boolean>> addNewTagFunc;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        TagsManager tagsManager = this;
        synchronized (tagsManager) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private ConcurrentHashMap<String, Set<String>> defaultTagStore() {
        return this.defaultTagStore;
    }

    private Function<String, ConcurrentHashMap.KeySetView<String, Boolean>> addNewTagFunc() {
        return this.addNewTagFunc;
    }

    private ConcurrentHashMap<String, Set<String>> getTagStore() {
        Option<ConfigService> option = this.configService;
        if (option instanceof Some) {
            Some some = (Some)option;
            ConfigService cs = (ConfigService)some.value();
            return JavaUtils.newConcurrentHashMap((Map)cs.getSystemConfigFromCache().getTags());
        }
        return this.defaultTagStore();
    }

    public List<WorkerInfo> getTaggedWorkers(UserIdentifier userIdentifier, String clientTagsExpr, List<WorkerInfo> workers) {
        String tagsExpr = (String)this.configService.flatMap((Function1 & Serializable & scala.Serializable)cs -> {
            DynamicConfig config = cs.getTenantUserConfigFromCache(userIdentifier.tenantId(), userIdentifier.name());
            WorkerTagsMeta tagsMeta = config.getWorkerTagsMeta();
            if (tagsMeta.preferClientTagExpr()) {
                return new Some((Object)clientTagsExpr);
            }
            return new Some((Object)tagsMeta.tagsExpr());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> clientTagsExpr);
        if (tagsExpr.isEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No tags provided");
            return workers;
        }
        String[] tags = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tagsExpr.split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ObjectRef workersForTags = ObjectRef.create((Object)None$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tags)).foreach((Function1 & Serializable & scala.Serializable)tag -> {
            Set taggedWorkers = this.getTagStore().getOrDefault(tag, Collections.emptySet());
            Option option = (Option)workersForTags$1.elem;
            if (option instanceof Some) {
                Some some = (Some)option;
                Set w = (Set)some.value();
                return BoxesRunTime.boxToBoolean((boolean)w.retainAll(taggedWorkers));
            }
            workersForTags$1.elem = new Some(taggedWorkers);
            return BoxedUnit.UNIT;
        });
        if (((Option)workersForTags.elem).isEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("No workers for tags: ").append(tagsExpr).append(" found in cluster").toString());
            return Collections.emptyList();
        }
        Predicate<WorkerInfo> workerTagsPredicate = new Predicate<WorkerInfo>(null, workersForTags){
            private final ObjectRef workersForTags$1;

            public Predicate<WorkerInfo> and(Predicate<? super WorkerInfo> x$1) {
                return Predicate.super.and(x$1);
            }

            public Predicate<WorkerInfo> negate() {
                return Predicate.super.negate();
            }

            public Predicate<WorkerInfo> or(Predicate<? super WorkerInfo> x$1) {
                return Predicate.super.or(x$1);
            }

            public boolean test(WorkerInfo w) {
                return ((Set)((Option)this.workersForTags$1.elem).get()).contains(w.toUniqueId());
            }
            {
                this.workersForTags$1 = workersForTags$1;
            }
        };
        return workers.stream().filter(workerTagsPredicate).collect(Collectors.toList());
    }

    public void addTagToWorker(String tag, String workerId) {
        Set workers = this.defaultTagStore().computeIfAbsent(tag, this.addNewTagFunc());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Adding Tag ").append(tag).append(" to worker ").append(workerId).toString());
        workers.add(workerId);
    }

    public void removeTagFromWorker(String tag, String workerId) {
        Set<String> workers = this.defaultTagStore().get(tag);
        if (workers != null && workers.contains(workerId)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Removing Tag ").append(tag).append(" from worker ").append(workerId).toString());
            workers.remove(workerId);
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Tag ").append(tag).append(" not found for worker ").append(workerId).toString());
    }

    public scala.collection.immutable.Set<String> getTagsForWorker(WorkerInfo worker) {
        return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.defaultTagStore()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TagsManager.$anonfun$getTagsForWorker$1(worker, x$2)))).keySet().toSet();
    }

    public void removeTagFromCluster(String tag) {
        Set<String> workers = this.defaultTagStore().remove(tag);
        if (workers != null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed Tag ").append(tag).append(" from cluster with workers ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(workers.toArray())).mkString(", ")).toString());
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Tag ").append(tag).append(" not found in cluster and thus can not be removed").toString());
    }

    public scala.collection.immutable.Set<String> getTagsForCluster() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((ConcurrentHashMap.KeySetView)this.defaultTagStore().keySet()).iterator()).asScala()).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$getTagsForWorker$1(WorkerInfo worker$1, Tuple2 x$2) {
        return ((Set)x$2._2()).contains(worker$1.toUniqueId());
    }

    public TagsManager(Option<ConfigService> configService) {
        this.configService = configService;
        Logging.$init$((Logging)this);
        this.defaultTagStore = JavaUtils.newConcurrentHashMap();
        this.addNewTagFunc = new Function<String, ConcurrentHashMap.KeySetView<String, Boolean>>(null){

            public <V> Function<V, ConcurrentHashMap.KeySetView<String, Boolean>> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super ConcurrentHashMap.KeySetView<String, Boolean>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public ConcurrentHashMap.KeySetView<String, Boolean> apply(String t) {
                return ConcurrentHashMap.newKeySet();
            }
        };
    }
}

