/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.client.ReviveManager;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.compress.Compressor;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornBroadcastException;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.exception.CelebornRuntimeException;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.metrics.source.Role;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.protocol.PushData;
import org.apache.celeborn.common.network.protocol.PushMergedData;
import org.apache.celeborn.common.network.protocol.SerdeVersion;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.protocol.TransportMessagesHelper;
import org.apache.celeborn.common.network.sasl.SaslClientBootstrap;
import org.apache.celeborn.common.network.sasl.SaslCredentials;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.CompressionCodec;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbApplicationMetaRequest;
import org.apache.celeborn.common.protocol.PbChangeLocationPartitionInfo;
import org.apache.celeborn.common.protocol.PbChangeLocationResponse;
import org.apache.celeborn.common.protocol.PbGetShuffleId;
import org.apache.celeborn.common.protocol.PbGetShuffleIdResponse;
import org.apache.celeborn.common.protocol.PbGetStageEnd;
import org.apache.celeborn.common.protocol.PbGetStageEndResponse;
import org.apache.celeborn.common.protocol.PbPushMergedDataSplitPartitionInfo;
import org.apache.celeborn.common.protocol.PbRegisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbReportBarrierStageAttemptFailure;
import org.apache.celeborn.common.protocol.PbReportBarrierStageAttemptFailureResponse;
import org.apache.celeborn.common.protocol.PbReportShuffleFetchFailure;
import org.apache.celeborn.common.protocol.PbReportShuffleFetchFailureResponse;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.ReviveRequest;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.ControlMessages$RegisterMapPartitionTask$;
import org.apache.celeborn.common.protocol.message.ControlMessages$RegisterShuffle$;
import org.apache.celeborn.common.protocol.message.ControlMessages$Revive$;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcSecurityContext;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.ExceptionMaker;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.common.write.DataBatches;
import org.apache.celeborn.common.write.LocationPushFailedBatches;
import org.apache.celeborn.common.write.PushState;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.celeborn.shaded.com.google.common.collect.Lists;
import org.apache.celeborn.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.celeborn.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.celeborn.shaded.io.netty.buffer.Unpooled;
import org.apache.celeborn.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.celeborn.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ClassTag$;

public class ShuffleClientImpl
extends ShuffleClient {
    private static final Logger logger = LoggerFactory.getLogger(ShuffleClientImpl.class);
    protected static final byte PRIMARY_MODE = PartitionLocation.Mode.PRIMARY.mode();
    private static final Random RND = new Random();
    protected final CelebornConf conf;
    private final UserIdentifier userIdentifier;
    private final int registerShuffleMaxRetries;
    private final long registerShuffleRetryWaitMs;
    private final int rpcMaxRetries;
    private final long rpcRetryWait;
    private final int maxReviveTimes;
    private final boolean testRetryRevive;
    private final int pushBufferMaxSize;
    protected final long pushDataTimeout;
    private final RpcEnv rpcEnv;
    protected RpcEndpointRef lifecycleManagerRef;
    private TransportContext transportContext;
    protected TransportClientFactory dataClientFactory;
    protected final int BATCH_HEADER_SIZE = 16;
    protected byte[] extension;
    protected Map<String, Tuple2<Integer, Boolean>> shuffleIdCache = JavaUtils.newConcurrentHashMap();
    final Map<Integer, ConcurrentHashMap<Integer, PartitionLocation>> reducePartitionMap = JavaUtils.newConcurrentHashMap();
    protected final ConcurrentHashMap<Integer, Set<Integer>> mapperEndMap = JavaUtils.newConcurrentHashMap();
    protected final Set<Integer> stageEndShuffleSet = ConcurrentHashMap.newKeySet();
    protected final Map<String, PushState> pushStates = JavaUtils.newConcurrentHashMap();
    private final boolean pushExcludeWorkerOnFailureEnabled;
    private final boolean shuffleCompressionEnabled;
    private final Set<String> pushExcludedWorkers = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<String, Long> fetchExcludedWorkers = JavaUtils.newConcurrentHashMap();
    private boolean pushReplicateEnabled;
    private boolean fetchExcludeWorkerOnFailureEnabled;
    private final ExecutorService pushDataRetryPool;
    private final Map<Integer, Set<Integer>> splitting = JavaUtils.newConcurrentHashMap();
    protected final String appUniqueId;
    private final boolean authEnabled;
    private final TransportConf dataTransportConf;
    private final ThreadLocal<Compressor> compressorThreadLocal = new ThreadLocal<Compressor>(){

        @Override
        protected Compressor initialValue() {
            return Compressor.getCompressor(ShuffleClientImpl.this.conf);
        }
    };
    private final ReviveManager reviveManager;
    private final boolean dataPushFailureTrackingEnabled;
    protected final Map<Integer, Tuple3<ReduceFileGroups, String, Exception>> reduceFileGroupsMap = JavaUtils.newConcurrentHashMap();
    private final TransportMessagesHelper messagesHelper = new TransportMessagesHelper();

    public ShuffleClientImpl(String appUniqueId, CelebornConf conf, UserIdentifier userIdentifier) {
        this.appUniqueId = appUniqueId;
        this.conf = conf;
        this.userIdentifier = userIdentifier;
        this.registerShuffleMaxRetries = conf.clientRegisterShuffleMaxRetry();
        this.registerShuffleRetryWaitMs = conf.clientRegisterShuffleRetryWaitMs();
        this.rpcMaxRetries = conf.clientRpcMaxRetries();
        this.rpcRetryWait = conf.clientRpcRetryWait();
        this.maxReviveTimes = conf.clientPushMaxReviveTimes();
        this.testRetryRevive = conf.testRetryRevive();
        this.pushBufferMaxSize = conf.clientPushBufferMaxSize();
        this.pushExcludeWorkerOnFailureEnabled = conf.clientPushExcludeWorkerOnFailureEnabled();
        this.shuffleCompressionEnabled = !conf.shuffleCompressionCodec().equals((Object)CompressionCodec.NONE);
        this.pushReplicateEnabled = conf.clientPushReplicateEnabled();
        this.fetchExcludeWorkerOnFailureEnabled = conf.clientFetchExcludeWorkerOnFailureEnabled();
        this.pushDataTimeout = conf.clientPushReplicateEnabled() ? conf.pushDataTimeoutMs() * 2L : conf.pushDataTimeoutMs();
        this.authEnabled = conf.authEnabledOnClient();
        this.dataPushFailureTrackingEnabled = conf.clientAdaptiveOptimizeSkewedPartitionReadEnabled();
        this.rpcEnv = RpcEnv.create(RpcNameConstants.SHUFFLE_CLIENT_SYS, "rpc_app_client", Utils.localHostName(conf), 0, conf, Role.CLIENT(), (Option<RpcSecurityContext>)None$.empty());
        String module = "data";
        this.dataTransportConf = Utils.fromCelebornConf(conf, module, conf.networkIoThreads(module));
        this.initDataClientFactoryIfNeeded();
        int pushDataRetryThreads = conf.clientPushRetryThreads();
        this.pushDataRetryPool = ThreadUtils.newDaemonCachedThreadPool("celeborn-retry-sender", pushDataRetryThreads, 60);
        this.reviveManager = new ReviveManager(this, conf);
        logger.info("Created ShuffleClientImpl, appUniqueId: {}", (Object)appUniqueId);
    }

    protected List<TransportClientBootstrap> createBootstraps() {
        if (this.authEnabled && null != this.lifecycleManagerRef) {
            PbApplicationMetaRequest pbApplicationMetaRequest = PbApplicationMetaRequest.newBuilder().setAppId(this.appUniqueId).build();
            PbApplicationMeta pbApplicationMeta = (PbApplicationMeta)this.lifecycleManagerRef.askSync(pbApplicationMetaRequest, this.conf.clientRpcRegisterShuffleAskTimeout(), ClassTag$.MODULE$.apply(PbApplicationMeta.class));
            ArrayList<SaslClientBootstrap> bootstraps = Lists.newArrayList();
            bootstraps.add(new SaslClientBootstrap(this.dataTransportConf, this.appUniqueId, new SaslCredentials(this.appUniqueId, pbApplicationMeta.getSecret())));
            return Collections.unmodifiableList(bootstraps);
        }
        return Collections.emptyList();
    }

    private void initDataClientFactoryIfNeeded() {
        if (this.dataClientFactory != null) {
            return;
        }
        this.transportContext = new TransportContext(this.dataTransportConf, new BaseMessageHandler(), this.conf.clientCloseIdleConnections());
        if (!this.authEnabled) {
            logger.info("Initializing data client factory for {}.", (Object)this.appUniqueId);
            this.dataClientFactory = this.transportContext.createClientFactory();
        } else if (this.lifecycleManagerRef != null) {
            logger.info("Initializing data client factory for secured {}.", (Object)this.appUniqueId);
            List<TransportClientBootstrap> bootstraps = this.createBootstraps();
            this.dataClientFactory = this.transportContext.createClientFactory(bootstraps);
        }
    }

    private boolean isPushTargetWorkerExcluded(PartitionLocation location, RpcResponseCallback wrappedCallback) {
        if (this.pushExcludedWorkers.contains(location.hostAndPushPort())) {
            wrappedCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_PRIMARY_WORKER_EXCLUDED));
            return true;
        }
        if (location.hasPeer() && this.pushExcludedWorkers.contains(location.getPeer().hostAndPushPort())) {
            wrappedCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_REPLICA_WORKER_EXCLUDED));
            return true;
        }
        return false;
    }

    private void submitRetryPushData(int shuffleId, byte[] body, int batchId, PushDataRpcResponseCallback pushDataRpcResponseCallback, PushState pushState, ReviveRequest request, int remainReviveTimes, long dueTime) {
        block12: {
            int mapId = request.mapId;
            int attemptId = request.attemptId;
            PartitionLocation loc = request.loc;
            StatusCode cause = request.cause;
            int partitionId = loc.getId();
            long reviveWaitTime = dueTime - System.currentTimeMillis();
            long delta = 50L;
            long accumulatedTime = 0L;
            while (request.reviveStatus == StatusCode.REVIVE_INITIALIZED.getValue() && accumulatedTime <= reviveWaitTime) {
                try {
                    Thread.sleep(50L);
                    accumulatedTime += 50L;
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for Revive result!");
                    Thread.currentThread().interrupt();
                }
            }
            if (this.mapperEnded(shuffleId, mapId)) {
                logger.debug("Revive for push data success, but the mapper already ended for shuffle {} map {} attempt {} partition {} batch {} location {}.", new Object[]{shuffleId, mapId, attemptId, partitionId, batchId, loc});
                pushState.removeBatch(batchId, loc.hostAndPushPort());
            } else if (request.reviveStatus != StatusCode.SUCCESS.getValue()) {
                pushDataRpcResponseCallback.onFailure(new CelebornIOException((Object)((Object)cause) + " then revive but " + (Object)((Object)StatusCode.REVIVE_FAILED) + ", revive status " + request.reviveStatus + "(" + (Object)((Object)StatusCode.fromValue(request.reviveStatus)) + "), old location: " + request.loc));
            } else {
                PartitionLocation newLoc = this.reducePartitionMap.get(shuffleId).get(partitionId);
                logger.info("Revive for push data success, new location for shuffle {} map {} attempt {} partition {} batch {} is location {}.", new Object[]{shuffleId, mapId, attemptId, partitionId, batchId, newLoc});
                pushDataRpcResponseCallback.updateLatestPartition(newLoc);
                try {
                    if (this.isPushTargetWorkerExcluded(newLoc, pushDataRpcResponseCallback)) break block12;
                    if (!this.testRetryRevive || remainReviveTimes < 1) {
                        assert (this.dataClientFactory != null);
                        TransportClient client = this.dataClientFactory.createClient(newLoc.getHost(), newLoc.getPushPort(), partitionId);
                        NettyManagedBuffer newBuffer = new NettyManagedBuffer(Unpooled.wrappedBuffer(body));
                        String shuffleKey = Utils.makeShuffleKey(this.appUniqueId, shuffleId);
                        PushData newPushData = new PushData(PRIMARY_MODE, shuffleKey, newLoc.getUniqueId(), newBuffer);
                        client.pushData(newPushData, this.pushDataTimeout, pushDataRpcResponseCallback);
                        break block12;
                    }
                    throw new RuntimeException("Mock push data submit retry failed. remainReviveTimes = " + remainReviveTimes + ".");
                }
                catch (Exception e) {
                    logger.error("Exception raised while pushing data for shuffle {} map {} attempt {} partition {} batch {} location {}.", new Object[]{shuffleId, mapId, attemptId, partitionId, batchId, newLoc, e});
                    if (e instanceof InterruptedException) {
                        pushDataRpcResponseCallback.onFailure(e);
                    }
                    pushDataRpcResponseCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY, (Throwable)e));
                }
            }
        }
    }

    public ReviveRequest[] addAndGetReviveRequests(int shuffleId, int mapId, int attemptId, ArrayList<DataBatches.DataBatch> batches, StatusCode cause) {
        ReviveRequest[] reviveRequests = new ReviveRequest[batches.size()];
        for (int i = 0; i < batches.size(); ++i) {
            DataBatches.DataBatch batch = batches.get(i);
            PartitionLocation loc = batch.loc;
            ReviveRequest reviveRequest = new ReviveRequest(shuffleId, mapId, attemptId, loc.getId(), loc.getEpoch(), loc, cause);
            this.reviveManager.addRequest(reviveRequest);
            reviveRequests[i] = reviveRequest;
        }
        return reviveRequests;
    }

    private void submitRetryPushMergedData(PushState pushState, int shuffleId, int mapId, int attemptId, ArrayList<DataBatches.DataBatch> batches, StatusCode cause, Integer oldGroupedBatchId, ReviveRequest[] reviveRequests, int remainReviveTimes, long reviveResponseDueTime) {
        DataBatches newDataBatches;
        HashMap<Pair, DataBatches> newDataBatchesMap = new HashMap<Pair, DataBatches>();
        ArrayList<DataBatches.DataBatch> reviveFailedBatchesMap = new ArrayList<DataBatches.DataBatch>();
        long reviveWaitTime = reviveResponseDueTime - System.currentTimeMillis();
        long delta = 50L;
        long accumulatedTime = 0L;
        int index = 0;
        while (index < reviveRequests.length && accumulatedTime <= reviveWaitTime) {
            ReviveRequest request = reviveRequests[index];
            DataBatches.DataBatch batch = batches.get(index);
            if (request.reviveStatus != StatusCode.REVIVE_INITIALIZED.getValue()) {
                if (this.mapperEnded(shuffleId, mapId)) {
                    logger.debug("Revive for push merged data success, but the mapper already ended for shuffle {} map {} attempt {} partition {} batch {}.", new Object[]{shuffleId, mapId, attemptId, request.partitionId, oldGroupedBatchId});
                } else if (request.reviveStatus == StatusCode.SUCCESS.getValue()) {
                    PartitionLocation newLoc = this.reducePartitionMap.get(shuffleId).get(request.partitionId);
                    newDataBatches = newDataBatchesMap.computeIfAbsent(this.genAddressPair(newLoc), s -> new DataBatches());
                    newDataBatches.addDataBatch(newLoc, batch.batchId, batch.body);
                } else if (remainReviveTimes > 0) {
                    reviveFailedBatchesMap.add(batch);
                } else {
                    String errorMsg = String.format("Revive failed while pushing merged for shuffle %d map %d attempt %d partition %d batch %d location %s.", shuffleId, mapId, attemptId, request.partitionId, oldGroupedBatchId, batch.loc);
                    pushState.exception.compareAndSet(null, new CelebornIOException(errorMsg, (Throwable)new CelebornIOException((Object)((Object)cause) + " then revive but " + request.reviveStatus + "(" + (Object)((Object)StatusCode.fromValue(request.reviveStatus)) + ")")));
                    return;
                }
                ++index;
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for Revive result!");
                Thread.currentThread().interrupt();
            }
            accumulatedTime += 50L;
        }
        for (int i = index; i < reviveRequests.length; ++i) {
            ReviveRequest request = reviveRequests[index];
            DataBatches.DataBatch batch = batches.get(i);
            if (remainReviveTimes <= 0) {
                String errorMsg = String.format("Revive failed while pushing merged for shuffle %d map %d attempt %d partition %d batch %d location %s.", shuffleId, mapId, attemptId, request.partitionId, oldGroupedBatchId, batch.loc);
                pushState.exception.compareAndSet(null, new CelebornIOException(errorMsg, (Throwable)new CelebornIOException((Object)((Object)cause) + " then revive but " + request.reviveStatus + "(" + (Object)((Object)StatusCode.fromValue(request.reviveStatus)) + ")")));
                return;
            }
            reviveFailedBatchesMap.add(batch);
        }
        for (Map.Entry entry : newDataBatchesMap.entrySet()) {
            Pair addressPair = (Pair)entry.getKey();
            newDataBatches = (DataBatches)entry.getValue();
            this.doPushMergedData(addressPair, shuffleId, mapId, attemptId, newDataBatches.requireBatches(), pushState, remainReviveTimes);
        }
        if (reviveFailedBatchesMap.isEmpty()) {
            pushState.removeBatch(oldGroupedBatchId, batches.get((int)0).loc.hostAndPushPort());
        } else {
            ReviveRequest[] requests = this.addAndGetReviveRequests(shuffleId, mapId, attemptId, reviveFailedBatchesMap, cause);
            this.pushDataRetryPool.submit(() -> this.submitRetryPushMergedData(pushState, shuffleId, mapId, attemptId, reviveFailedBatchesMap, cause, oldGroupedBatchId, requests, remainReviveTimes - 1, System.currentTimeMillis() + this.conf.clientRpcRequestPartitionLocationAskTimeout().duration().toMillis()));
        }
    }

    private Pair<String, String> genAddressPair(PartitionLocation loc) {
        if (loc.hasPeer()) {
            return Pair.of(loc.hostAndPushPort(), loc.getPeer().hostAndPushPort());
        }
        return Pair.of(loc.hostAndPushPort(), null);
    }

    private ConcurrentHashMap<Integer, PartitionLocation> registerShuffle(int shuffleId, int numMappers, int numPartitions) throws CelebornIOException {
        return this.registerShuffleInternal(shuffleId, numMappers, numPartitions, () -> (PbRegisterShuffleResponse)this.lifecycleManagerRef.askSync(ControlMessages$RegisterShuffle$.MODULE$.apply(shuffleId, numMappers, numPartitions), this.conf.clientRpcRegisterShuffleAskTimeout(), this.rpcMaxRetries, this.rpcRetryWait, ClassTag$.MODULE$.apply(PbRegisterShuffleResponse.class)));
    }

    @Override
    public PartitionLocation registerMapPartitionTask(int shuffleId, int numMappers, int mapId, int attemptId, int partitionId) throws IOException {
        return this.registerMapPartitionTask(shuffleId, numMappers, mapId, attemptId, partitionId, false);
    }

    public PartitionLocation registerMapPartitionTask(int shuffleId, int numMappers, int mapId, int attemptId, int partitionId, boolean isSegmentGranularityVisible) throws IOException {
        logger.info("Register MapPartition task for shuffle {} map {} attempt {} partition {} with {} mapper.", new Object[]{shuffleId, mapId, attemptId, partitionId, numMappers});
        ConcurrentHashMap<Integer, PartitionLocation> partitionLocationMap = this.registerShuffleInternal(shuffleId, numMappers, numMappers, () -> (PbRegisterShuffleResponse)this.lifecycleManagerRef.askSync(ControlMessages$RegisterMapPartitionTask$.MODULE$.apply(shuffleId, numMappers, mapId, attemptId, partitionId, isSegmentGranularityVisible), this.conf.clientRpcRegisterShuffleAskTimeout(), ClassTag$.MODULE$.apply(PbRegisterShuffleResponse.class)));
        return partitionLocationMap.get(partitionId);
    }

    @Override
    public ConcurrentHashMap<Integer, PartitionLocation> getPartitionLocation(int shuffleId, int numMappers, int numPartitions) throws CelebornIOException {
        try {
            return this.reducePartitionMap.computeIfAbsent(shuffleId, id -> {
                try {
                    return this.registerShuffle(shuffleId, numMappers, numPartitions);
                }
                catch (CelebornIOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CelebornIOException) {
                throw (CelebornIOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public PushState getPushState(String mapKey) {
        return this.pushStates.computeIfAbsent(mapKey, s -> new PushState(this.conf));
    }

    @Override
    public Tuple2<Integer, Boolean> getShuffleId(int appShuffleId, String appShuffleIdentifier, boolean isWriter, boolean isBarrierStage) {
        return this.shuffleIdCache.computeIfAbsent(appShuffleIdentifier, id -> {
            PbGetShuffleId pbGetShuffleId = PbGetShuffleId.newBuilder().setAppShuffleId(appShuffleId).setAppShuffleIdentifier(appShuffleIdentifier).setIsShuffleWriter(isWriter).setIsBarrierStage(isBarrierStage).build();
            PbGetShuffleIdResponse pbGetShuffleIdResponse = (PbGetShuffleIdResponse)this.lifecycleManagerRef.askSync(pbGetShuffleId, this.conf.clientRpcRegisterShuffleAskTimeout(), ClassTag$.MODULE$.apply(PbGetShuffleIdResponse.class));
            return Tuple2.apply((Object)pbGetShuffleIdResponse.getShuffleId(), (Object)pbGetShuffleIdResponse.getSuccess());
        });
    }

    @Override
    public boolean reportShuffleFetchFailure(int appShuffleId, int shuffleId, long taskId) {
        PbReportShuffleFetchFailure pbReportShuffleFetchFailure = PbReportShuffleFetchFailure.newBuilder().setAppShuffleId(appShuffleId).setShuffleId(shuffleId).setTaskId(taskId).build();
        PbReportShuffleFetchFailureResponse pbReportShuffleFetchFailureResponse = (PbReportShuffleFetchFailureResponse)this.lifecycleManagerRef.askSync(pbReportShuffleFetchFailure, this.conf.clientRpcRegisterShuffleAskTimeout(), ClassTag$.MODULE$.apply(PbReportShuffleFetchFailureResponse.class));
        return pbReportShuffleFetchFailureResponse.getSuccess();
    }

    @Override
    public boolean reportBarrierTaskFailure(int appShuffleId, String appShuffleIdentifier) {
        PbReportBarrierStageAttemptFailure pbReportBarrierStageAttemptFailure = PbReportBarrierStageAttemptFailure.newBuilder().setAppShuffleId(appShuffleId).setAppShuffleIdentifier(appShuffleIdentifier).build();
        PbReportBarrierStageAttemptFailureResponse pbReportBarrierStageAttemptFailureResponse = (PbReportBarrierStageAttemptFailureResponse)this.lifecycleManagerRef.askSync(pbReportBarrierStageAttemptFailure, this.conf.clientRpcRegisterShuffleAskTimeout(), ClassTag$.MODULE$.apply(PbReportBarrierStageAttemptFailureResponse.class));
        return pbReportBarrierStageAttemptFailureResponse.getSuccess();
    }

    private ConcurrentHashMap<Integer, PartitionLocation> registerShuffleInternal(int shuffleId, int numMappers, int numPartitions, Callable<PbRegisterShuffleResponse> callable) throws CelebornIOException {
        StatusCode lastFailedStatusCode = null;
        for (int numRetries = this.registerShuffleMaxRetries; numRetries > 0; --numRetries) {
            try {
                PbRegisterShuffleResponse response = callable.call();
                StatusCode respStatus = StatusCode.fromValue(response.getStatus());
                if (StatusCode.SUCCESS.equals((Object)respStatus)) {
                    ConcurrentHashMap<Integer, PartitionLocation> result = JavaUtils.newConcurrentHashMap();
                    Tuple2<List<PartitionLocation>, List<PartitionLocation>> locations = PbSerDeUtils.fromPbPackedPartitionLocationsPair(response.getPackedPartitionLocationsPair());
                    for (PartitionLocation location : (List)locations._1) {
                        this.pushExcludedWorkers.remove(location.hostAndPushPort());
                        if (location.hasPeer()) {
                            this.pushExcludedWorkers.remove(location.getPeer().hostAndPushPort());
                        }
                        result.put(location.getId(), location);
                    }
                    return result;
                }
                if (StatusCode.SLOT_NOT_AVAILABLE.equals((Object)respStatus)) {
                    lastFailedStatusCode = respStatus;
                    logger.error("LifecycleManager request slots return {}, retry again, remain retry times {}.", (Object)StatusCode.SLOT_NOT_AVAILABLE, (Object)(numRetries - 1));
                } else if (StatusCode.RESERVE_SLOTS_FAILED.equals((Object)respStatus)) {
                    lastFailedStatusCode = respStatus;
                    logger.error("LifecycleManager request slots return {}, retry again, remain retry times {}.", (Object)StatusCode.RESERVE_SLOTS_FAILED, (Object)(numRetries - 1));
                } else {
                    lastFailedStatusCode = respStatus;
                    logger.error("LifecycleManager request slots return {}, retry again, remain retry times {}.", (Object)StatusCode.REQUEST_FAILED, (Object)(numRetries - 1));
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                logger.error("Exception raised while registering shuffle {} with {} mapper and {} partitions.", new Object[]{shuffleId, numMappers, numPartitions, e});
                throw new CelebornIOException("Register shuffle failed for shuffle " + shuffleId + ".", (Throwable)e);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.registerShuffleRetryWaitMs);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new CelebornIOException("Register shuffle failed for shuffle " + shuffleId + ", reason: " + lastFailedStatusCode);
    }

    protected void limitMaxInFlight(String mapKey, PushState pushState, String hostAndPushPort) throws IOException {
        boolean reachLimit = pushState.limitMaxInFlight(hostAndPushPort);
        if (reachLimit) {
            throw new CelebornIOException(String.format("Waiting timeout for task %s while limiting max in-flight requests to %s", mapKey, hostAndPushPort), (Throwable)pushState.exception.get());
        }
    }

    protected void limitZeroInFlight(String mapKey, PushState pushState) throws IOException {
        boolean reachLimit = pushState.limitZeroInFlight();
        if (reachLimit) {
            throw new CelebornIOException(String.format("Waiting timeout for task %s while limiting zero in-flight requests", mapKey), (Throwable)pushState.exception.get());
        }
    }

    boolean newerPartitionLocationExists(Map<Integer, PartitionLocation> shuffleMap, int partitionId, int epoch, boolean wait) {
        PartitionLocation currentLocation = shuffleMap.get(partitionId);
        if (currentLocation != null && currentLocation.getEpoch() > epoch) {
            return true;
        }
        if (wait) {
            long sleepTimeMs = RND.nextInt(50);
            if (sleepTimeMs > 30L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(sleepTimeMs);
                }
                catch (InterruptedException e) {
                    logger.error("Waiting revived location was interrupted.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            return (currentLocation = shuffleMap.get(partitionId)) != null && currentLocation.getEpoch() > epoch;
        }
        return false;
    }

    void excludeWorkerByCause(StatusCode cause, PartitionLocation oldLocation) {
        if (this.pushExcludeWorkerOnFailureEnabled && oldLocation != null) {
            switch (cause) {
                case PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY: 
                case PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY: 
                case PUSH_DATA_TIMEOUT_PRIMARY: {
                    this.pushExcludedWorkers.add(oldLocation.hostAndPushPort());
                    break;
                }
                case PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA: 
                case PUSH_DATA_CONNECTION_EXCEPTION_REPLICA: 
                case PUSH_DATA_TIMEOUT_REPLICA: {
                    this.pushExcludedWorkers.add(oldLocation.getPeer().hostAndPushPort());
                    break;
                }
            }
        }
    }

    private boolean revive(int shuffleId, int mapId, int attemptId, int partitionId, int epoch, PartitionLocation oldLocation, StatusCode cause) {
        this.excludeWorkerByCause(cause, oldLocation);
        HashSet<Integer> mapIds = new HashSet<Integer>();
        mapIds.add(mapId);
        ArrayList<ReviveRequest> requests = new ArrayList<ReviveRequest>();
        ReviveRequest req = new ReviveRequest(shuffleId, mapId, attemptId, partitionId, epoch, oldLocation, cause);
        requests.add(req);
        Map<Integer, Integer> results = this.reviveBatch(shuffleId, mapIds, requests);
        if (this.mapperEnded(shuffleId, mapId)) {
            logger.debug("Revive success, but the mapper ended for shuffle {} map {} attempt {} partition {}, just return true(Assume revive successfully).", new Object[]{shuffleId, mapId, attemptId, partitionId});
            return true;
        }
        return results != null && results.containsKey(partitionId) && results.get(partitionId).intValue() == StatusCode.SUCCESS.getValue();
    }

    Map<Integer, Integer> reviveBatch(int shuffleId, Set<Integer> mapIds, Collection<ReviveRequest> requests) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        ConcurrentHashMap<Integer, PartitionLocation> partitionLocationMap = this.reducePartitionMap.get(shuffleId);
        HashMap<Integer, PartitionLocation> oldLocMap = new HashMap<Integer, PartitionLocation>();
        for (ReviveRequest req2 : requests) {
            oldLocMap.put(req2.partitionId, req2.loc);
        }
        try {
            int i;
            PbChangeLocationResponse response = (PbChangeLocationResponse)this.lifecycleManagerRef.askSync(ControlMessages$Revive$.MODULE$.apply(shuffleId, mapIds, requests), this.conf.clientRpcRequestPartitionLocationAskTimeout(), ClassTag$.MODULE$.apply(PbChangeLocationResponse.class));
            for (i = 0; i < response.getEndedMapIdCount(); ++i) {
                int mapId = response.getEndedMapId(i);
                this.mapperEndMap.computeIfAbsent(shuffleId, id -> ConcurrentHashMap.newKeySet()).add(mapId);
            }
            for (i = 0; i < response.getPartitionInfoCount(); ++i) {
                PbChangeLocationPartitionInfo partitionInfo = response.getPartitionInfo(i);
                int partitionId = partitionInfo.getPartitionId();
                int statusCode = partitionInfo.getStatus();
                if (partitionInfo.getOldAvailable()) {
                    PartitionLocation oldLoc = (PartitionLocation)oldLocMap.get(partitionId);
                    this.pushExcludedWorkers.remove(oldLoc.hostAndPushPort());
                }
                if (StatusCode.SUCCESS.getValue() == statusCode) {
                    PartitionLocation loc = PbSerDeUtils.fromPbPartitionLocation(partitionInfo.getPartition());
                    partitionLocationMap.put(partitionId, loc);
                    this.pushExcludedWorkers.remove(loc.hostAndPushPort());
                    if (loc.hasPeer()) {
                        this.pushExcludedWorkers.remove(loc.getPeer().hostAndPushPort());
                    }
                } else {
                    if (StatusCode.STAGE_ENDED.getValue() == statusCode) {
                        this.stageEndShuffleSet.add(shuffleId);
                        return results;
                    }
                    if (StatusCode.SHUFFLE_NOT_REGISTERED.getValue() == statusCode) {
                        logger.error("SHUFFLE_NOT_REGISTERED!");
                        return null;
                    }
                }
                results.put(partitionId, statusCode);
            }
            return results;
        }
        catch (Exception e) {
            StringBuilder partitionIds = new StringBuilder();
            StringBuilder epochs = new StringBuilder();
            requests.forEach(req -> {
                partitionIds.append(req.partitionId).append(",");
                epochs.append(req.epoch).append(",");
            });
            logger.error("Exception raised while reviving for shuffle {} partitionIds {} epochs {}.", new Object[]{shuffleId, partitionIds, epochs, e});
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return null;
        }
    }

    public int pushOrMergeData(final int shuffleId, final int mapId, final int attemptId, final int partitionId, byte[] data, int offset, int length, int numMappers, int numPartitions, boolean doPush, boolean skipCompress) throws IOException {
        byte[] body;
        block15: {
            String mapKey = Utils.makeMapKey(shuffleId, mapId, attemptId);
            if (this.mapperEnded(shuffleId, mapId)) {
                logger.debug("Push or merge data ignored because mapper already ended for shuffle {} map {} attempt {} partition {}.", new Object[]{shuffleId, mapId, attemptId, partitionId});
                PushState pushState = this.pushStates.get(mapKey);
                if (pushState != null) {
                    pushState.cleanup();
                }
                return 0;
            }
            ConcurrentHashMap<Integer, PartitionLocation> map = this.getPartitionLocation(shuffleId, numMappers, numPartitions);
            if (!map.containsKey(partitionId) && !this.revive(shuffleId, mapId, attemptId, partitionId, -1, null, StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_PRIMARY)) {
                throw new CelebornIOException(String.format("Revive for shuffle %s partition %d failed.", shuffleId, partitionId));
            }
            if (this.mapperEnded(shuffleId, mapId)) {
                logger.debug("Push or merge data ignored because mapper already ended for shuffle {} map {} attempt {} partition {}.", new Object[]{shuffleId, mapId, attemptId, partitionId});
                PushState pushState = this.pushStates.get(mapKey);
                if (pushState != null) {
                    pushState.cleanup();
                }
                return 0;
            }
            final PartitionLocation loc = map.get(partitionId);
            if (loc == null) {
                throw new CelebornIOException(String.format("Partition location for shuffle %s partition %d is NULL!", shuffleId, partitionId));
            }
            final PushState pushState = this.getPushState(mapKey);
            final int nextBatchId = pushState.nextBatchId();
            if (this.shuffleCompressionEnabled && !skipCompress) {
                Compressor compressor = this.compressorThreadLocal.get();
                compressor.compress(data, offset, length);
                data = compressor.getCompressedBuffer();
                offset = 0;
                length = compressor.getCompressedTotalSize();
            }
            body = new byte[16 + length];
            Platform.putInt(body, Platform.BYTE_ARRAY_OFFSET, mapId);
            Platform.putInt(body, Platform.BYTE_ARRAY_OFFSET + 4, attemptId);
            Platform.putInt(body, Platform.BYTE_ARRAY_OFFSET + 8, nextBatchId);
            Platform.putInt(body, Platform.BYTE_ARRAY_OFFSET + 12, length);
            System.arraycopy(data, offset, body, 16, length);
            if (doPush) {
                this.limitMaxInFlight(mapKey, pushState, loc.hostAndPushPort());
                pushState.addBatch(nextBatchId, loc.hostAndPushPort());
                NettyManagedBuffer buffer = new NettyManagedBuffer(Unpooled.wrappedBuffer(body));
                String shuffleKey = Utils.makeShuffleKey(this.appUniqueId, shuffleId);
                PushData pushData = new PushData(PRIMARY_MODE, shuffleKey, loc.getUniqueId(), buffer);
                final RpcResponseCallback callback = new RpcResponseCallback(){

                    @Override
                    public void onSuccess(ByteBuffer response) {
                        if (response.remaining() > 0 && response.get() == StatusCode.MAP_ENDED.getValue()) {
                            ShuffleClientImpl.this.mapperEndMap.computeIfAbsent(shuffleId, id -> ConcurrentHashMap.newKeySet()).add(mapId);
                        }
                        logger.debug("Push data to {} success for shuffle {} map {} attempt {} partition {} batch {}.", new Object[]{loc.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId});
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        String errorMsg = String.format("Push data to %s failed for shuffle %d map %d attempt %d partition %d batch %d.", loc, shuffleId, mapId, attemptId, partitionId, nextBatchId);
                        pushState.exception.compareAndSet(null, new CelebornIOException(errorMsg, e));
                    }
                };
                PushDataRpcResponseCallback wrappedCallback = new PushDataRpcResponseCallback(){
                    int remainReviveTimes;
                    PartitionLocation latest;
                    {
                        this.remainReviveTimes = ShuffleClientImpl.this.maxReviveTimes;
                        this.latest = loc;
                    }

                    @Override
                    public void updateLatestPartition(PartitionLocation newloc) {
                        pushState.addBatch(nextBatchId, newloc.hostAndPushPort());
                        pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                        this.latest = newloc;
                    }

                    @Override
                    public void onSuccess(ByteBuffer response) {
                        if (response.remaining() > 0) {
                            byte reason = response.get();
                            if (reason == StatusCode.SOFT_SPLIT.getValue()) {
                                logger.debug("Push data to {} soft split required for shuffle {} map {} attempt {} partition {} batch {}.", new Object[]{this.latest.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId});
                                if (!ShuffleClientImpl.this.newerPartitionLocationExists((Map<Integer, PartitionLocation>)ShuffleClientImpl.this.reducePartitionMap.get(shuffleId), partitionId, this.latest.getEpoch(), false)) {
                                    ReviveRequest reviveRequest = new ReviveRequest(shuffleId, mapId, attemptId, partitionId, this.latest.getEpoch(), this.latest, StatusCode.SOFT_SPLIT);
                                    ShuffleClientImpl.this.reviveManager.addRequest(reviveRequest);
                                }
                                pushState.onSuccess(this.latest.hostAndPushPort());
                                pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                                callback.onSuccess(response);
                            } else if (reason == StatusCode.HARD_SPLIT.getValue()) {
                                logger.debug("Push data to {} hard split required for shuffle {} map {} attempt {} partition {} batch {}.", new Object[]{this.latest.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId});
                                if (ShuffleClientImpl.this.dataPushFailureTrackingEnabled && ShuffleClientImpl.this.pushReplicateEnabled) {
                                    pushState.recordFailedBatch(this.latest.getUniqueId(), mapId, attemptId, nextBatchId);
                                }
                                ReviveRequest reviveRequest = new ReviveRequest(shuffleId, mapId, attemptId, partitionId, this.latest.getEpoch(), this.latest, StatusCode.HARD_SPLIT);
                                ShuffleClientImpl.this.reviveManager.addRequest(reviveRequest);
                                long dueTime = System.currentTimeMillis() + ShuffleClientImpl.this.conf.clientRpcRequestPartitionLocationAskTimeout().duration().toMillis();
                                ShuffleClientImpl.this.pushDataRetryPool.submit(() -> ShuffleClientImpl.this.submitRetryPushData(shuffleId, body, nextBatchId, this, pushState, reviveRequest, this.remainReviveTimes, dueTime));
                            } else if (reason == StatusCode.PUSH_DATA_SUCCESS_PRIMARY_CONGESTED.getValue()) {
                                logger.debug("Push data to {} primary congestion required for shuffle {} map {} attempt {} partition {} batch {}.", new Object[]{this.latest.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId});
                                pushState.onCongestControl(this.latest.hostAndPushPort());
                                pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                                callback.onSuccess(response);
                            } else if (reason == StatusCode.PUSH_DATA_SUCCESS_REPLICA_CONGESTED.getValue()) {
                                logger.debug("Push data to {} replica congestion required for shuffle {} map {} attempt {} partition {} batch {}.", new Object[]{this.latest.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId});
                                pushState.onCongestControl(this.latest.hostAndPushPort());
                                pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                                callback.onSuccess(response);
                            } else {
                                response.rewind();
                                pushState.onSuccess(this.latest.hostAndPushPort());
                                pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                                callback.onSuccess(response);
                            }
                        } else {
                            pushState.onSuccess(this.latest.hostAndPushPort());
                            pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                            callback.onSuccess(response);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if (ShuffleClientImpl.this.dataPushFailureTrackingEnabled) {
                            pushState.recordFailedBatch(this.latest.getUniqueId(), mapId, attemptId, nextBatchId);
                        }
                        if (pushState.exception.get() != null) {
                            return;
                        }
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            callback.onFailure(e);
                            return;
                        }
                        StatusCode cause = ShuffleClientImpl.this.getPushDataFailCause(e.getMessage());
                        if (this.remainReviveTimes <= 0) {
                            if (e instanceof CelebornIOException) {
                                callback.onFailure(e);
                            } else {
                                callback.onFailure(new CelebornIOException(cause, e));
                            }
                            return;
                        }
                        logger.error("Push data to {} failed for shuffle {} map {} attempt {} partition {} batch {}, remain revive times {}.", new Object[]{this.latest.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId, this.remainReviveTimes, e});
                        if (!ShuffleClientImpl.this.mapperEnded(shuffleId, mapId)) {
                            --this.remainReviveTimes;
                            ReviveRequest reviveRequest = new ReviveRequest(shuffleId, mapId, attemptId, partitionId, this.latest.getEpoch(), this.latest, cause);
                            ShuffleClientImpl.this.reviveManager.addRequest(reviveRequest);
                            long dueTime = System.currentTimeMillis() + ShuffleClientImpl.this.conf.clientRpcRequestPartitionLocationAskTimeout().duration().toMillis();
                            ShuffleClientImpl.this.pushDataRetryPool.submit(() -> ShuffleClientImpl.this.submitRetryPushData(shuffleId, body, nextBatchId, this, pushState, reviveRequest, this.remainReviveTimes, dueTime));
                        } else {
                            pushState.removeBatch(nextBatchId, this.latest.hostAndPushPort());
                            logger.info("Push data to {} failed but mapper already ended for shuffle {} map {} attempt {} partition {} batch {}, remain revive times {}.", new Object[]{this.latest.hostAndPushPort(), shuffleId, mapId, attemptId, partitionId, nextBatchId, this.remainReviveTimes});
                        }
                    }
                };
                try {
                    if (this.isPushTargetWorkerExcluded(loc, wrappedCallback)) break block15;
                    if (!this.testRetryRevive) {
                        assert (this.dataClientFactory != null);
                        TransportClient client = this.dataClientFactory.createClient(loc.getHost(), loc.getPushPort(), partitionId);
                        client.pushData(pushData, this.pushDataTimeout, wrappedCallback);
                        break block15;
                    }
                    wrappedCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_PRIMARY, (Throwable)new RuntimeException("Mock push data first time failed.")));
                }
                catch (Exception e) {
                    logger.error("Exception raised while pushing data for shuffle {} map {} attempt {} partition {} batch {} location {}.", new Object[]{shuffleId, mapId, attemptId, partitionId, nextBatchId, loc, e});
                    if (e instanceof InterruptedException) {
                        wrappedCallback.onFailure(e);
                        break block15;
                    }
                    wrappedCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY, (Throwable)e));
                }
            } else {
                logger.debug("Merge batch {}.", (Object)nextBatchId);
                Pair<String, String> addressPair = this.genAddressPair(loc);
                boolean shouldPush = pushState.addBatchData(addressPair, loc, nextBatchId, body);
                if (shouldPush) {
                    this.limitMaxInFlight(mapKey, pushState, loc.hostAndPushPort());
                    DataBatches dataBatches = pushState.takeDataBatches(addressPair);
                    this.doPushMergedData(addressPair, shuffleId, mapId, attemptId, dataBatches.requireBatches(), pushState, this.maxReviveTimes);
                }
            }
        }
        return body.length;
    }

    @Override
    public int pushData(int shuffleId, int mapId, int attemptId, int partitionId, byte[] data, int offset, int length, int numMappers, int numPartitions) throws IOException {
        return this.pushOrMergeData(shuffleId, mapId, attemptId, partitionId, data, offset, length, numMappers, numPartitions, true, false);
    }

    @Override
    public void prepareForMergeData(int shuffleId, int mapId, int attemptId) throws IOException {
        String mapKey = Utils.makeMapKey(shuffleId, mapId, attemptId);
        PushState pushState = this.pushStates.get(mapKey);
        if (pushState != null) {
            this.limitZeroInFlight(mapKey, pushState);
        }
    }

    @Override
    public int mergeData(int shuffleId, int mapId, int attemptId, int partitionId, byte[] data, int offset, int length, int numMappers, int numPartitions) throws IOException {
        return this.pushOrMergeData(shuffleId, mapId, attemptId, partitionId, data, offset, length, numMappers, numPartitions, false, false);
    }

    @Override
    public void pushMergedData(int shuffleId, int mapId, int attemptId) throws IOException {
        String mapKey = Utils.makeMapKey(shuffleId, mapId, attemptId);
        PushState pushState = this.pushStates.get(mapKey);
        if (pushState == null) {
            return;
        }
        ArrayList<Map.Entry<Pair<String, String>, DataBatches>> batchesArr = new ArrayList<Map.Entry<Pair<String, String>, DataBatches>>(pushState.batchesMap.entrySet());
        while (!batchesArr.isEmpty()) {
            Map.Entry<Pair<String, String>, DataBatches> entry = batchesArr.get(RND.nextInt(batchesArr.size()));
            this.limitMaxInFlight(mapKey, pushState, entry.getKey().getLeft());
            ArrayList<DataBatches.DataBatch> batches = entry.getValue().requireBatches(this.pushBufferMaxSize);
            if (entry.getValue().getTotalSize() == 0) {
                batchesArr.remove(entry);
            }
            this.doPushMergedData(entry.getKey(), shuffleId, mapId, attemptId, batches, pushState, this.maxReviveTimes);
        }
    }

    private void doPushMergedData(final Pair<String, String> addressPair, final int shuffleId, final int mapId, final int attemptId, final ArrayList<DataBatches.DataBatch> batches, PushState pushState, int remainReviveTimes) {
        String hostPort = addressPair.getLeft();
        String[] hostPortArr = Utils.parseColonSeparatedHostPorts(hostPort, 1);
        String host = hostPortArr[0];
        int port = Integer.parseInt(hostPortArr[1]);
        int groupedBatchId = pushState.nextBatchId();
        pushState.addBatch(groupedBatchId, hostPort);
        int numBatches = batches.size();
        Object[] partitionIds = new Integer[numBatches];
        String[] partitionUniqueIds = new String[numBatches];
        int[] offsets = new int[numBatches];
        int[] batchIds = new int[numBatches];
        int currentSize = 0;
        CompositeByteBuf byteBuf = Unpooled.compositeBuffer();
        for (int i = 0; i < numBatches; ++i) {
            DataBatches.DataBatch batch = batches.get(i);
            partitionIds[i] = batch.loc.getId();
            partitionUniqueIds[i] = batch.loc.getUniqueId();
            offsets[i] = currentSize;
            batchIds[i] = batch.batchId;
            currentSize += batch.body.length;
            byteBuf.addComponent(true, Unpooled.wrappedBuffer(batch.body));
        }
        NettyManagedBuffer buffer = new NettyManagedBuffer(byteBuf);
        String shuffleKey = Utils.makeShuffleKey(this.appUniqueId, shuffleId);
        PushMergedData mergedData = new PushMergedData(PRIMARY_MODE, shuffleKey, partitionUniqueIds, offsets, buffer);
        final RpcResponseCallback callback = new RpcResponseCallback((Integer[])partitionIds, groupedBatchId, batchIds, pushState, hostPort, remainReviveTimes, numBatches){
            final /* synthetic */ Integer[] val$partitionIds;
            final /* synthetic */ int val$groupedBatchId;
            final /* synthetic */ int[] val$batchIds;
            final /* synthetic */ PushState val$pushState;
            final /* synthetic */ String val$hostPort;
            final /* synthetic */ int val$remainReviveTimes;
            final /* synthetic */ int val$numBatches;
            {
                this.val$partitionIds = integerArray;
                this.val$groupedBatchId = n4;
                this.val$batchIds = nArray;
                this.val$pushState = pushState;
                this.val$hostPort = string;
                this.val$remainReviveTimes = n5;
                this.val$numBatches = n6;
            }

            @Override
            public void onSuccess(ByteBuffer response) {
                logger.debug("Push merged data to {} success for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}.", new Object[]{addressPair, shuffleId, mapId, attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds)});
                this.val$pushState.removeBatch(this.val$groupedBatchId, this.val$hostPort);
                if (response.remaining() > 0 && response.get() == StatusCode.MAP_ENDED.getValue()) {
                    ShuffleClientImpl.this.mapperEndMap.computeIfAbsent(shuffleId, id -> ConcurrentHashMap.newKeySet()).add(mapId);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                String errorMsg = String.format("Push merged data to %s failed for shuffle %d map %d attempt %d partition %s groupedBatch %d batch %s, remain revive times %d.", addressPair, shuffleId, mapId, attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds), this.val$remainReviveTimes);
                this.val$pushState.exception.compareAndSet(null, new CelebornIOException(errorMsg, e));
                if (logger.isDebugEnabled()) {
                    for (int i = 0; i < this.val$numBatches; ++i) {
                        logger.debug("Push merged data to {} failed for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}, remain revive times {}.", new Object[]{addressPair, shuffleId, mapId, attemptId, this.val$partitionIds[i], this.val$groupedBatchId, this.val$batchIds[i], this.val$remainReviveTimes});
                    }
                }
            }
        };
        RpcResponseCallback wrappedCallback = new RpcResponseCallback((Integer[])partitionIds, shuffleId, mapId, attemptId, addressPair, groupedBatchId, batchIds, pushState, hostPort, remainReviveTimes, numBatches, partitionUniqueIds){
            final /* synthetic */ Integer[] val$partitionIds;
            final /* synthetic */ int val$shuffleId;
            final /* synthetic */ int val$mapId;
            final /* synthetic */ int val$attemptId;
            final /* synthetic */ Pair val$addressPair;
            final /* synthetic */ int val$groupedBatchId;
            final /* synthetic */ int[] val$batchIds;
            final /* synthetic */ PushState val$pushState;
            final /* synthetic */ String val$hostPort;
            final /* synthetic */ int val$remainReviveTimes;
            final /* synthetic */ int val$numBatches;
            final /* synthetic */ String[] val$partitionUniqueIds;
            {
                this.val$partitionIds = integerArray;
                this.val$shuffleId = n;
                this.val$mapId = n2;
                this.val$attemptId = n3;
                this.val$addressPair = pair;
                this.val$groupedBatchId = n4;
                this.val$batchIds = nArray;
                this.val$pushState = pushState;
                this.val$hostPort = string;
                this.val$remainReviveTimes = n5;
                this.val$numBatches = n6;
                this.val$partitionUniqueIds = stringArray;
            }

            @Override
            public void onSuccess(ByteBuffer response) {
                byte reason = response.get();
                if (reason == StatusCode.HARD_SPLIT.getValue() || reason == StatusCode.SOFT_SPLIT.getValue()) {
                    ArrayList<DataBatches.DataBatch> batchesNeedResubmit;
                    if (response.remaining() > 0) {
                        PbPushMergedDataSplitPartitionInfo partitionInfo;
                        batchesNeedResubmit = new ArrayList<DataBatches.DataBatch>();
                        try {
                            partitionInfo = (PbPushMergedDataSplitPartitionInfo)TransportMessage.fromByteBuffer(response).getParsedPayload();
                        }
                        catch (CelebornIOException | InvalidProtocolBufferException e) {
                            callback.onFailure(new CelebornIOException("parse pushMergedData response failed", (Throwable)e));
                            return;
                        }
                        List<Integer> splitPartitionIndexes = partitionInfo.getSplitPartitionIndexesList();
                        List<Integer> statusCodeList = partitionInfo.getStatusCodesList();
                        StringBuilder dataBatchReviveInfos = new StringBuilder();
                        for (int i = 0; i < splitPartitionIndexes.size(); ++i) {
                            int partitionIndex = splitPartitionIndexes.get(i);
                            int batchId = ((DataBatches.DataBatch)batches.get((int)partitionIndex)).batchId;
                            dataBatchReviveInfos.append(String.format("(batchId=%d, partitionId=%d, cause=%s)", new Object[]{batchId, this.val$partitionIds[partitionIndex], StatusCode.fromValue(statusCodeList.get(i).byteValue())}));
                            if (statusCodeList.get(i).intValue() == StatusCode.SOFT_SPLIT.getValue()) {
                                PartitionLocation loc = ((DataBatches.DataBatch)batches.get((int)partitionIndex)).loc;
                                if (ShuffleClientImpl.this.newerPartitionLocationExists((Map<Integer, PartitionLocation>)ShuffleClientImpl.this.reducePartitionMap.get(this.val$shuffleId), loc.getId(), loc.getEpoch(), false)) continue;
                                ReviveRequest reviveRequest = new ReviveRequest(this.val$shuffleId, this.val$mapId, this.val$attemptId, loc.getId(), loc.getEpoch(), loc, StatusCode.SOFT_SPLIT);
                                ShuffleClientImpl.this.reviveManager.addRequest(reviveRequest);
                                continue;
                            }
                            batchesNeedResubmit.add((DataBatches.DataBatch)batches.get(partitionIndex));
                        }
                        logger.info("Push merged data to {} partial success required for shuffle {} map {} attempt {} groupedBatch {}. split batches {}.", new Object[]{this.val$addressPair, this.val$shuffleId, this.val$mapId, this.val$attemptId, this.val$groupedBatchId, dataBatchReviveInfos});
                    } else {
                        batchesNeedResubmit = batches;
                        logger.info("Push merged data to {} hard split required for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}.", new Object[]{this.val$addressPair, this.val$shuffleId, this.val$mapId, this.val$attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds)});
                    }
                    if (batchesNeedResubmit.isEmpty()) {
                        this.val$pushState.onSuccess(this.val$hostPort);
                        callback.onSuccess(ByteBuffer.wrap(new byte[]{StatusCode.SOFT_SPLIT.getValue()}));
                    } else {
                        if (ShuffleClientImpl.this.dataPushFailureTrackingEnabled && ShuffleClientImpl.this.pushReplicateEnabled) {
                            for (DataBatches.DataBatch resubmitBatch : batchesNeedResubmit) {
                                this.val$pushState.recordFailedBatch(resubmitBatch.loc.getUniqueId(), this.val$mapId, this.val$attemptId, resubmitBatch.batchId);
                            }
                        }
                        ReviveRequest[] requests = ShuffleClientImpl.this.addAndGetReviveRequests(this.val$shuffleId, this.val$mapId, this.val$attemptId, batchesNeedResubmit, StatusCode.HARD_SPLIT);
                        ShuffleClientImpl.this.pushDataRetryPool.submit(() -> ShuffleClientImpl.this.submitRetryPushMergedData(this.val$pushState, this.val$shuffleId, this.val$mapId, this.val$attemptId, batchesNeedResubmit, StatusCode.HARD_SPLIT, this.val$groupedBatchId, requests, this.val$remainReviveTimes, System.currentTimeMillis() + ShuffleClientImpl.this.conf.clientRpcRequestPartitionLocationAskTimeout().duration().toMillis()));
                    }
                } else if (reason == StatusCode.PUSH_DATA_SUCCESS_PRIMARY_CONGESTED.getValue()) {
                    logger.debug("Push merged data to {} primary congestion required for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}.", new Object[]{this.val$addressPair, this.val$shuffleId, this.val$mapId, this.val$attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds)});
                    this.val$pushState.onCongestControl(this.val$hostPort);
                    callback.onSuccess(response);
                } else if (reason == StatusCode.PUSH_DATA_SUCCESS_REPLICA_CONGESTED.getValue()) {
                    logger.debug("Push merged data to {} replica congestion required for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}.", new Object[]{this.val$addressPair, this.val$shuffleId, this.val$mapId, this.val$attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds)});
                    this.val$pushState.onCongestControl(this.val$hostPort);
                    callback.onSuccess(response);
                } else if (reason == StatusCode.MAP_ENDED.getValue()) {
                    this.val$pushState.onSuccess(this.val$hostPort);
                    callback.onSuccess(ByteBuffer.wrap(new byte[]{StatusCode.MAP_ENDED.getValue()}));
                } else {
                    this.val$pushState.onSuccess(this.val$hostPort);
                    callback.onSuccess(ByteBuffer.wrap(new byte[]{StatusCode.SUCCESS.getValue()}));
                }
            }

            @Override
            public void onFailure(Throwable e) {
                if (ShuffleClientImpl.this.dataPushFailureTrackingEnabled) {
                    for (int i = 0; i < this.val$numBatches; ++i) {
                        this.val$pushState.recordFailedBatch(this.val$partitionUniqueIds[i], this.val$mapId, this.val$attemptId, this.val$batchIds[i]);
                    }
                }
                if (this.val$pushState.exception.get() != null) {
                    return;
                }
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    callback.onFailure(e);
                    return;
                }
                StatusCode cause = ShuffleClientImpl.this.getPushDataFailCause(e.getMessage());
                if (this.val$remainReviveTimes <= 0) {
                    if (e instanceof CelebornIOException) {
                        callback.onFailure(e);
                    } else {
                        callback.onFailure(new CelebornIOException(cause, e));
                    }
                    return;
                }
                logger.error("Push merged data to {} failed for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}, remain revive times {}.", new Object[]{this.val$addressPair, this.val$shuffleId, this.val$mapId, this.val$attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds), this.val$remainReviveTimes, e});
                if (!ShuffleClientImpl.this.mapperEnded(this.val$shuffleId, this.val$mapId)) {
                    ReviveRequest[] requests = ShuffleClientImpl.this.addAndGetReviveRequests(this.val$shuffleId, this.val$mapId, this.val$attemptId, batches, cause);
                    ShuffleClientImpl.this.pushDataRetryPool.submit(() -> ShuffleClientImpl.this.submitRetryPushMergedData(this.val$pushState, this.val$shuffleId, this.val$mapId, this.val$attemptId, batches, cause, this.val$groupedBatchId, requests, this.val$remainReviveTimes - 1, System.currentTimeMillis() + ShuffleClientImpl.this.conf.clientRpcRequestPartitionLocationAskTimeout().duration().toMillis()));
                } else {
                    this.val$pushState.removeBatch(this.val$groupedBatchId, this.val$hostPort);
                    logger.info("Push merged data to {} failed but mapper already ended for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {}, remain revive times {}.", new Object[]{this.val$hostPort, this.val$shuffleId, this.val$mapId, this.val$attemptId, Arrays.toString((Object[])this.val$partitionIds), this.val$groupedBatchId, Arrays.toString(this.val$batchIds), this.val$remainReviveTimes});
                }
            }
        };
        try {
            if (!this.isPushTargetWorkerExcluded(batches.get((int)0).loc, wrappedCallback)) {
                if (!this.testRetryRevive || remainReviveTimes < 1) {
                    assert (this.dataClientFactory != null);
                    TransportClient client = this.dataClientFactory.createClient(host, port);
                    client.pushMergedData(mergedData, this.pushDataTimeout, wrappedCallback);
                } else {
                    wrappedCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_PRIMARY, (Throwable)new RuntimeException("Mock push merge data failed.")));
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception raised while pushing merged data for shuffle {} map {} attempt {} partition {} groupedBatch {} batch {} location {}.", new Object[]{shuffleId, mapId, attemptId, Arrays.toString(partitionIds), groupedBatchId, Arrays.toString(batchIds), addressPair, e});
            if (e instanceof InterruptedException) {
                wrappedCallback.onFailure(e);
            }
            wrappedCallback.onFailure(new CelebornIOException(StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY, (Throwable)e));
        }
    }

    @Override
    public void mapperEnd(int shuffleId, int mapId, int attemptId, int numMappers) throws IOException {
        this.mapEndInternal(shuffleId, mapId, attemptId, numMappers, -1);
    }

    @Override
    public void mapPartitionMapperEnd(int shuffleId, int mapId, int attemptId, int numMappers, int partitionId) throws IOException {
        this.mapEndInternal(shuffleId, mapId, attemptId, numMappers, partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapEndInternal(int shuffleId, int mapId, int attemptId, int numMappers, Integer partitionId) throws IOException {
        String mapKey = Utils.makeMapKey(shuffleId, mapId, attemptId);
        PushState pushState = this.getPushState(mapKey);
        try {
            this.limitZeroInFlight(mapKey, pushState);
            ControlMessages.MapperEndResponse response = (ControlMessages.MapperEndResponse)this.lifecycleManagerRef.askSync(new ControlMessages.MapperEnd(shuffleId, mapId, attemptId, numMappers, partitionId, pushState.getFailedBatches()), this.rpcMaxRetries, this.rpcRetryWait, ClassTag$.MODULE$.apply(ControlMessages.MapperEndResponse.class));
            if (response.status() != StatusCode.SUCCESS) {
                throw new CelebornIOException("MapperEnd failed! StatusCode: " + (Object)((Object)response.status()));
            }
        }
        finally {
            this.pushStates.remove(mapKey);
        }
    }

    @Override
    public void cleanup(int shuffleId, int mapId, int attemptId) {
        String mapKey = Utils.makeMapKey(shuffleId, mapId, attemptId);
        PushState pushState = this.pushStates.remove(mapKey);
        if (pushState != null) {
            pushState.exception.compareAndSet(null, new CelebornIOException("Cleaned Up"));
            pushState.cleanup();
        }
    }

    @Override
    public boolean cleanupShuffle(int shuffleId) {
        this.reducePartitionMap.remove(shuffleId);
        this.reduceFileGroupsMap.remove(shuffleId);
        this.mapperEndMap.remove(shuffleId);
        this.stageEndShuffleSet.remove(shuffleId);
        this.splitting.remove(shuffleId);
        logger.info("Unregistered shuffle {}.", (Object)shuffleId);
        return true;
    }

    protected Tuple3<ReduceFileGroups, String, Exception> loadFileGroupInternal(int shuffleId, boolean isSegmentGranularityVisible) {
        long getReducerFileGroupStartTime = System.nanoTime();
        String exceptionMsg = null;
        Exception exception = null;
        if (this.lifecycleManagerRef == null) {
            exceptionMsg = "Driver endpoint is null!";
            logger.warn(exceptionMsg);
            return Tuple3.apply(null, (Object)exceptionMsg, exception);
        }
        try {
            ControlMessages.GetReducerFileGroup getReducerFileGroup = new ControlMessages.GetReducerFileGroup(shuffleId, isSegmentGranularityVisible, SerdeVersion.V1);
            ControlMessages.GetReducerFileGroupResponse response = (ControlMessages.GetReducerFileGroupResponse)this.lifecycleManagerRef.askSync(getReducerFileGroup, this.conf.clientRpcGetReducerFileGroupAskTimeout(), this.rpcMaxRetries, this.rpcRetryWait, ClassTag$.MODULE$.apply(ControlMessages.GetReducerFileGroupResponse.class));
            switch (response.status()) {
                case SUCCESS: {
                    if (response.broadcast() != null && response.broadcast().length > 0 && (response = ShuffleClient.deserializeReducerFileGroupResponse(shuffleId, response.broadcast())) == null) {
                        throw new CelebornBroadcastException("Failed to get GetReducerFileGroupResponse broadcast for shuffle: " + shuffleId);
                    }
                    logger.info("Shuffle {} request reducer file group success using {} ms, result partition size {}.", new Object[]{shuffleId, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - getReducerFileGroupStartTime), response.fileGroup().size()});
                    return Tuple3.apply((Object)new ReduceFileGroups(response.fileGroup(), response.attempts(), response.partitionIds(), response.pushFailedBatches()), null, null);
                }
                case SHUFFLE_NOT_REGISTERED: {
                    logger.warn("Request {} return {} for {}.", new Object[]{getReducerFileGroup, response.status(), shuffleId});
                    return Tuple3.apply((Object)new ReduceFileGroups(response.fileGroup(), response.attempts(), response.partitionIds(), response.pushFailedBatches()), null, null);
                }
                case STAGE_END_TIME_OUT: 
                case SHUFFLE_DATA_LOST: {
                    exceptionMsg = String.format("Request %s return %s for %s.", new Object[]{getReducerFileGroup, response.status(), shuffleId});
                    logger.warn(exceptionMsg);
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.error("Exception raised while call GetReducerFileGroup for {}.", (Object)shuffleId, (Object)e);
            exceptionMsg = e.getMessage();
            exception = e;
        }
        return Tuple3.apply(null, (Object)exceptionMsg, (Object)exception);
    }

    @Override
    public ReduceFileGroups updateFileGroup(int shuffleId, int partitionId) throws CelebornIOException {
        return this.updateFileGroup(shuffleId, partitionId, false);
    }

    @Override
    public boolean isShuffleStageEnd(int shuffleId) throws Exception {
        if (null != this.lifecycleManagerRef) {
            PbGetStageEnd request = PbGetStageEnd.newBuilder().setShuffleId(shuffleId).build();
            PbGetStageEndResponse response = (PbGetStageEndResponse)this.lifecycleManagerRef.askSync(request, this.rpcMaxRetries, this.rpcRetryWait, ClassTag$.MODULE$.apply(PbGetStageEndResponse.class));
            return response.getStageEnd();
        }
        throw new RuntimeException("Driver endpoint is null!");
    }

    public ReduceFileGroups updateFileGroup(int shuffleId, int partitionId, boolean isSegmentGranularityVisible) throws CelebornIOException {
        Tuple3 fileGroupTuple = this.reduceFileGroupsMap.compute(shuffleId, (id, existsTuple) -> {
            if (existsTuple == null || existsTuple._1() == null) {
                return this.loadFileGroupInternal(shuffleId, isSegmentGranularityVisible);
            }
            return existsTuple;
        });
        if (fileGroupTuple._1() == null) {
            throw new CelebornIOException(this.loadFileGroupException(shuffleId, partitionId, (String)fileGroupTuple._2()), (Throwable)fileGroupTuple._3());
        }
        return (ReduceFileGroups)fileGroupTuple._1();
    }

    protected String loadFileGroupException(int shuffleId, int partitionId, String exceptionMsg) {
        return String.format("Failed to load file group of shuffle %d partition %d! %s", shuffleId, partitionId, StringUtils.isEmpty(exceptionMsg) ? "" : exceptionMsg);
    }

    @Override
    public CelebornInputStream readPartition(int shuffleId, int appShuffleId, int partitionId, int attemptNumber, long taskId, int startMapIndex, int endMapIndex, ExceptionMaker exceptionMaker, ArrayList<PartitionLocation> locations, ArrayList<PbStreamHandler> streamHandlers, Map<String, LocationPushFailedBatches> failedBatchSetMap, Map<String, Pair<Integer, Integer>> chunksRange, int[] mapAttempts, MetricsCallback metricsCallback, boolean needDecompress) throws IOException {
        if (shuffleId == Utils$.MODULE$.UNKNOWN_APP_SHUFFLE_ID()) {
            logger.warn("Shuffle data is empty for shuffle {}: UNKNOWN_APP_SHUFFLE_ID.", (Object)shuffleId);
            return CelebornInputStream.empty();
        }
        if (mapAttempts == null) {
            ReduceFileGroups fileGroups = this.updateFileGroup(shuffleId, partitionId, false);
            mapAttempts = fileGroups.mapAttempts;
            if (fileGroups.partitionGroups.containsKey(partitionId)) {
                locations = new ArrayList(fileGroups.partitionGroups.get(partitionId));
            }
        }
        if (locations == null || locations.size() == 0) {
            logger.warn("Shuffle data is empty for shuffle {} partition {}.", (Object)shuffleId, (Object)partitionId);
            return CelebornInputStream.empty();
        }
        String shuffleKey = Utils.makeShuffleKey(this.appUniqueId, shuffleId);
        assert (this.dataClientFactory != null);
        return CelebornInputStream.create(this.conf, this.dataClientFactory, shuffleKey, locations, streamHandlers, mapAttempts, failedBatchSetMap, chunksRange, attemptNumber, taskId, startMapIndex, endMapIndex, this.fetchExcludedWorkers, this, appShuffleId, shuffleId, partitionId, exceptionMaker, metricsCallback, needDecompress);
    }

    @VisibleForTesting
    public Map<Integer, Tuple3<ReduceFileGroups, String, Exception>> getReduceFileGroupsMap() {
        return this.reduceFileGroupsMap;
    }

    @Override
    public void shutdown() {
        if (null != this.reviveManager) {
            this.reviveManager.close();
        }
        if (null != this.rpcEnv) {
            this.rpcEnv.shutdown();
        }
        if (null != this.dataClientFactory) {
            this.dataClientFactory.close();
        }
        if (null != this.transportContext) {
            this.transportContext.close();
        }
        if (null != this.pushDataRetryPool) {
            this.pushDataRetryPool.shutdown();
        }
        if (null != this.lifecycleManagerRef) {
            this.lifecycleManagerRef = null;
        }
        this.shuffleIdCache.clear();
        this.pushExcludedWorkers.clear();
        this.fetchExcludedWorkers.clear();
        this.messagesHelper.close();
        logger.warn("Shuffle client has been shutdown!");
    }

    @Override
    public void setupLifecycleManagerRef(String host, int port) {
        logger.info("setupLifecycleManagerRef: host = {}, port = {}", (Object)host, (Object)port);
        try {
            this.lifecycleManagerRef = this.rpcEnv.setupEndpointRef(new RpcAddress(host, port), RpcNameConstants.LIFECYCLE_MANAGER_EP, this.rpcMaxRetries, this.rpcRetryWait);
        }
        catch (Exception e) {
            throw new CelebornRuntimeException("setupLifecycleManagerRef failed!", e);
        }
        this.initDataClientFactoryIfNeeded();
    }

    @Override
    public void setupLifecycleManagerRef(RpcEndpointRef endpointRef) {
        this.lifecycleManagerRef = endpointRef;
        this.initDataClientFactoryIfNeeded();
    }

    @Override
    public void setExtension(byte[] extension) {
        this.extension = extension;
    }

    boolean mapperEnded(int shuffleId, int mapId) {
        return this.mapperEndMap.containsKey(shuffleId) && this.mapperEndMap.get(shuffleId).contains(mapId) || this.isStageEnded(shuffleId);
    }

    protected boolean isStageEnded(int shuffleId) {
        return this.stageEndShuffleSet.contains(shuffleId);
    }

    private StatusCode getPushDataFailCause(String message) {
        StatusCode cause;
        logger.debug("Push data failed cause message: {}", (Object)message);
        if (message == null) {
            logger.error("Push data throw unexpected exception");
            cause = StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_PRIMARY;
        } else {
            cause = message.startsWith(StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_REPLICA.name()) ? StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_REPLICA : (message.startsWith(StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA.name()) ? StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA : (message.startsWith(StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY.name()) ? StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY : (message.startsWith(StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY.name()) ? StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY : (message.startsWith(StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA.name()) ? StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA : (message.startsWith(StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY.name()) ? StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY : (message.startsWith(StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA.name()) ? StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA : (message.startsWith(StatusCode.PUSH_DATA_TIMEOUT_PRIMARY.name()) ? StatusCode.PUSH_DATA_TIMEOUT_PRIMARY : (message.startsWith(StatusCode.PUSH_DATA_TIMEOUT_REPLICA.name()) ? StatusCode.PUSH_DATA_TIMEOUT_REPLICA : (message.startsWith(StatusCode.REPLICATE_DATA_FAILED.name()) ? StatusCode.REPLICATE_DATA_FAILED : (message.startsWith(StatusCode.PUSH_DATA_PRIMARY_WORKER_EXCLUDED.name()) ? StatusCode.PUSH_DATA_PRIMARY_WORKER_EXCLUDED : (message.startsWith(StatusCode.PUSH_DATA_REPLICA_WORKER_EXCLUDED.name()) ? StatusCode.PUSH_DATA_REPLICA_WORKER_EXCLUDED : (message.startsWith(StatusCode.PUSH_DATA_FAIL_PARTITION_NOT_FOUND.name()) ? StatusCode.PUSH_DATA_FAIL_PARTITION_NOT_FOUND : (ExceptionUtils.connectFail(message) ? StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY : StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE_PRIMARY)))))))))))));
        }
        return cause;
    }

    @Override
    @VisibleForTesting
    public TransportClientFactory getDataClientFactory() {
        return this.dataClientFactory;
    }

    @Override
    public void excludeFailedFetchLocation(String hostAndFetchPort, Exception e) {
        if (this.pushReplicateEnabled && this.fetchExcludeWorkerOnFailureEnabled && Utils.isCriticalCauseForFetch(e)) {
            this.fetchExcludedWorkers.put(hostAndFetchPort, System.currentTimeMillis());
        }
    }

    private static interface PushDataRpcResponseCallback
    extends RpcResponseCallback {
        default public void updateLatestPartition(PartitionLocation latest) {
        }
    }

    public static class ReduceFileGroups {
        public Map<Integer, Set<PartitionLocation>> partitionGroups;
        public Map<String, LocationPushFailedBatches> pushFailedBatches;
        public int[] mapAttempts;
        public Set<Integer> partitionIds;

        ReduceFileGroups(Map<Integer, Set<PartitionLocation>> partitionGroups, int[] mapAttempts, Set<Integer> partitionIds, Map<String, LocationPushFailedBatches> pushFailedBatches) {
            this.partitionGroups = partitionGroups;
            this.mapAttempts = mapAttempts;
            this.partitionIds = partitionIds;
            this.pushFailedBatches = pushFailedBatches;
        }

        public ReduceFileGroups() {
            this.partitionGroups = null;
            this.mapAttempts = null;
            this.partitionIds = null;
            this.pushFailedBatches = null;
        }

        public void update(ReduceFileGroups fileGroups) {
            this.partitionGroups = fileGroups.partitionGroups;
            this.mapAttempts = fileGroups.mapAttempts;
            this.partitionIds = fileGroups.partitionIds;
            this.pushFailedBatches = fileGroups.pushFailedBatches;
        }
    }
}

