/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.election;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class StepDownCommand
extends AbstractRatisCommand {
    public StepDownCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "stepDown";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        try (RaftClient client = this.newRaftClient();){
            RaftPeerId leaderId = RaftPeerId.valueOf((ByteString)this.getLeader(this.getGroupInfoReply().getRoleInfoProto()).getId());
            RaftClientReply transferLeadershipReply = client.admin().transferLeadership(null, leaderId, 60000L);
            this.processReply(transferLeadershipReply, () -> "Failed to step down leader");
        }
        catch (Throwable t) {
            this.printf("caught an error when executing step down leader: %s%n", t.getMessage());
            return -1;
        }
        this.println("Step down leader successfully");
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>]", this.getCommandName(), "peers", "groupid");
    }

    @Override
    public String getDescription() {
        return StepDownCommand.description();
    }

    public static String description() {
        return "Step down the leader server.";
    }
}

