/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.protocol.message.ControlMessages$;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.StackTrace;
import org.apache.celeborn.common.util.ThreadStackTrace;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.reflect.DynConstructors;
import org.apache.celeborn.shaded.com.google.protobuf.ByteString;
import org.apache.celeborn.shaded.com.google.protobuf.GeneratedMessageV3;
import org.apache.celeborn.shaded.io.netty.channel.unix.Errors;
import org.apache.celeborn.shaded.org.apache.commons.lang3.SystemUtils;
import org.apache.celeborn.shaded.org.apache.commons.lang3.time.FastDateFormat;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$
implements Logging {
    public static final Utils$ MODULE$;
    private final long[] siByteSizes;
    private final String[] siByteSuffixes;
    private final boolean isWindows;
    private final boolean isMac;
    private final boolean isMacOnAppleSilicon;
    private InetAddress org$apache$celeborn$common$util$Utils$$localIpAddress;
    private Option<String> customHostname;
    private final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private int maxDefaultNettyThreads;
    private final String SORTED_SUFFIX;
    private final String INDEX_SUFFIX;
    private final String SUFFIX_HDFS_WRITE_SUCCESS;
    private final String COMPATIBLE_HDFS_REGEX;
    private final String S3_REGEX;
    private final String OSS_REGEX;
    private final int UNKNOWN_APP_SHUFFLE_ID;
    private final FastDateFormat dateFmt;
    private final String org$apache$celeborn$common$util$Utils$$REDACTION_REPLACEMENT_TEXT;
    private final transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Utils$();
    }

    private InetAddress org$apache$celeborn$common$util$Utils$$localIpAddress$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.org$apache$celeborn$common$util$Utils$$localIpAddress = this.findLocalInetAddress();
                this.bitmap$0 = true;
            }
            return this.org$apache$celeborn$common$util$Utils$$localIpAddress;
        }
    }

    private Logger log$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public Seq<String> stringToSeq(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])str.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
            }
        }));
    }

    public scala.collection.immutable.Map<String, String> getSystemProperties() {
        return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().stringPropertyNames()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String key) {
                return new Tuple2((Object)key, (Object)System.getProperty(key));
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public long timeStringAsMs(String str) {
        return JavaUtils.timeStringAsMs(str);
    }

    public long timeStringAsSeconds(String str) {
        return JavaUtils.timeStringAsSec(str);
    }

    public long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAsBytes(str);
    }

    public long byteStringAsKb(String str) {
        return JavaUtils.byteStringAsKb(str);
    }

    public long byteStringAsMb(String str) {
        return JavaUtils.byteStringAsMb(str);
    }

    public long byteStringAsGb(String str) {
        return JavaUtils.byteStringAsGb(str);
    }

    public int memoryStringToMb(String str) {
        return (int)(JavaUtils.byteStringAsBytes(str) / 1024L / 1024L);
    }

    public String bytesToString(long size) {
        int i;
        for (i = 0; i < this.siByteSizes.length - 1 && size < 2L * this.siByteSizes[i]; ++i) {
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)this.siByteSizes[i])), this.siByteSuffixes[i]}));
    }

    public String bytesToString(BigInt size) {
        long EiB = 0x1000000000000000L;
        return size.isValidLong() ? this.bytesToString(size.toLong()) : (size.$less(scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EiB))) ? new StringOps(Predef$.MODULE$.augmentString("%.1f EiB")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EiB))})) : new StringBuilder().append((Object)scala.package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString()).append((Object)" B").toString());
    }

    public String megabytesToString(long megabytes) {
        return this.bytesToString(megabytes * 1024L * 1024L);
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        String string = l < (long)second ? new StringOps(Predef$.MODULE$.augmentString("%d ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})) : (l < (long)minute ? new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))})) : (l < (long)hour ? new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))})) : new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}))));
        return string;
    }

    public String nanoDurationToString(long ns) {
        long ms = 1000000L;
        long second = 1000L * ms;
        long minute = 60L * second;
        long hour = 60L * minute;
        Locale locale = Locale.US;
        long l = ns;
        String string = l < ms ? new StringOps(Predef$.MODULE$.augmentString("%d ns")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})) : (l < second ? new StringOps(Predef$.MODULE$.augmentString("%.1f ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)ms))})) : (l < minute ? new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))})) : (l < hour ? new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))})) : new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))})))));
        return string;
    }

    public Tuple2<String, Object> extractHostPortFromCelebornUrl(String celebornUrl) throws CelebornException {
        try {
            URI uri = new URI(celebornUrl);
            String host = uri.getHost();
            int port = uri.getPort();
            String string = uri.getScheme();
            String string2 = "celeborn";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (!(host == null || port < 0 || uri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).nonEmpty() || uri.getFragment() != null || uri.getQuery() != null || uri.getUserInfo() != null)) {
                    return new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                }
            }
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid master URL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{celebornUrl})));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid master URL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{celebornUrl})), uRISyntaxException);
        }
    }

    public Tuple3<String, Object, String> extractHostPortNameFromCelebornUrl(String celebornUrl) throws CelebornException {
        try {
            URI uri = new URI(celebornUrl);
            String host = uri.getHost();
            int port = uri.getPort();
            String name = uri.getUserInfo();
            String string = uri.getScheme();
            String string2 = "celeborn";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (!(host == null || port < 0 || name == null || uri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).nonEmpty() || uri.getFragment() != null || uri.getQuery() != null)) {
                    return new Tuple3((Object)host, (Object)BoxesRunTime.boxToInteger((int)port), (Object)name);
                }
            }
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Celeborn URL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{celebornUrl})));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Celeborn URL: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{celebornUrl})), uRISyntaxException);
        }
    }

    public <T> T tryOrIOException(Function0<T> block) {
        try {
            return (T)block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                this.logError((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception encountered";
                    }
                }, iOException);
                throw iOException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception encountered";
                }
            }, e);
            throw new IOException(e);
        }
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uncaught exception in thread ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}));
                }
            }, t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void tryOrExit(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            throw throwable;
        }
    }

    public int selectRandomInt(int from, int until) {
        return Random$.MODULE$.nextInt(until - 1 - from) + from;
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, CelebornConf conf, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.";
                }
            });
            String serviceString = serviceName.isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName}));
            int maxRetries = conf.portMaxRetries();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)new Serializable(startPort, startService, serviceString, maxRetries, object){
                public static final long serialVersionUID = 0L;
                private final int startPort$1;
                private final Function1 startService$1;
                public final String serviceString$1;
                private final int maxRetries$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(int offset) {
                    this.apply$mcVI$sp(offset);
                }

                public void apply$mcVI$sp(int offset) {
                    int tryPort = this.startPort$1 == 0 ? this.startPort$1 : Utils$.MODULE$.userPort(this.startPort$1, offset);
                    try {
                        Tuple2 tuple2 = (Tuple2)this.startService$1.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            Object service = tuple2._1();
                            int port = tuple2._2$mcI$sp();
                            Tuple2 tuple23 = tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                            Object service2 = tuple23._1();
                            int port2 = tuple23._2$mcI$sp();
                            Utils$.MODULE$.logInfo((Function0<String>)new Serializable(this, port2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.startServiceOnPort.1 $outer;
                                private final int port$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully started service", " on port ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceString$1, BoxesRunTime.boxToInteger((int)this.port$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.port$1 = port$1;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    catch (Throwable throwable) {
                        Exception exception;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof Exception && Utils$.MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                            BoxedUnit boxedUnit;
                            if (offset >= this.maxRetries$1) {
                                String exceptionMessage = this.startPort$1 == 0 ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Service", " failed after "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage(), this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " retries (on a random free port)! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxRetries$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consider explicitly setting the appropriate binding address for "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the service", " to the correct binding address."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serviceString$1}))).toString() : new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Service", " failed after "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage(), this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " retries (starting from ", ")! Consider explicitly setting "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxRetries$1), BoxesRunTime.boxToInteger((int)this.startPort$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the appropriate port for the service", " to an available port "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.serviceString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"or increasing ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CelebornConf$.MODULE$.PORT_MAX_RETRY().key()}))).toString();
                                BindException exception2 = new BindException(exceptionMessage);
                                exception2.setStackTrace(exception.getStackTrace());
                                throw exception2;
                            }
                            if (this.startPort$1 == 0) {
                                Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.startServiceOnPort.1 $outer;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service", " could not bind on a random free port. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceString$1}))).append((Object)"You may check whether configuring an appropriate binding address.").toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this, tryPort){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.startServiceOnPort.1 $outer;
                                    private final int tryPort$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service", " could not bind on port ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serviceString$1, BoxesRunTime.boxToInteger((int)this.tryPort$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting port ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.tryPort$1 + 1))}))).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.tryPort$1 = tryPort$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                        throw throwable;
                    }
                }
                {
                    this.startPort$1 = startPort$1;
                    this.startService$1 = startService$1;
                    this.serviceString$1 = serviceString$1;
                    this.maxRetries$1 = maxRetries$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to start service", " on port ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceString, BoxesRunTime.boxToInteger((int)startPort)})));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (Tuple2)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public boolean isBindCollision(Throwable exception) {
        boolean bl;
        block4: {
            while (true) {
                Throwable throwable;
                if ((throwable = exception) instanceof BindException) {
                    BindException bindException = (BindException)throwable;
                    if (bindException.getMessage() == null) {
                        exception = bindException.getCause();
                        continue;
                    }
                    return true;
                }
                if (throwable instanceof Errors.NativeIoException) {
                    Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                    bl = nativeIoException.getMessage() != null && nativeIoException.getMessage().startsWith("bind");
                    break block4;
                }
                if (!(throwable instanceof Exception)) break;
                Exception exception2 = (Exception)throwable;
                exception = exception2.getCause();
            }
            bl = false;
        }
        return bl;
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new StringBuilder().append((Object)"/").append((Object)fileName).toString(), null, null).getRawPath().substring(1);
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)new Serializable(arr, rand){
            public static final long serialVersionUID = 0L;
            private final Object arr$1;
            private final Random rand$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int j = this.rand$1.nextInt(i + 1);
                Object tmp = ScalaRunTime$.MODULE$.array_apply(this.arr$1, j);
                ScalaRunTime$.MODULE$.array_update(this.arr$1, j, ScalaRunTime$.MODULE$.array_apply(this.arr$1, i));
                ScalaRunTime$.MODULE$.array_update(this.arr$1, i, tmp);
            }
            {
                this.arr$1 = arr$1;
                this.rand$1 = rand$1;
            }
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isMacOnAppleSilicon() {
        return this.isMacOnAppleSilicon;
    }

    public InetAddress org$apache$celeborn$common$util$Utils$$localIpAddress() {
        return this.bitmap$0 ? this.org$apache$celeborn$common$util$Utils$$localIpAddress : this.org$apache$celeborn$common$util$Utils$$localIpAddress$lzycompute();
    }

    private InetAddress findLocalInetAddress() {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            InetAddress inetAddress;
            Object object = new Object();
            try {
                String defaultIpOverride = System.getenv("CELEBORN_LOCAL_IP");
                if (defaultIpOverride == null) {
                    InetAddress address = InetAddress.getLocalHost();
                    if (address.isLoopbackAddress()) {
                        Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                        Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                        reOrderedNetworkIFs.foreach((Function1)new Serializable(address, object){
                            public static final long serialVersionUID = 0L;
                            public final InetAddress address$1;
                            private final Object nonLocalReturnKey2$1;

                            public final void apply(NetworkInterface ni) {
                                Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(InetAddress addr) {
                                        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
                                    }
                                }).toSeq();
                                if (addresses.nonEmpty()) {
                                    InetAddress addr = (InetAddress)addresses.find((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(InetAddress x$4) {
                                            return x$4 instanceof Inet4Address;
                                        }
                                    }).getOrElse((Function0)new Serializable(this, addresses){
                                        public static final long serialVersionUID = 0L;
                                        private final Seq addresses$1;

                                        public final InetAddress apply() {
                                            return (InetAddress)this.addresses$1.head();
                                        }
                                        {
                                            this.addresses$1 = addresses$1;
                                        }
                                    });
                                    InetAddress strippedAddress = InetAddress.getByAddress(addr.getAddress());
                                    Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this, strippedAddress, ni){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.findLocalInetAddress.1 $outer;
                                        private final InetAddress strippedAddress$1;
                                        private final NetworkInterface ni$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Your hostname, ").append((Object)InetAddress.getLocalHost().getHostName()).append((Object)" resolves to").append((Object)" a loopback address: ").append((Object)this.$outer.address$1.getHostAddress()).append((Object)"; using ").append((Object)this.strippedAddress$1.getHostAddress()).append((Object)" instead (on interface ").append((Object)this.ni$1.getName()).append((Object)")").toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.strippedAddress$1 = strippedAddress$1;
                                            this.ni$1 = ni$1;
                                        }
                                    });
                                    Utils$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Set CELEBORN_LOCAL_IP if you need to bind to another address";
                                        }
                                    });
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, (Object)strippedAddress);
                                }
                            }
                            {
                                this.address$1 = address$1;
                                this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                            }
                        });
                        this.logWarning((Function0<String>)new Serializable(address){
                            public static final long serialVersionUID = 0L;
                            private final InetAddress address$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Your hostname, ").append((Object)InetAddress.getLocalHost().getHostName()).append((Object)" resolves to").append((Object)" a loopback address: ").append((Object)this.address$1.getHostAddress()).append((Object)", but we couldn't find any").append((Object)" external IP address!").toString();
                            }
                            {
                                this.address$1 = address$1;
                            }
                        });
                        this.logWarning((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Set CELEBORN_LOCAL_IP if you need to bind to another address";
                            }
                        });
                    }
                    inetAddress = address;
                } else {
                    inetAddress = InetAddress.getByName(defaultIpOverride);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                inetAddress = (InetAddress)nonLocalReturnControl2.value();
            }
            return inetAddress;
        }
        throw nonLocalReturnControl2;
    }

    private Option<String> customHostname() {
        return this.customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        this.customHostname = x$1;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localHostName(CelebornConf conf) {
        return this.getHostName(conf.bindPreferIP());
    }

    public String localHostNameForAdvertiseAddress(CelebornConf conf, String env) {
        return env.equals(RpcNameConstants.MASTER_SYS) || env.equals(RpcNameConstants.MASTER_INTERNAL_SYS) ? this.getAdvertiseAddressForMaster(conf) : this.getAdvertiseAddressForWorker(conf);
    }

    private String getAdvertiseAddressForMaster(CelebornConf conf) {
        return conf.advertiseAddressMasterHost();
    }

    private String getAdvertiseAddressForWorker(CelebornConf conf) {
        return this.getHostName(conf.advertisePreferIP());
    }

    public String getHostName(boolean preferIP) {
        return (String)this.customHostname().getOrElse((Function0)new Serializable(preferIP){
            public static final long serialVersionUID = 0L;
            private final boolean preferIP$1;

            public final String apply() {
                String string;
                if (this.preferIP$1) {
                    String string2;
                    InetAddress inetAddress = Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$localIpAddress();
                    if (inetAddress instanceof Inet6Address) {
                        Inet6Address inet6Address = (Inet6Address)inetAddress;
                        String ip = inet6Address.getHostAddress();
                        Predef$.MODULE$.assert(!ip.startsWith("[") && !ip.endsWith("]"), (Function0)new Serializable(this, ip){
                            public static final long serialVersionUID = 0L;
                            private final String ip$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resolved IPv6 address should not be enclosed in [] but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ip$1}));
                            }
                            {
                                this.ip$1 = ip$1;
                            }
                        });
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ip}));
                    } else {
                        string2 = inetAddress.getHostAddress();
                    }
                    string = string2;
                } else {
                    string = Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$localIpAddress().getCanonicalHostName();
                }
                return string;
            }
            {
                this.preferIP$1 = preferIP$1;
            }
        });
    }

    public void checkHost(String host) {
        if (host != null && host.split(":").length > 2) {
            Predef$.MODULE$.assert(host.startsWith("[") && host.endsWith("]"), (Function0)new Serializable(host){
                public static final long serialVersionUID = 0L;
                private final String host$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected hostname or IPv6 IP enclosed in [] but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1}));
                }
                {
                    this.host$1 = host$1;
                }
            });
        } else {
            Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0)new Serializable(host){
                public static final long serialVersionUID = 0L;
                private final String host$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected hostname or IP but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1}));
                }
                {
                    this.host$1 = host$1;
                }
            });
        }
    }

    private Tuple2<String, String> getIpHostAddressPair(String host) {
        Tuple2 tuple2;
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            String hostAddress = inetAddress.getHostAddress();
            tuple2 = host.equals(hostAddress) ? new Tuple2((Object)hostAddress, (Object)inetAddress.getCanonicalHostName()) : new Tuple2((Object)hostAddress, (Object)host);
        }
        catch (Throwable throwable) {
            tuple2 = new Tuple2((Object)host, (Object)host);
        }
        return tuple2;
    }

    public Tuple2<String, String> addressToIpHostAddressPair(String address) {
        Tuple2<String, Object> tuple2 = this.parseHostPort(address);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple23._1();
            int port2 = tuple23._2$mcI$sp();
            Tuple2<String, String> tuple24 = this.getIpHostAddressPair(host2);
            if (tuple24 != null) {
                Tuple2 tuple25;
                String _ip = (String)tuple24._1();
                String _host = (String)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)_ip, (Object)_host);
                String _ip2 = (String)tuple26._1();
                String _host2 = (String)tuple26._2();
                return new Tuple2((Object)new StringBuilder().append((Object)_ip2).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port2)).toString(), (Object)new StringBuilder().append((Object)_host2).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)port2)).toString());
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError(tuple2);
    }

    public void checkHostPort(String hostPort) {
        if (hostPort != null && hostPort.split(":").length > 2) {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf("]:") != -1, (Function0)new Serializable(hostPort){
                public static final long serialVersionUID = 0L;
                private final String hostPort$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected host and port but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostPort$2}));
                }
                {
                    this.hostPort$2 = hostPort$2;
                }
            });
        } else {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0)new Serializable(hostPort){
                public static final long serialVersionUID = 0L;
                private final String hostPort$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected host and port but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostPort$2}));
                }
                {
                    this.hostPort$2 = hostPort$2;
                }
            });
        }
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return this.hostPortParseResults;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<String, Object> parseHostPort(String hostPort) {
        void var2_2;
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached == null) {
            Tuple2<String, Object> tuple2;
            if (hostPort != null && hostPort.split(":").length > 2) {
                int index = hostPort.lastIndexOf("]:");
                if (-1 == index) {
                    return this.setDefaultPortValue$1(hostPort);
                }
                String port = hostPort.substring(index + 2).trim();
                Tuple2 retVal = new Tuple2((Object)hostPort.substring(0, index + 1).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
                tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retVal);
            } else {
                int index = hostPort.lastIndexOf(58);
                if (-1 == index) {
                    return this.setDefaultPortValue$1(hostPort);
                }
                String port = hostPort.substring(index + 1).trim();
                Tuple2 retVal = new Tuple2((Object)hostPort.substring(0, index).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
                tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retVal);
            }
            return this.hostPortParseResults().get(hostPort);
        }
        return var2_2;
    }

    private int maxDefaultNettyThreads() {
        return this.maxDefaultNettyThreads;
    }

    private void maxDefaultNettyThreads_$eq(int x$1) {
        this.maxDefaultNettyThreads = x$1;
    }

    public TransportConf fromCelebornConf(CelebornConf _conf, String module, int numUsableCores) {
        CelebornConf conf = _conf.clone();
        this.maxDefaultNettyThreads_$eq(conf.maxDefaultNettyThreads());
        int numThreads = this.defaultNumThreads(numUsableCores);
        conf.setTransportConfIfMissing(module, CelebornConf$.MODULE$.NETWORK_IO_SERVER_THREADS(), ((Object)BoxesRunTime.boxToInteger((int)numThreads)).toString());
        conf.setTransportConfIfMissing(module, CelebornConf$.MODULE$.NETWORK_IO_CLIENT_THREADS(), ((Object)BoxesRunTime.boxToInteger((int)numThreads)).toString());
        if ("push".equals(module)) {
            conf.setTransportConfIfMissing(module, CelebornConf$.MODULE$.NETWORK_IO_NUM_CONNECTIONS_PER_PEER(), ((Object)BoxesRunTime.boxToInteger((int)numThreads)).toString());
        }
        return new TransportConf(module, conf);
    }

    public int fromCelebornConf$default$3() {
        return 0;
    }

    private int defaultNumThreads(int numUsableCores) {
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        return package$.MODULE$.min(availableCores, this.maxDefaultNettyThreads());
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getContextOrClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ClassLoader apply() {
                return Utils$.MODULE$.getClassLoader();
            }
        });
    }

    public boolean classIsLoadable(String clazz) {
        return Try$.MODULE$.apply((Function0)new Serializable(clazz){
            public static final long serialVersionUID = 0L;
            private final String clazz$1;

            public final Class<Object> apply() {
                return Class.forName(this.clazz$1, false, Utils$.MODULE$.getContextOrClassLoader());
            }
            {
                this.clazz$1 = clazz$1;
            }
        }).isSuccess();
    }

    public Class<?> classForName(String className) {
        return Class.forName(className, true, this.getContextOrClassLoader());
    }

    public <T> T instantiateMasterEndpointResolver(String className, CelebornConf conf, boolean isWorker) {
        try {
            return (T)DynConstructors.builder().impl(className, CelebornConf.class, Boolean.TYPE).build().newInstance(conf, isWorker);
        }
        catch (Throwable throwable) {
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to instantiate masterEndpointResolver ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className})), throwable);
        }
    }

    public <T> T instantiateClassWithCelebornConf(String className, CelebornConf conf) {
        try {
            return (T)DynConstructors.builder().impl(className, CelebornConf.class).build().newInstance(conf);
        }
        catch (Throwable throwable) {
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to instantiate class ", " with celeborn conf."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className})), throwable);
        }
    }

    public String getCodeSourceLocation(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
    }

    /*
     * WARNING - void declaration
     */
    public String loadDefaultCelebornProperties(CelebornConf conf, String filePath) {
        void var3_3;
        String path = (String)Option$.MODULE$.apply((Object)filePath).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Utils$.MODULE$.getDefaultPropertiesFile(Utils$.MODULE$.getDefaultPropertiesFile$default$1());
            }
        });
        Option$.MODULE$.apply((Object)path).foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            public final CelebornConf conf$1;

            public final void apply(String confFile) {
                ((IterableLike)Utils$.MODULE$.getPropertiesFromFile(confFile).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            boolean bl = k.startsWith("celeborn.");
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.loadDefaultCelebornProperties.1 $outer;

                    public final String apply(Tuple2<String, String> x0$2) {
                        Tuple2<String, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            this.$outer.conf$1.setIfMissing(k, v);
                            String string = (String)scala.sys.package$.MODULE$.props().getOrElseUpdate((Object)k, (Function0)new Serializable(this, v){
                                public static final long serialVersionUID = 0L;
                                private final String v$1;

                                public final String apply() {
                                    return this.v$1;
                                }
                                {
                                    this.v$1 = v$1;
                                }
                            });
                            return string;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return var3_3;
    }

    public String loadDefaultCelebornProperties$default$2() {
        return null;
    }

    public String getDefaultPropertiesFile(scala.collection.immutable.Map<String, String> env) {
        return (String)env.get((Object)"CELEBORN_CONF_DIR").orElse((Function0)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map env$1;

            public final Option<String> apply() {
                return this.env$1.get((Object)"CELEBORN_HOME").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String t) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t, File.separator}));
                    }
                });
            }
            {
                this.env$1 = env$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String t) {
                return new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "celeborn-defaults.conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t, File.separator})));
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$7) {
                return x$7.isFile();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$8) {
                return x$8.getAbsolutePath();
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> getDefaultPropertiesFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String trimExceptCRLF(String str) {
        Serializable nonSpaceOrNaturalLineDelimiter = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char ch) {
                return ch > ' ' || ch == '\r' || ch == '\n';
            }
        };
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        return firstPos >= 0 && lastPos >= 0 ? str.substring(firstPos, lastPos + 1) : "";
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<String, String> getPropertiesFromFile(String filename) {
        scala.collection.immutable.Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Properties file ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        Predef$.MODULE$.require(file.isFile(), (Function0)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Properties file ", " is not a normal file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
            }
            {
                this.file$1 = file$1;
            }
        });
        InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            Properties properties = new Properties();
            properties.load(inReader);
            map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final Properties properties$1;

                public final Tuple2<String, String> apply(String k) {
                    return new Tuple2((Object)k, (Object)Utils$.MODULE$.trimExceptCRLF(this.properties$1.getProperty(k)));
                }
                {
                    this.properties$1 = properties$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException iOException) {
            try {
                throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed when loading Celeborn properties from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})), iOException);
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
        }
        inReader.close();
        return map;
    }

    public String makeShuffleKey(String applicationId, int shuffleId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationId, BoxesRunTime.boxToInteger((int)shuffleId)}));
    }

    public Tuple2<String, Object> splitShuffleKey(String shuffleKey) {
        String[] splits = shuffleKey.split("-");
        String appId = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])splits).dropRight(1)).mkString("-");
        int shuffleId = new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])splits).last())).toInt();
        return new Tuple2((Object)appId, (Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public Tuple2<Object, Object> splitPartitionLocationUniqueId(String uniqueId) {
        String[] splits = uniqueId.split("-");
        int partitionId = new StringOps(Predef$.MODULE$.augmentString(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])splits).dropRight(1)).mkString("-"))).toInt();
        int epoch = new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])splits).last())).toInt();
        return new Tuple2.mcII.sp(partitionId, epoch);
    }

    public String makeReducerKey(int shuffleId, int partitionId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)shuffleId), BoxesRunTime.boxToInteger((int)partitionId)}));
    }

    public String makeMapKey(String applicationId, int shuffleId, int mapId, int attemptId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationId, BoxesRunTime.boxToInteger((int)shuffleId), BoxesRunTime.boxToInteger((int)mapId), BoxesRunTime.boxToInteger((int)attemptId)}));
    }

    public String makeMapKey(int shuffleId, int mapId, int attemptId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)shuffleId), BoxesRunTime.boxToInteger((int)mapId), BoxesRunTime.boxToInteger((int)attemptId)}));
    }

    public String makeAttemptKey(int mapId, int attemptId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)mapId), BoxesRunTime.boxToInteger((int)attemptId)}));
    }

    public Tuple2<Object, Object> splitAttemptKey(String attemptKey) {
        String[] splits = attemptKey.split("-");
        int mapId = new StringOps(Predef$.MODULE$.augmentString(splits[0])).toInt();
        int attemptId = new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt();
        return new Tuple2.mcII.sp(mapId, attemptId);
    }

    public String shuffleKeyPrefix(String shuffleKey) {
        return new StringBuilder().append((Object)shuffleKey).append((Object)"-").toString();
    }

    public int bytesToInt(byte[] bytes, boolean bigEndian) {
        return bigEndian ? bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3] : bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
    }

    public boolean bytesToInt$default$2() {
        return true;
    }

    public long timeIt(Function0<BoxedUnit> f) {
        long start2 = System.currentTimeMillis();
        f.apply$mcV$sp();
        return System.currentTimeMillis() - start2;
    }

    public Utils.Lock org$apache$celeborn$common$util$Utils$$Lock(LockInfo lock) {
        return new Utils.Lock(lock);
    }

    public Seq<ThreadStackTrace> getThreadDump() {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ThreadInfo x$9) {
                return x$9 != null;
            }
        })).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ThreadInfo x0$3, ThreadInfo x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$1);
                if (tuple2 != null) {
                    String name2;
                    ThreadInfo threadTrace1 = (ThreadInfo)tuple2._1();
                    ThreadInfo threadTrace2 = (ThreadInfo)tuple2._2();
                    String name1 = threadTrace1.getThreadName().toLowerCase(Locale.ROOT);
                    int nameCmpRes = name1.compareTo(name2 = threadTrace2.getThreadName().toLowerCase(Locale.ROOT));
                    boolean bl = nameCmpRes == 0 ? threadTrace1.getThreadId() < threadTrace2.getThreadId() : nameCmpRes < 0;
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ThreadStackTrace apply(ThreadInfo threadInfo) {
                return Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$threadInfoToThreadStackTrace(threadInfo);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public ThreadStackTrace org$apache$celeborn$common$util$Utils$$threadInfoToThreadStackTrace(ThreadInfo threadInfo) {
        Thread.State threadState = threadInfo.getThreadState();
        scala.collection.immutable.Map monitors = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedMonitors()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(MonitorInfo m) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)m.getLockedStackDepth())), (Object)m.toString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        StackTrace stackTrace = new StackTrace((Seq<String>)((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])threadInfo.getStackTrace()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(threadInfo, threadState, monitors){
            public static final long serialVersionUID = 0L;
            private final ThreadInfo threadInfo$1;
            private final Thread.State threadState$1;
            private final scala.collection.immutable.Map monitors$1;

            public final String apply(Tuple2<StackTraceElement, Object> x0$4) {
                Tuple2<StackTraceElement, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    String string;
                    StackTraceElement frame = (StackTraceElement)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (idx == 0 && this.threadInfo$1.getLockInfo() != null) {
                        String string2;
                        Thread.State state = this.threadState$1;
                        if (((Object)((Object)Thread.State.BLOCKED)).equals((Object)((Object)state))) {
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t-  blocked on ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.threadInfo$1.getLockInfo()}));
                        } else {
                            boolean bl = ((Object)((Object)Thread.State.WAITING)).equals((Object)((Object)state)) ? true : ((Object)((Object)Thread.State.TIMED_WAITING)).equals((Object)((Object)state));
                            string2 = bl ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t-  waiting on ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.threadInfo$1.getLockInfo()})) : "";
                        }
                        string = string2;
                    } else {
                        string = "";
                    }
                    String locked = string;
                    String locking = (String)this.monitors$1.get((Object)BoxesRunTime.boxToInteger((int)idx)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String mi) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t-  locked ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mi}));
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    String string3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{frame.toString(), locked, locking}));
                    return string3;
                }
                throw new MatchError(tuple2);
            }
            {
                this.threadInfo$1 = threadInfo$1;
                this.threadState$1 = threadState$1;
                this.monitors$1 = monitors$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        String[] synchronizers = (String[])Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedSynchronizers()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LockInfo x$10) {
                return x$10.toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Seq monitorStrs = monitors.values().toSeq();
        return new ThreadStackTrace(threadInfo.getThreadId(), threadInfo.getThreadName(), threadState, stackTrace, (Option<Object>)(threadInfo.getLockOwnerId() < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)threadInfo.getLockOwnerId()))), (String)Option$.MODULE$.apply((Object)threadInfo.getLockInfo()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LockInfo x$11) {
                return Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$Lock(x$11).lockString();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (Seq<String>)((Seq)Predef$.MODULE$.refArrayOps((Object[])synchronizers).$plus$plus((GenTraversableOnce)monitorStrs, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])synchronizers), (Seq<String>)monitorStrs, (Option<String>)Option$.MODULE$.apply((Object)threadInfo.getLockName()), (Option<String>)Option$.MODULE$.apply((Object)threadInfo.getLockOwnerName()), threadInfo.isSuspended(), threadInfo.isInNative());
    }

    /*
     * WARNING - void declaration
     */
    private String readProcessStdout(Process process2) {
        String string;
        BufferedSource source = Source$.MODULE$.fromInputStream(process2.getInputStream(), Codec$.MODULE$.fallbackSystemCodec());
        try {
            string = source.mkString();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        source.close();
        return string;
    }

    public String runCommand(String cmd) {
        Process process2 = Runtime.getRuntime().exec(cmd);
        return this.readProcessStdout(process2);
    }

    public String runCommandComplex(String cmd) {
        String[] cmds = (String[])((Object[])new String[]{"/bin/sh", "-c", cmd});
        Process process2 = Runtime.getRuntime().exec(cmds);
        return this.readProcessStdout(process2);
    }

    public Process executeCommand(Seq<String> command, File workingDir, scala.collection.immutable.Map<String, String> extraEnvironment, boolean redirectStderr) {
        Object object;
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(environment){
            public static final long serialVersionUID = 0L;
            private final Map environment$1;

            public final String apply(Tuple2<String, String> x$12) {
                Tuple2<String, String> tuple2 = x$12;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = this.environment$1.put(key, value);
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.environment$1 = environment$1;
            }
        });
        Process process2 = builder.start();
        if (redirectStderr) {
            String threadName = new StringBuilder().append((Object)"redirect stderr for command ").append(command.head()).toString();
            object = this.processStreamByLine(threadName, process2.getErrorStream(), (Function1<String, BoxedUnit>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String s) {
                    Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$log$1(s);
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return process2;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public scala.collection.immutable.Map<String, String> executeCommand$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, scala.collection.immutable.Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process2 = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        StringBuilder output = new StringBuilder();
        String threadName = new StringBuilder().append((Object)"read stdout for ").append(command.head()).toString();
        Thread stdoutThread = this.processStreamByLine(threadName, process2.getInputStream(), (Function1<String, BoxedUnit>)new Serializable(output){
            public static final long serialVersionUID = 0L;
            private final StringBuilder output$1;

            public final void apply(String s) {
                Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$appendToOutput$1(s, this.output$1);
            }
            {
                this.output$1 = output$1;
            }
        });
        int exitCode = process2.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError((Function0<String>)new Serializable(command, output, exitCode){
                public static final long serialVersionUID = 0L;
                private final Seq command$1;
                private final StringBuilder output$1;
                private final int exitCode$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1, BoxesRunTime.boxToInteger((int)this.exitCode$1), this.output$1}));
                }
                {
                    this.command$1 = command$1;
                    this.output$1 = output$1;
                    this.exitCode$1 = exitCode$1;
                }
            });
            throw new CelebornException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " exited with code ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, BoxesRunTime.boxToInteger((int)exitCode)})));
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public scala.collection.immutable.Map<String, String> executeAndGetOutput$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = ThreadUtils$.MODULE$.newDaemonThread(new Runnable(inputStream, processLine){
            private final InputStream inputStream$1;
            public final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply(String line) {
                        this.$outer.processLine$1.apply((Object)line);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
            }
        }, threadName);
        t.start();
        return t;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File createDirectory(String root, String namePrefix) {
        attempts = 0;
        maxAttempts = 10;
        dir = null;
        while (true) {
            if (dir != null) {
                return dir.getCanonicalFile();
            }
            if (++attempts <= maxAttempts) ** GOTO lbl-1000
            throw new IOException(new StringBuilder().append((Object)"Failed to create a temp directory (under ").append((Object)root).append((Object)") after ").append((Object)BoxesRunTime.boxToInteger((int)maxAttempts)).append((Object)" attempts!").toString());
lbl-1000:
            // 1 sources

            {
                dir = new File(root, new StringBuilder().append((Object)namePrefix).append((Object)"-").append((Object)UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
                continue;
            }
            break;
        }
    }

    public String createDirectory$default$2() {
        return "celeborn";
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String root, String namePrefix) {
        void var3_3;
        File dir = this.createDirectory(root, namePrefix);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(dir){
            private final File dir$1;

            public void run() {
                if (this.dir$1 != null) {
                    JavaUtils.deleteRecursively(this.dir$1);
                }
            }
            {
                this.dir$1 = dir$1;
            }
        }));
        return var3_3;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "celeborn";
    }

    public String mkString(Seq<String> args, String sep) {
        return args.mkString(sep);
    }

    public String mkString$default$2() {
        return ",";
    }

    /*
     * WARNING - void declaration
     */
    public Map<WorkerInfo, Map<String, Integer>> getSlotsPerDisk(HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> slots) {
        void var2_2;
        HashMap workerSlotsDistribution = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1)new Serializable(workerSlotsDistribution){
            public static final long serialVersionUID = 0L;
            private final HashMap workerSlotsDistribution$1;

            public final Map<String, Integer> apply(Tuple2<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> x0$5) {
                Tuple2<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> tuple2 = x0$5;
                if (tuple2 != null) {
                    WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        List primaryPartitionLoc = (List)tuple22._1();
                        List replicaPartitionLoc = (List)tuple22._2();
                        HashMap<K, V> diskSlotsMap = new HashMap<K, V>();
                        this.countSlotsByDisk$1(primaryPartitionLoc, diskSlotsMap);
                        this.countSlotsByDisk$1(replicaPartitionLoc, diskSlotsMap);
                        Map map = this.workerSlotsDistribution$1.put(workerInfo, diskSlotsMap);
                        return map;
                    }
                }
                throw new MatchError(tuple2);
            }

            private final void countSlotsByDisk$1(List location, HashMap diskSlotsMap$1) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(location).asScala()).foreach((Function1)new Serializable(this, diskSlotsMap$1){
                    public static final long serialVersionUID = 0L;
                    private final HashMap diskSlotsMap$1;

                    public final Integer apply(PartitionLocation item) {
                        String mountPoint = item.getStorageInfo().getMountPoint();
                        return this.diskSlotsMap$1.containsKey(mountPoint) ? this.diskSlotsMap$1.put(mountPoint, Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int((Integer)this.diskSlotsMap$1.get(mountPoint)))) : this.diskSlotsMap$1.put(mountPoint, Predef$.MODULE$.int2Integer(1));
                    }
                    {
                        this.diskSlotsMap$1 = diskSlotsMap$1;
                    }
                });
            }
            {
                this.workerSlotsDistribution$1 = workerSlotsDistribution$1;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Integer> getSlotsPerDisk(List<PartitionLocation> masterLocations, List<PartitionLocation> workerLocations) {
        void var3_3;
        HashMap slotDistributions = new HashMap();
        ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(masterLocations).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workerLocations).asScala()).foreach((Function1)new Serializable(slotDistributions){
            public static final long serialVersionUID = 0L;
            private final HashMap slotDistributions$1;

            public final Integer apply(PartitionLocation location) {
                String mountPoint = location.getStorageInfo().getMountPoint();
                return this.slotDistributions$1.containsKey(mountPoint) ? this.slotDistributions$1.put(mountPoint, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)this.slotDistributions$1.get(mountPoint)) + 1)) : this.slotDistributions$1.put(mountPoint, Predef$.MODULE$.int2Integer(1));
            }
            {
                this.slotDistributions$1 = slotDistributions$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(masterLocations, workerLocations, slotDistributions){
            public static final long serialVersionUID = 0L;
            private final List masterLocations$1;
            private final List workerLocations$1;
            private final HashMap slotDistributions$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"locations to distribution, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.masterLocations$1).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(PartitionLocation x$13) {
                        return x$13.toString();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.workerLocations$1).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(PartitionLocation x$14) {
                        return x$14.toString();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.slotDistributions$1}))).toString();
            }
            {
                this.masterLocations$1 = masterLocations$1;
                this.workerLocations$1 = workerLocations$1;
                this.slotDistributions$1 = slotDistributions$1;
            }
        });
        return var3_3;
    }

    public <T> T tryWithTimeoutAndCallback(Function0<T> block, Function0<T> callback, ThreadPoolExecutor threadPool, long timeoutInSeconds, String errorMessage) {
        Object object;
        Callable futureTask = new Callable<T>(block){
            private final Function0 block$1;

            public T call() {
                return (T)this.block$1.apply();
            }
            {
                this.block$1 = block$1;
            }
        };
        Future future = null;
        try {
            try {
                future = threadPool.submit(futureTask);
                object = future.get(timeoutInSeconds, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (TimeoutException timeoutException) {
                this.logError((Function0<String>)new Serializable(errorMessage){
                    public static final long serialVersionUID = 0L;
                    private final String errorMessage$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TimeoutException in thread ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Thread.currentThread().getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" error message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.errorMessage$1}))).toString();
                    }
                    {
                        this.errorMessage$1 = errorMessage$1;
                    }
                });
                object = callback.apply();
            }
        }
        finally {
            if (future != null && !future.isCancelled()) {
                future.cancel(true);
            }
        }
        return object;
    }

    public <T> long tryWithTimeoutAndCallback$default$4(Function0<T> block, Function0<T> callback) {
        return 10L;
    }

    public <T> String tryWithTimeoutAndCallback$default$5(Function0<T> block, Function0<T> callback) {
        return "none";
    }

    public <R extends Closeable, U> U tryWithResources(Function0<R> f, Function1<R, U> func) {
        try (Closeable res = (Closeable)f.apply();){
            return (U)func.apply(f.apply());
        }
    }

    public Object toTransportMessage(Object message) {
        Object object;
        Object object2 = message;
        if (object2 instanceof Message) {
            Message message2 = (Message)object2;
            object = ControlMessages$.MODULE$.toTransportMessage(message2);
        } else if (object2 instanceof GeneratedMessageV3) {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)object2;
            object = ControlMessages$.MODULE$.toTransportMessage(generatedMessageV3);
        } else {
            object = message;
        }
        return object;
    }

    public Object fromTransportMessage(Object message) {
        Object object;
        Object object2 = message;
        if (object2 instanceof TransportMessage) {
            TransportMessage transportMessage = (TransportMessage)object2;
            object = ControlMessages$.MODULE$.fromTransportMessage(transportMessage);
        } else {
            object = message;
        }
        return object;
    }

    public PartitionSplitMode toShuffleSplitMode(int mode) {
        PartitionSplitMode partitionSplitMode;
        int n = mode;
        switch (n) {
            default: {
                this.logWarning((Function0<String>)new Serializable(mode){
                    public static final long serialVersionUID = 0L;
                    private final int mode$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid shuffle mode ", ", fallback to soft"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mode$1)}));
                    }
                    {
                        this.mode$1 = mode$1;
                    }
                });
                partitionSplitMode = PartitionSplitMode.SOFT;
                break;
            }
            case 1: {
                partitionSplitMode = PartitionSplitMode.HARD;
                break;
            }
            case 0: {
                partitionSplitMode = PartitionSplitMode.SOFT;
            }
        }
        return partitionSplitMode;
    }

    public PartitionType toPartitionType(int value) {
        PartitionType partitionType;
        int n = value;
        switch (n) {
            default: {
                this.logWarning((Function0<String>)new Serializable(value){
                    public static final long serialVersionUID = 0L;
                    private final int value$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid partitionType ", ", fallback to ReducePartition"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.value$1)}));
                    }
                    {
                        this.value$1 = value$1;
                    }
                });
                partitionType = PartitionType.REDUCE;
                break;
            }
            case 2: {
                partitionType = PartitionType.MAPGROUP;
                break;
            }
            case 1: {
                partitionType = PartitionType.MAP;
                break;
            }
            case 0: {
                partitionType = PartitionType.REDUCE;
            }
        }
        return partitionType;
    }

    public DiskStatus toDiskStatus(int value) {
        DiskStatus diskStatus;
        int n = value;
        switch (n) {
            default: {
                diskStatus = null;
                break;
            }
            case 4: {
                diskStatus = DiskStatus.CRITICAL_ERROR;
                break;
            }
            case 3: {
                diskStatus = DiskStatus.HIGH_DISK_USAGE;
                break;
            }
            case 2: {
                diskStatus = DiskStatus.IO_HANG;
                break;
            }
            case 1: {
                diskStatus = DiskStatus.READ_OR_WRITE_FAILURE;
                break;
            }
            case 0: {
                diskStatus = DiskStatus.HEALTHY;
            }
        }
        return diskStatus;
    }

    public String getPeerPath(String path) {
        return path.endsWith("0") ? new StringBuilder().append((Object)path.substring(0, path.length() - 1)).append((Object)"1").toString() : new StringBuilder().append((Object)path.substring(0, path.length() - 1)).append((Object)"0").toString();
    }

    public String SORTED_SUFFIX() {
        return this.SORTED_SUFFIX;
    }

    public String INDEX_SUFFIX() {
        return this.INDEX_SUFFIX;
    }

    public String SUFFIX_HDFS_WRITE_SUCCESS() {
        return this.SUFFIX_HDFS_WRITE_SUCCESS;
    }

    public String COMPATIBLE_HDFS_REGEX() {
        return this.COMPATIBLE_HDFS_REGEX;
    }

    public String S3_REGEX() {
        return this.S3_REGEX;
    }

    public String OSS_REGEX() {
        return this.OSS_REGEX;
    }

    public int UNKNOWN_APP_SHUFFLE_ID() {
        return this.UNKNOWN_APP_SHUFFLE_ID;
    }

    public boolean isHdfsPath(String path) {
        return path.matches(this.COMPATIBLE_HDFS_REGEX());
    }

    public boolean isS3Path(String path) {
        return path.matches(this.S3_REGEX());
    }

    public boolean isOssPath(String path) {
        return path.matches(this.OSS_REGEX());
    }

    public String getSortedFilePath(String path) {
        return new StringBuilder().append((Object)path).append((Object)this.SORTED_SUFFIX()).toString();
    }

    public String getIndexFilePath(String path) {
        return new StringBuilder().append((Object)path).append((Object)this.INDEX_SUFFIX()).toString();
    }

    public String getWriteSuccessFilePath(String path) {
        return new StringBuilder().append((Object)path).append((Object)this.SUFFIX_HDFS_WRITE_SUCCESS()).toString();
    }

    public ByteString roaringBitmapToByteString(RoaringBitmap roaringBitMap) {
        ByteString byteString;
        if (roaringBitMap == null || roaringBitMap.isEmpty()) {
            byteString = ByteString.EMPTY;
        } else {
            ByteBuffer buf = ByteBuffer.allocate(roaringBitMap.serializedSizeInBytes());
            roaringBitMap.serialize(buf);
            buf.rewind();
            byteString = ByteString.copyFrom(buf);
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    public RoaringBitmap byteStringToRoaringBitmap(ByteString bytes) {
        RoaringBitmap roaringBitmap;
        if (bytes.isEmpty()) {
            roaringBitmap = null;
        } else {
            void var2_2;
            RoaringBitmap roaringBitmap2 = new RoaringBitmap();
            ByteBuffer buf = bytes.asReadOnlyByteBuffer();
            buf.rewind();
            roaringBitmap2.deserialize(buf);
            roaringBitmap = var2_2;
        }
        return roaringBitmap;
    }

    /*
     * WARNING - void declaration
     */
    public int checkedDownCast(long value) {
        void var3_2;
        int downCast = (int)value;
        if ((long)downCast != value) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot downcast long value ").append((Object)BoxesRunTime.boxToLong((long)value)).append((Object)" to integer.").toString());
        }
        return (int)var3_2;
    }

    public void checkFileIntegrity(FileChannel fileChannel, int length) throws IOException {
        long remainingBytes = fileChannel.size() - fileChannel.position();
        if (remainingBytes < (long)length) {
            this.logError((Function0<String>)new Serializable(length, remainingBytes){
                public static final long serialVersionUID = 0L;
                private final int length$1;
                private final long remainingBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File remaining bytes not not enough, remaining: ", ", wanted: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.remainingBytes$1), BoxesRunTime.boxToInteger((int)this.length$1)}));
                }
                {
                    this.length$1 = length$1;
                    this.remainingBytes$1 = remainingBytes$1;
                }
            });
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File is corrupted ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileChannel})));
        }
    }

    public Tuple2<String, String> parseMetricLabels(String label) {
        String[] labelPart = label.split("=");
        if (Predef$.MODULE$.refArrayOps((Object[])labelPart).size() != 2) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal metric extra labels: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label})));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)labelPart[0].trim()), (Object)labelPart[1].trim());
    }

    public String getProcessId() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    private FastDateFormat dateFmt() {
        return this.dateFmt;
    }

    public String formatTimestamp(long timestamp) {
        return this.dateFmt().format(timestamp);
    }

    public String[] parseColonSeparatedHostPorts(String id, int portsNum) {
        String[] components = id.split(":");
        String[] portsArr = (String[])Predef$.MODULE$.refArrayOps((Object[])components).takeRight(portsNum);
        String host = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])components).dropRight(portsNum)).mkString(":");
        return (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{host}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])portsArr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public String org$apache$celeborn$common$util$Utils$$REDACTION_REPLACEMENT_TEXT() {
        return this.org$apache$celeborn$common$util$Utils$$REDACTION_REPLACEMENT_TEXT;
    }

    public Seq<Tuple2<String, String>> redact(CelebornConf conf, Seq<Tuple2<String, String>> kvs) {
        Regex redactionPattern = conf.secretRedactionPattern();
        return this.redact(redactionPattern, kvs);
    }

    private <K, V> Seq<Tuple2<K, V>> redact(Regex redactionPattern, Seq<Tuple2<K, V>> kvs) {
        return (Seq)kvs.map((Function1)new Serializable(redactionPattern){
            public static final long serialVersionUID = 0L;
            public final Regex redactionPattern$1;

            public final Tuple2<Object, Object> apply(Tuple2<K, V> x0$6) {
                Tuple2<K, V> tuple2;
                block5: {
                    Tuple2 tuple22;
                    block3: {
                        block4: {
                            block2: {
                                tuple2 = x0$6;
                                if (tuple2 == null) break block2;
                                Object key = tuple2._1();
                                Object value = tuple2._2();
                                if (!(key instanceof String)) break block2;
                                String string = (String)key;
                                if (!(value instanceof String)) break block2;
                                String string2 = (String)value;
                                tuple22 = (Tuple2)this.redactionPattern$1.findFirstIn((CharSequence)string).orElse((Function0)new Serializable(this, string2){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.redact.1 $outer;
                                    private final String x3$1;

                                    public final Option<String> apply() {
                                        return this.$outer.redactionPattern$1.findFirstIn((CharSequence)this.x3$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.x3$1 = x3$1;
                                    }
                                }).map((Function1)new Serializable(this, string){
                                    public static final long serialVersionUID = 0L;
                                    private final String x2$1;

                                    public final Tuple2<String, String> apply(String x$15) {
                                        return new Tuple2((Object)this.x2$1, (Object)Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$REDACTION_REPLACEMENT_TEXT());
                                    }
                                    {
                                        this.x2$1 = x2$1;
                                    }
                                }).getOrElse((Function0)new Serializable(this, string, string2){
                                    public static final long serialVersionUID = 0L;
                                    private final String x2$1;
                                    private final String x3$1;

                                    public final Tuple2<String, String> apply() {
                                        return new Tuple2((Object)this.x2$1, (Object)this.x3$1);
                                    }
                                    {
                                        this.x2$1 = x2$1;
                                        this.x3$1 = x3$1;
                                    }
                                });
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            Object key = tuple2._1();
                            Object value = tuple2._2();
                            if (!(value instanceof String)) break block4;
                            String string = (String)value;
                            tuple22 = (Tuple2)this.redactionPattern$1.findFirstIn((CharSequence)string).map((Function1)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final Object key$1;

                                public final Tuple2<K, String> apply(String x$16) {
                                    return new Tuple2(this.key$1, (Object)Utils$.MODULE$.org$apache$celeborn$common$util$Utils$$REDACTION_REPLACEMENT_TEXT());
                                }
                                {
                                    this.key$1 = key$1;
                                }
                            }).getOrElse((Function0)new Serializable(this, key, string){
                                public static final long serialVersionUID = 0L;
                                private final Object key$1;
                                private final String x4$1;

                                public final Tuple2<K, String> apply() {
                                    return new Tuple2(this.key$1, (Object)this.x4$1);
                                }
                                {
                                    this.key$1 = key$1;
                                    this.x4$1 = x4$1;
                                }
                            });
                            break block3;
                        }
                        if (tuple2 == null) break block5;
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        tuple22 = new Tuple2(key, value);
                    }
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.redactionPattern$1 = redactionPattern$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public <T> T instantiate(String className, ClassTag<T> tag) {
        this.logDebug((Function0<String>)new Serializable(className){
            public static final long serialVersionUID = 0L;
            private final String className$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating instance of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1}));
            }
            {
                this.className$1 = className$1;
            }
        });
        Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        try {
            Constructor<?> ctor = clazz.getDeclaredConstructor(new Class[0]);
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using no-arg constructor";
                }
            });
            return (T)ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logError((Function0<String>)new Serializable(className){
                public static final long serialVersionUID = 0L;
                private final String className$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to instantiate class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.className$1}));
                }
                {
                    this.className$1 = className$1;
                }
            }, noSuchMethodException);
            throw noSuchMethodException;
        }
    }

    public boolean isCriticalCauseForFetch(Exception e) {
        boolean rpcTimeout = e instanceof IOException && e.getCause() != null && e.getCause() instanceof TimeoutException;
        boolean connectException = e instanceof CelebornIOException && e.getMessage() != null && (e.getMessage().startsWith("Connecting to") || e.getMessage().startsWith("Failed to"));
        boolean fetchChunkTimeout = e instanceof CelebornIOException && e.getCause() != null && e.getCause() instanceof IOException;
        return connectException || rpcTimeout || fetchChunkTimeout;
    }

    public String makeOpenStreamRequestId(String shuffleKey, String clientChannelId, long rpcRequestId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shuffleKey, clientChannelId, BoxesRunTime.boxToLong((long)rpcRequestId)}));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withRetryOnTimeoutOrIOException(int numRetries, long retryWait, Function0<T> block) {
        IntRef retriesLeft = IntRef.create((int)numRetries);
        if (retriesLeft.elem < 0) {
            return null;
        }
        --retriesLeft.elem;
        return (T)block.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 setDefaultPortValue$1(String hostPort$1) {
        void var2_2;
        Tuple2 retval = new Tuple2((Object)hostPort$1, (Object)BoxesRunTime.boxToInteger((int)0));
        this.hostPortParseResults().put(hostPort$1, (Tuple2<String, Object>)retval);
        return var2_2;
    }

    public final void org$apache$celeborn$common$util$Utils$$log$1(String s) {
        this.logInfo((Function0<String>)new Serializable(s){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final String apply() {
                return this.s$1;
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public final void org$apache$celeborn$common$util$Utils$$appendToOutput$1(String s, StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void waitOrThrow$1(Throwable e, long retryWait$1, IntRef retriesLeft$1) {
        if (retriesLeft$1.elem <= 0) throw e;
        int retryWaitMs = new Random().nextInt((int)retryWait$1);
        try {
            TimeUnit.MILLISECONDS.sleep(retryWaitMs);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw e;
        }
    }

    private Utils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.siByteSizes = new long[]{0x1000000000000000L, 0x4000000000000L, 0x10000000000L, 0x40000000L, 0x100000L, 1024L, 1L};
        this.siByteSuffixes = (String[])((Object[])new String[]{"EiB", "PiB", "TiB", "GiB", "MiB", "KiB", "B"});
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC_OSX;
        this.isMacOnAppleSilicon = SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_ARCH.equals("aarch64");
        this.customHostname = scala.sys.package$.MODULE$.env().get((Object)"CELEBORN_LOCAL_HOSTNAME");
        this.hostPortParseResults = JavaUtils.newConcurrentHashMap();
        this.maxDefaultNettyThreads = 64;
        this.SORTED_SUFFIX = ".sorted";
        this.INDEX_SUFFIX = ".index";
        this.SUFFIX_HDFS_WRITE_SUCCESS = ".success";
        this.COMPATIBLE_HDFS_REGEX = "^(?!s3://)(?!s3a://)(?!oss://)[a-zA-Z0-9]+://.*";
        this.S3_REGEX = "^s3[a]?://([a-z0-9][a-z0-9-]{1,61}[a-z0-9])(/.*)?$";
        this.OSS_REGEX = "^oss?://([a-z0-9][a-z0-9-]{1,61}[a-z0-9])(/.*)?$";
        this.UNKNOWN_APP_SHUFFLE_ID = -1;
        this.dateFmt = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT);
        this.org$apache$celeborn$common$util$Utils$$REDACTION_REPLACEMENT_TEXT = "*********(redacted)";
    }
}

